/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.lang;

import java.math.RoundingMode;
import java.text.DecimalFormat;

public class CBNum {
    public static String format(double num, int fractionalLen) {
        return CBNum.format(num, fractionalLen, true);
    }

    public static String format(double num, int fractionalLen, RoundingMode roundingMode) {
        return CBNum.format(num, fractionalLen, true, roundingMode);
    }

    public static String format(double num, int fractionalLen, boolean fixed) {
        return CBNum.format(num, fractionalLen, fixed, RoundingMode.HALF_EVEN);
    }

    public static String format(double num, int fractionalLen, boolean fixed, RoundingMode roundingMode) {
        DecimalFormat format = new DecimalFormat("0." + CBNum.generatePattern(fractionalLen, fixed));
        format.setRoundingMode(roundingMode);
        return format.format(num);
    }

    public static String percent(double num) {
        return CBNum.percent(num, 2);
    }

    public static String percent(double num, int fractionalLen) {
        return CBNum.percent(num, fractionalLen, RoundingMode.HALF_EVEN);
    }

    public static String percent(double num, int fractionalLen, RoundingMode roundingMode) {
        return CBNum.format(num * 100.0, fractionalLen, true, roundingMode);
    }

    private static String generatePattern(int len, boolean fixed) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            builder.append(fixed ? "0" : "#");
        }
        return builder.toString();
    }
}

