/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.net.core;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import me.codeboy.tools.io.CBLog;
import me.codeboy.tools.net.core.CBContentType;
import me.codeboy.tools.net.exception.CBNetworkException;
import me.codeboy.tools.net.util.CBParam;

public class CBBody {
    private String data = "";
    private Map<String, String> multipartFields;
    private Map<String, ? extends File> multipartFiles;
    private Charset charset = StandardCharsets.UTF_8;
    private CBContentType contentType = CBContentType.FORM;

    public static CBBody formRaw(String data) {
        return CBBody.formRaw(StandardCharsets.UTF_8, data);
    }

    public static CBBody formRaw(Charset charset, String data) {
        CBBody body = new CBBody();
        body.charset = charset;
        body.contentType = CBContentType.FORM;
        body.data = data;
        return body;
    }

    public static CBBody form(String data) {
        return CBBody.form(StandardCharsets.UTF_8, data);
    }

    public static CBBody form(Charset charset, String data) {
        String[] items = data.split("&");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (String item : items) {
            int equalPos = item.indexOf("=");
            if (equalPos == -1) {
                CBLog.warn("body param doesn't correct!!");
                continue;
            }
            params.put(item.substring(0, equalPos), item.substring(equalPos + 1));
        }
        return CBBody.form(charset, params);
    }

    public static CBBody form(String ... data) {
        return CBBody.form(StandardCharsets.UTF_8, data);
    }

    public static CBBody form(Map<String, String> data) {
        return CBBody.form(StandardCharsets.UTF_8, data);
    }

    public static CBBody form(Charset charset, String ... data) {
        CBBody body = new CBBody();
        body.charset = charset;
        body.contentType = CBContentType.FORM;
        if (data.length % 2 == 0) {
            body.data = CBParam.combine(body.charset, data);
        }
        return body;
    }

    public static CBBody form(Charset charset, Map<String, String> data) {
        CBBody body = new CBBody();
        body.charset = charset;
        body.contentType = CBContentType.FORM;
        if (data != null) {
            body.data = CBParam.combine(body.charset, data);
        }
        return body;
    }

    public static CBBody multipartForm(Map<String, String> fields, Map<String, ? extends File> files) {
        CBBody body = new CBBody();
        body.contentType = CBContentType.MULTIPART_FORM;
        body.multipartFields = fields;
        body.multipartFiles = files;
        return body;
    }

    public static CBBody json(String data) {
        CBBody body = new CBBody();
        body.contentType = CBContentType.JSON;
        if (body.data != null) {
            body.data = data;
        }
        return body;
    }

    public String toString() {
        return this.data;
    }

    protected String body() {
        if (this.contentType == CBContentType.MULTIPART_FORM) {
            throw new CBNetworkException("get call body method when the content-type is multipart/form-data ");
        }
        return this.data;
    }

    protected Map<String, String> multipartFields() {
        if (this.multipartFields == null) {
            this.multipartFields = new LinkedHashMap<String, String>();
        }
        return this.multipartFields;
    }

    protected Map<String, ? extends File> multipartFiles() {
        if (this.multipartFiles == null) {
            this.multipartFiles = new LinkedHashMap<String, File>();
        }
        return this.multipartFiles;
    }

    protected CBContentType contentType() {
        return this.contentType;
    }

    protected String boundary() {
        return this.contentType.boundary();
    }
}

