/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.net.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.codeboy.tools.io.CBLog;
import me.codeboy.tools.lang.CBString;
import me.codeboy.tools.net.core.CBBody;
import me.codeboy.tools.net.core.CBContentType;
import me.codeboy.tools.net.core.CBFormFile;
import me.codeboy.tools.net.core.CBMethod;
import me.codeboy.tools.net.core.CBResponse;
import me.codeboy.tools.net.exception.CBNetworkException;
import me.codeboy.tools.net.util.CBCookieUtil;

public abstract class CBConnection {
    public static final String HEADER_MOCK_PC_UA = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.41 Safari/537.36 Edg/101.0.1210.32";
    private static final int DEFAULT_TIMEOUT = 30000;
    private String url = null;
    private int timeout = 30000;
    private CBMethod method = CBMethod.GET;
    private CBBody body = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private Charset charset = StandardCharsets.UTF_8;
    private static final CookieManager cookieManager = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
    private static final String LINE_FEED = "\r\n";
    private boolean executed = false;
    private boolean allowCustomOrigin = false;
    private boolean useMemoryCookie = false;
    private final Map<String, String> cookies = new LinkedHashMap<String, String>();

    public CBConnection head(String url) {
        return this.get(url, this.charset);
    }

    public CBConnection options(String url) {
        return this.method(CBMethod.OPTIONS, url);
    }

    public CBConnection put(String url) {
        return this.method(CBMethod.PUT, url);
    }

    public CBConnection delete(String url) {
        return this.method(CBMethod.DELETE, url);
    }

    public CBConnection get(String url) {
        return this.get(url, this.charset);
    }

    public CBConnection get(String url, Charset charset) {
        return this.connection(CBMethod.GET, url, charset);
    }

    public CBConnection post(String url) {
        return this.post(url, this.charset);
    }

    public CBConnection post(String url, Charset charset) {
        return this.connection(CBMethod.POST, url, charset);
    }

    public CBConnection method(CBMethod method, String url) {
        return this.connection(method, url, this.charset);
    }

    protected CBConnection connection(CBMethod method, String url, Charset charset) {
        this.method = method;
        this.url = url;
        this.charset = charset;
        return this;
    }

    public CBConnection cookie(String cookie) {
        this.cookie(CBCookieUtil.parse(cookie));
        return this;
    }

    public CBConnection cookie(String key, String value) {
        this.cookies.put(key, value);
        return this;
    }

    public CBConnection cookie(Map<String, String> cookie) {
        if (cookie != null) {
            this.cookies.putAll(cookie);
        }
        return this;
    }

    public CBConnection timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public CBConnection origin(String origin) {
        this.allowCustomOrigin();
        this.headers.put("origin", origin);
        return this;
    }

    public CBConnection referrer(String referrer) {
        this.headers.put("referer", referrer);
        return this;
    }

    public CBConnection allowCustomOrigin() {
        if (this.allowCustomOrigin) {
            return this;
        }
        try {
            Field field = Class.forName("sun.net.www.protocol.http.HttpURLConnection").getDeclaredField("restrictedHeaderSet");
            field.setAccessible(true);
            Set restrictedHeaderSet = (Set)field.get(null);
            restrictedHeaderSet.remove("origin");
            this.allowCustomOrigin = true;
        }
        catch (Exception e) {
            CBLog.warn("open origin switch error", e);
        }
        return this;
    }

    public CBConnection userAgent(String userAgent) {
        this.headers.put("user-agent", userAgent);
        return this;
    }

    public CBConnection headers(Map<String, String> headers) {
        if (headers != null) {
            this.headers = headers;
        } else {
            this.headers.clear();
        }
        return this;
    }

    public CBConnection header(String key, String value) {
        if (key != null && value != null) {
            this.headers.put(key.toLowerCase(), value);
        }
        return this;
    }

    public CBConnection body(CBBody body) {
        this.body = body;
        return this;
    }

    public static boolean clearCookie() {
        return cookieManager.getCookieStore().removeAll();
    }

    public CBConnection withMemCookie() {
        this.useMemoryCookie = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CBResponse execute() {
        if (this.executed) {
            throw new CBNetworkException("the request has executed");
        }
        this.executed = true;
        CBResponse response = new CBResponse(this);
        if (CBString.isEmptyOrNull(this.url)) {
            response.setMsg("url is missing");
            return response;
        }
        try {
            URL url = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(this.method.value);
            if (this.useMemoryCookie) {
                List<HttpCookie> httpCookies = cookieManager.getCookieStore().get(URI.create(this.url));
                String string = url.getPath();
                for (HttpCookie httpCookie : httpCookies) {
                    if (!string.startsWith(httpCookie.getPath())) continue;
                    String key = httpCookie.getName();
                    if (this.cookies.containsKey(key)) {
                        CBLog.warn("The same cookie is found, the priority set by the user is higher");
                        continue;
                    }
                    this.cookies.put(key, httpCookie.getValue());
                }
            }
            if (!this.headers.containsKey("user-agent")) {
                this.headers.put("user-agent", HEADER_MOCK_PC_UA);
            }
            if (!this.headers.containsKey("origin")) {
                void var5_10;
                int port = url.getPort();
                String string = "";
                if (port != -1) {
                    String string2 = ":" + url.getPort();
                }
                this.headers.put("origin", url.getProtocol() + "//" + url.getHost() + (String)var5_10);
            }
            if (!this.headers.containsKey("accept")) {
                this.headers.put("accept", "*/*");
            }
            if (!this.headers.containsKey("cookie")) {
                StringBuilder allCookies = new StringBuilder();
                for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
                    String key = entry.getKey();
                    String value2 = entry.getValue();
                    if (key == null || value2 == null) continue;
                    allCookies.append(key);
                    allCookies.append("=");
                    allCookies.append(value2);
                    allCookies.append("; ");
                }
                if (allCookies.length() > 0) {
                    this.headers.put("cookie", allCookies.toString().trim());
                }
            }
            for (Map.Entry entry : this.headers.entrySet()) {
                conn.setRequestProperty(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
            }
            conn.setConnectTimeout(this.timeout);
            conn.setReadTimeout(this.timeout);
            conn.setInstanceFollowRedirects(false);
            if ((this.method == CBMethod.POST || this.method == CBMethod.PUT || this.method == CBMethod.DELETE) & this.body != null) {
                conn.setDoOutput(true);
                String headerContentType = this.body.contentType().string(this.charset.name());
                conn.setRequestProperty("content-type", headerContentType);
                this.headers.put("content-type", headerContentType);
                OutputStream outputStream = conn.getOutputStream();
                switch (this.body.contentType()) {
                    case FORM: 
                    case JSON: {
                        outputStream.write(this.body.body().getBytes(this.charset));
                        break;
                    }
                    case MULTIPART_FORM: {
                        Map<String, String> map = this.body.multipartFields();
                        Map<String, ? extends File> multipartFiles = this.body.multipartFiles();
                        String boundary = this.body.boundary();
                        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, this.charset), true);
                        map.forEach((name, value) -> this.addMultipartField(writer, (String)name, (String)value, boundary));
                        multipartFiles.forEach((fileKey, file) -> {
                            try {
                                String contentType = "";
                                contentType = file instanceof CBFormFile ? ((CBFormFile)file).getContentType() : URLConnection.guessContentTypeFromName(file.getName());
                                this.addMultipartFile(writer, outputStream, (String)fileKey, (File)file, contentType, boundary);
                            }
                            catch (IOException e) {
                                CBLog.warn("write multiform data error", e);
                            }
                        });
                        writer.flush();
                        writer.append("--").append(boundary).append("--").append(LINE_FEED);
                        writer.close();
                    }
                }
                outputStream.flush();
                outputStream.close();
            }
            InputStream inputStream = conn.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            int len = 0;
            while ((len = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, len);
            }
            inputStream.close();
            response.setStatusCode(conn.getResponseCode());
            response.setBody(byteArrayOutputStream.toByteArray());
            HashMap<String, String> headers = new HashMap<String, String>();
            Map<String, List<String>> responseHeaders = conn.getHeaderFields();
            cookieManager.put(URI.create(this.url), responseHeaders);
            for (String key : responseHeaders.keySet()) {
                if (key == null) continue;
                List<String> values = responseHeaders.get(key);
                headers.put(key.toLowerCase(), CBString.join(values, ";"));
            }
            response.setHeaders(headers);
            String responseContentType = (String)headers.get("content-type");
            if (!CBString.isEmptyOrNull(responseContentType)) {
                int index = responseContentType.indexOf("charset=");
                if (index == -1) {
                    response.setCharset(this.charset);
                } else {
                    String responseCharset = responseContentType.substring(index + 8);
                    int index2 = responseCharset.indexOf(";");
                    if (index2 != -1) {
                        responseCharset = responseCharset.substring(0, index2);
                    }
                    try {
                        response.setCharset(Charset.forName(responseCharset));
                    }
                    catch (IllegalArgumentException e) {
                        response.setCharset(this.charset);
                    }
                }
            } else {
                response.setCharset(this.charset);
            }
        }
        catch (Exception e) {
            CBLog.warn("network error", e);
            response.setMsg(e.getMessage());
        }
        return response;
    }

    private void addMultipartField(PrintWriter writer, String name, String value, String boundary) {
        writer.append("--").append(boundary).append(LINE_FEED);
        writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"").append(LINE_FEED);
        writer.append("Content-Type: text/plain; charset=").append(String.valueOf(this.charset)).append(LINE_FEED);
        writer.append(LINE_FEED);
        writer.append(value).append(LINE_FEED);
        writer.flush();
    }

    private void addMultipartFile(PrintWriter writer, OutputStream outputStream, String fileKey, File file, String contentType, String boundary) throws IOException {
        writer.append("--").append(boundary).append(LINE_FEED);
        writer.append("Content-Disposition: form-data; name=\"").append(fileKey).append("\"; filename=\"").append(file.getName()).append("\"").append(LINE_FEED);
        writer.append("Content-Type: ").append(contentType).append(LINE_FEED);
        writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        writer.append(LINE_FEED);
        writer.flush();
        FileInputStream inputStream = new FileInputStream(file);
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
        inputStream.close();
        writer.append(LINE_FEED);
        writer.flush();
    }

    public boolean save(File file) throws IOException {
        CBResponse response = this.execute();
        if (!response.success()) {
            return false;
        }
        OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        byte[] body = response.body();
        os.write(body, 0, body.length);
        os.flush();
        os.close();
        return true;
    }

    protected String getCurlCommand() {
        StringBuilder command = new StringBuilder("curl");
        if (this.method != CBMethod.GET) {
            command.append(" -X ");
            command.append(this.method.value);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            String key = entry.getKey().toLowerCase();
            String value = entry.getValue();
            if ("content-type".equals(key) && this.body.contentType() == CBContentType.MULTIPART_FORM) continue;
            command.append(" -H '");
            command.append(key);
            command.append(": ");
            command.append(value);
            command.append("'");
        }
        switch (this.body.contentType()) {
            case FORM: {
                command.append(" --data-binary '");
                command.append(this.body.body());
                command.append("'");
                break;
            }
            case JSON: {
                command.append(" --data-raw '");
                command.append(this.body.body());
                command.append("'");
                break;
            }
            case MULTIPART_FORM: {
                for (Map.Entry<String, Object> entry : this.body.multipartFiles().entrySet()) {
                    command.append(" -F '");
                    command.append(entry.getKey());
                    command.append("=@");
                    command.append(entry.getValue());
                    command.append("'");
                }
                for (Map.Entry<String, Object> entry : this.body.multipartFields().entrySet()) {
                    command.append(" -F '");
                    command.append(entry.getKey());
                    command.append("=");
                    command.append((String)entry.getValue());
                    command.append("'");
                }
                break;
            }
        }
        command.append(" ");
        command.append(this.url);
        return command.toString();
    }
}

