/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.net.core;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import me.codeboy.tools.net.core.CBConnection;
import me.codeboy.tools.net.util.CBCookieUtil;

public class CBResponse {
    private final CBConnection connection;
    private Map<String, String> headers;
    private boolean success;
    private int statusCode;
    private String msg;
    private byte[] body;
    private Charset charset;

    CBResponse(CBConnection connection) {
        this.connection = connection;
    }

    public Map<String, String> headers() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers;
    }

    protected void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean success() {
        return this.success;
    }

    protected void setSuccess(boolean success) {
        this.success = success;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String location() {
        return this.headers().get("location");
    }

    public String cookie() {
        return this.headers().get("set-cookie");
    }

    public Map<String, String> cookieAsMap() {
        return CBCookieUtil.parse(this.headers().get("set-cookie"));
    }

    protected void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        this.success = statusCode >= 200 && statusCode < 400;
    }

    public byte[] body() {
        return this.body;
    }

    public String bodyString() {
        if (this.body == null) {
            return "";
        }
        return new String(this.body, this.charset);
    }

    public String bodyString(Charset charset) {
        if (this.body == null) {
            return "";
        }
        return new String(this.body, charset);
    }

    protected void setBody(byte[] body) {
        this.body = body;
    }

    protected void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String msg() {
        return this.msg;
    }

    protected void setMsg(String msg) {
        this.msg = msg;
    }

    public String getCurlCommand() {
        return this.connection.getCurlCommand();
    }

    public String toString() {
        return "CBResponse{statusCode=" + this.statusCode + ", success=" + this.success + ", headers=" + this.headers + ", msg='" + this.msg + '\'' + ", body='" + this.bodyString() + '\'' + '}';
    }
}

