/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.net.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.codeboy.tools.io.CBLog;
import me.codeboy.tools.lang.CBString;

public class CBCookieUtil {
    private static final List<String> COOKIE_PROPERTIES1 = new ArrayList<String>();
    private static final List<String> COOKIE_PROPERTIES2 = new ArrayList<String>();

    public static Map<String, String> parse(String cookieStr) {
        String[] cookieItems;
        HashMap<String, String> cookies = new HashMap<String, String>();
        if (CBString.isEmptyOrNull(cookieStr)) {
            return cookies;
        }
        for (String singleCookie : cookieItems = cookieStr.split(";")) {
            singleCookie = singleCookie.trim();
            boolean specialStrFlag = false;
            for (String property : COOKIE_PROPERTIES1) {
                if (!singleCookie.startsWith(property)) continue;
                specialStrFlag = true;
                break;
            }
            if (specialStrFlag || COOKIE_PROPERTIES2.contains(singleCookie)) continue;
            int pos = singleCookie.indexOf(61);
            if (pos == -1) {
                CBLog.warn("cookie format error, [{}]", singleCookie);
                continue;
            }
            String key = singleCookie.substring(0, pos);
            String val = singleCookie.substring(pos + 1);
            cookies.put(key, val);
        }
        return cookies;
    }

    static {
        COOKIE_PROPERTIES1.add("Expires=");
        COOKIE_PROPERTIES1.add("Max-Age=");
        COOKIE_PROPERTIES1.add("Domain=");
        COOKIE_PROPERTIES1.add("Path=");
        COOKIE_PROPERTIES2.add("Secure");
        COOKIE_PROPERTIES2.add("HttpOnly");
        COOKIE_PROPERTIES2.add("SameSite");
    }
}

