/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.task;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.codeboy.tools.task.base.CBTask;
import me.codeboy.tools.task.base.CBTaskListener;

public class CBTaskPool {
    private ScheduledExecutorService executorService;
    private static final CBTaskPool defaultTaskPool = new CBTaskPool();

    public static synchronized CBTaskPool instance() {
        if (CBTaskPool.defaultTaskPool.executorService == null) {
            CBTaskPool.defaultTaskPool.executorService = Executors.newSingleThreadScheduledExecutor();
        }
        return defaultTaskPool;
    }

    public static CBTaskPool newInstance() {
        CBTaskPool singleTaskPool = new CBTaskPool();
        singleTaskPool.executorService = Executors.newSingleThreadScheduledExecutor();
        return singleTaskPool;
    }

    public <T> void submit(CBTask<T> task) {
        this.submit(task, null);
    }

    public <T> void submit(CBTask<T> task, CBTaskListener<T> listener) {
        this.postDelayed(task, listener, 0L);
    }

    public <T> void postAtTime(CBTask<T> task, long execMillis) {
        this.postAtTime(task, null, execMillis);
    }

    public <T> void postAtTime(CBTask<T> task, CBTaskListener<T> listener, long execMillis) {
        this.postDelayed(task, listener, execMillis - System.currentTimeMillis());
    }

    public <T> void postDelayed(CBTask<T> task, long delayTime) {
        this.postDelayed(task, null, delayTime);
    }

    public <T> void postDelayed(CBTask<T> task, CBTaskListener<T> listener, long delayTime) {
        this.executorService.schedule(() -> this.processTask(task, listener), delayTime, TimeUnit.MILLISECONDS);
    }

    public <T> void scheduleAtFixedRate(CBTask<T> task, CBTaskListener<T> listener, long initialDelay, long fixedTime) {
        this.executorService.scheduleAtFixedRate(() -> this.processTask(task, listener), initialDelay, fixedTime, TimeUnit.MILLISECONDS);
    }

    private <T> void processTask(CBTask<T> task, CBTaskListener<T> listener) {
        if (listener != null) {
            listener.onStart(this, task);
            try {
                T result = task.execute();
                listener.onFinish(this, task, result);
            }
            catch (Exception e) {
                listener.onError(this, task, e);
            }
        } else {
            task.execute();
        }
    }

    public boolean isShutDown() {
        return this.executorService.isShutdown();
    }

    public boolean shutdown() {
        if (this == defaultTaskPool) {
            return false;
        }
        this.executorService.shutdown();
        return true;
    }
}

