/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CBMap<K, V> {
    private final int GROW_ASC = 1;
    private final int GROW_DESC = -1;

    public Map<K, V> sortByValueAsc(Map<K, V> sourceMap) {
        return this.sortByValue(sourceMap, 1);
    }

    public Map<K, V> sortByValueDesc(Map<K, V> sourceMap) {
        return this.sortByValue(sourceMap, -1);
    }

    public Map<K, V> sortByAsc(Map<K, V> sourceMap) {
        return this.sortByKey(sourceMap, 1);
    }

    public Map<K, V> sortByKeyDesc(Map<K, V> sourceMap) {
        return this.sortByKey(sourceMap, -1);
    }

    private Map<K, V> sortByKey(Map<K, V> sourceMap, int sortPolicy) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(sourceMap.entrySet());
        list.sort((o1, o2) -> {
            Object k1 = o1.getKey();
            Object k2 = o2.getKey();
            return this.compareValue(k1, k2) * sortPolicy;
        });
        return this.getKvMap(list);
    }

    private Map<K, V> sortByValue(Map<K, V> sourceMap, int sortPolicy) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(sourceMap.entrySet());
        Collections.sort(list, (o1, o2) -> {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            return this.compareValue(v1, v2) * sortPolicy;
        });
        return this.getKvMap(list);
    }

    private Map<K, V> getKvMap(List<Map.Entry<K, V>> list) {
        LinkedHashMap<K, V> desMap = new LinkedHashMap<K, V>();
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry<K, V> item = list.get(i);
            desMap.put(item.getKey(), item.getValue());
        }
        return desMap;
    }

    private int compareValue(Object v1, Object v2) {
        if (v1 instanceof Integer) {
            return Integer.compare((Integer)v1, (Integer)v2);
        }
        if (v1 instanceof Float) {
            return Float.compare(((Float)v1).floatValue(), ((Float)v2).floatValue());
        }
        if (v1 instanceof Double) {
            return Double.compare((Double)v1, (Double)v2);
        }
        if (v1 instanceof Long) {
            return Long.compare((Long)v1, (Long)v2);
        }
        if (v1 instanceof Character) {
            return Character.compare(((Character)v1).charValue(), ((Character)v2).charValue());
        }
        if (v1 instanceof Short) {
            return Short.compare((Short)v1, (Short)v2);
        }
        if (v1 instanceof Comparable) {
            return ((Comparable)v1).compareTo(v2);
        }
        return 0;
    }
}

