/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.util;

import java.util.Random;

public class CBRandom {
    private static final String SEED_NUM = "0123456789";
    private static final String SEED_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    private static final String SEED_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Random sRandom = new Random();

    public static int nextInt() {
        return sRandom.nextInt();
    }

    public static int nextInt(int bound) {
        return sRandom.nextInt(bound);
    }

    public static long nextLong() {
        return sRandom.nextLong();
    }

    public static double nextDouble() {
        return sRandom.nextDouble();
    }

    public static float nextFloat() {
        return sRandom.nextFloat();
    }

    public static boolean nextBoolean() {
        return sRandom.nextBoolean();
    }

    public static double nextGaussian() {
        return sRandom.nextGaussian();
    }

    public static void newtByteArray(byte[] bytes) {
        sRandom.nextBytes(bytes);
    }

    public static String nextString(int len) {
        return CBRandom.nextString(StringType.NUM_LOWERCASE_UPPERCASE, len);
    }

    public static String nextString(StringType stringType, int len) {
        String baseStr;
        switch (stringType) {
            case NUM: {
                baseStr = SEED_NUM;
                break;
            }
            case LOWERCASE: {
                baseStr = SEED_LOWERCASE;
                break;
            }
            case UPPERCASE: {
                baseStr = SEED_UPPERCASE;
                break;
            }
            case NUM_LOWERCASE: {
                baseStr = "0123456789abcdefghijklmnopqrstuvwxyz";
                break;
            }
            case NUM_UPPERCASE: {
                baseStr = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
            }
            case LOWERCASE_UPPERCASE: {
                baseStr = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
            }
            default: {
                baseStr = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            }
        }
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            builder.append(CBRandom.nextStringChar(baseStr));
        }
        return builder.toString();
    }

    private static char nextStringChar(String str) {
        return str.charAt(CBRandom.nextInt(str.length()));
    }

    public static enum StringType {
        NUM,
        LOWERCASE,
        UPPERCASE,
        NUM_LOWERCASE,
        NUM_UPPERCASE,
        LOWERCASE_UPPERCASE,
        NUM_LOWERCASE_UPPERCASE;

    }
}

