/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.tools.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CBTimer {
    private final Map<String, Long> times = new HashMap<String, Long>();
    private static final String TIME_KEY = "CB_TIMER_%d";
    private long count = -1L;

    public synchronized void push() {
        this.times.put(String.format(Locale.CHINA, TIME_KEY, ++this.count), System.currentTimeMillis());
    }

    public void push(String key) {
        this.push(key, System.currentTimeMillis());
    }

    public void push(String key, long time) {
        if (key.startsWith("CB_TIMER")) {
            return;
        }
        this.times.put(key, time);
    }

    public long pop() {
        if (this.count < 0L) {
            return -1L;
        }
        String key = String.format(Locale.CHINA, TIME_KEY, this.count);
        --this.count;
        return this.pop(key);
    }

    public long pop(String key) {
        return this.pop(key, System.currentTimeMillis());
    }

    public long pop(String key, long time) {
        if (!this.times.containsKey(key)) {
            return -1L;
        }
        long recordTime = this.times.get(key);
        this.times.remove(key);
        return time - recordTime;
    }

    public boolean contains(String key) {
        return this.times.containsKey(key);
    }
}

