/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.kato.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import me.danwi.kato.common.ExceptionResult;
import me.danwi.kato.common.exception.ExceptionExtraDataHolder;
import me.danwi.kato.common.exception.KatoException;
import me.danwi.kato.common.exception.KatoUndeclaredException;
import me.danwi.kato.server.PassByKato;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class KatoResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private final ObjectMapper mapper = new ObjectMapper();

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        Method method = returnType.getMethod();
        if (method == null) {
            return false;
        }
        return method.getAnnotation(PassByKato.class) == null && method.getDeclaringClass().getAnnotation(PassByKato.class) == null;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof KatoException) {
            ExceptionResult exceptionResult = new ExceptionResult();
            exceptionResult.setId(body.getClass().getName());
            exceptionResult.setMessage(((KatoException)body).getMessage());
            if (body instanceof ExceptionExtraDataHolder) {
                exceptionResult.setData(((ExceptionExtraDataHolder)body).toMap());
            }
            response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            return exceptionResult;
        }
        if (body instanceof String) {
            try {
                response.getHeaders().add("Content-Type", "application/json");
                return this.mapper.writeValueAsString(body);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("json\u5e8f\u5217\u5316\u5931\u8d25", e);
            }
        }
        return body;
    }

    @ExceptionHandler(value={KatoException.class})
    KatoException katoExceptionHandler(KatoException exception) {
        return exception;
    }

    @ExceptionHandler(value={Exception.class})
    KatoUndeclaredException katoUndeclaredExceptionHandler(Exception exception) {
        return new KatoUndeclaredException((Throwable)exception);
    }
}

