/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import me.danwi.sqlex.parser.Session;
import me.danwi.sqlex.parser.config.SqlExConfig;
import me.danwi.sqlex.parser.exception.SqlExRepositoryException;
import me.danwi.sqlex.parser.generate.GeneratedEntityFile;
import me.danwi.sqlex.parser.generate.GeneratedMethodFile;
import me.danwi.sqlex.parser.generate.GeneratedRepositoryFile;
import me.danwi.sqlex.parser.generate.GeneratedTableFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\tJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\"\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\tR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lme/danwi/sqlex/parser/Repository;", "", "databaseName", "", "session", "Lme/danwi/sqlex/parser/Session;", "config", "Lme/danwi/sqlex/parser/config/SqlExConfig;", "schemas", "", "(Ljava/lang/String;Lme/danwi/sqlex/parser/Session;Lme/danwi/sqlex/parser/config/SqlExConfig;Ljava/util/List;)V", "converters", "rootPackage", "getSession", "()Lme/danwi/sqlex/parser/Session;", "close", "", "generateEntityAndTableClassFiles", "Lkotlin/Pair;", "Lme/danwi/sqlex/parser/generate/GeneratedEntityFile;", "Lme/danwi/sqlex/parser/generate/GeneratedTableFile;", "generateMethodClassFile", "Lme/danwi/sqlex/parser/generate/GeneratedMethodFile;", "relativePath", "content", "generateRepositoryClassFile", "Lme/danwi/sqlex/parser/generate/GeneratedRepositoryFile;", "tableClassNames", "methodClassNames", "parser"})
public final class Repository {
    @NotNull
    private final String databaseName;
    @NotNull
    private final Session session;
    @NotNull
    private final SqlExConfig config;
    @NotNull
    private final List<String> schemas;
    @NotNull
    private final String rootPackage;
    @NotNull
    private final List<String> converters;

    public Repository(@NotNull String databaseName, @NotNull Session session, @NotNull SqlExConfig config, @NotNull List<String> schemas) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        this.databaseName = databaseName;
        this.session = session;
        this.config = config;
        this.schemas = schemas;
        String string = this.config.getRootPackage();
        if (string == null) {
            throw new SqlExRepositoryException("\u65e0\u6cd5\u83b7\u53d6\u6839\u5305\u4fe1\u606f");
        }
        this.rootPackage = string;
        this.converters = this.config.getConverters();
    }

    @NotNull
    public final Session getSession() {
        return this.session;
    }

    @NotNull
    public final GeneratedRepositoryFile generateRepositoryClassFile(@NotNull List<String> tableClassNames, @NotNull List<String> methodClassNames) {
        Intrinsics.checkNotNullParameter(tableClassNames, (String)"tableClassNames");
        Intrinsics.checkNotNullParameter(methodClassNames, (String)"methodClassNames");
        return new GeneratedRepositoryFile(this.rootPackage, this.converters, this.schemas, tableClassNames, methodClassNames, this.session);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<GeneratedEntityFile, GeneratedTableFile>> generateEntityAndTableClassFiles() {
        void $this$mapTo$iv$iv;
        String[] $this$map$iv = this.session.getAllTables();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var10_10 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GeneratedEntityFile entityFile = new GeneratedEntityFile(this.rootPackage, (String)it, this.getSession());
            GeneratedTableFile tableFile = new GeneratedTableFile(this.rootPackage, (String)it, entityFile.getQualifiedName(), this.getSession());
            collection.add(new Pair((Object)entityFile, (Object)tableFile));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final GeneratedMethodFile generateMethodClassFile(@NotNull String relativePath, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return new GeneratedMethodFile(this.rootPackage, relativePath, content, this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            this.session.execute(Intrinsics.stringPlus((String)"drop database ", (Object)this.databaseName));
        }
        finally {
            this.session.close();
        }
    }
}

