/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.danwi.sqlex.parser.Repository;
import me.danwi.sqlex.parser.RepositoryKt;
import me.danwi.sqlex.parser.Session;
import me.danwi.sqlex.parser.config.SqlExConfig;
import me.danwi.sqlex.parser.exception.SqlExRepositoryException;
import me.danwi.sqlex.parser.exception.SqlExRepositorySchemaException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/danwi/sqlex/parser/RepositoryBuilder;", "", "config", "Lme/danwi/sqlex/parser/config/SqlExConfig;", "(Lme/danwi/sqlex/parser/config/SqlExConfig;)V", "currentSchemaVersion", "", "databaseName", "", "rootPackageRelativePath", "schemaContentCache", "", "session", "Lme/danwi/sqlex/parser/Session;", "addSchema", "", "relativePath", "script", "build", "Lme/danwi/sqlex/parser/Repository;", "close", "parser"})
public final class RepositoryBuilder {
    @NotNull
    private final SqlExConfig config;
    @NotNull
    private final String databaseName;
    @NotNull
    private final Session session;
    @NotNull
    private final String rootPackageRelativePath;
    private int currentSchemaVersion;
    @NotNull
    private final List<String> schemaContentCache;

    public RepositoryBuilder(@NotNull SqlExConfig config) {
        String string;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.databaseName = Intrinsics.stringPlus((String)"sqlex_", (Object)RepositoryKt.access$getIndex$p().getAndIncrement());
        this.session = new Session(this.databaseName);
        String string2 = this.config.getRootPackage();
        if (string2 == null) {
            string = null;
        } else {
            String $this$packageNameToRelativePath$iv = string2;
            boolean $i$f$getPackageNameToRelativePath = false;
            String $this$windowsPathNormalize$iv$iv = $this$packageNameToRelativePath$iv;
            boolean $i$f$getWindowsPathNormalize = false;
            String string3 = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(\"os.name\")");
            string = StringsKt.replace$default((String)(StringsKt.startsWith$default((String)string3, (String)"Windows", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)$this$windowsPathNormalize$iv$iv, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null) : $this$windowsPathNormalize$iv$iv), (char)'.', (char)'/', (boolean)false, (int)4, null);
        }
        if (string == null) {
            throw new SqlExRepositoryException("\u65e0\u6cd5\u83b7\u53d6\u6839\u5305\u4fe1\u606f");
        }
        this.rootPackageRelativePath = string;
        this.currentSchemaVersion = -1;
        this.schemaContentCache = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSchema(@NotNull String relativePath, @NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        try {
            Integer version;
            Integer n;
            if (!StringsKt.startsWith$default((String)relativePath, (String)this.rootPackageRelativePath, (boolean)false, (int)2, null)) {
                String normalizedPath$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Schema\u6587\u4ef6\u5fc5\u987b\u5728\u6839\u5305\u4e0b,\u5f53\u524d\u6839\u5305: ");
                String $this$relativePathToPackageName$iv = this.rootPackageRelativePath;
                boolean $i$f$getRelativePathToPackageName = false;
                String $this$windowsPathNormalize$iv$iv = $this$relativePathToPackageName$iv;
                boolean $i$f$getWindowsPathNormalize = false;
                String string = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
                String string2 = normalizedPath$iv = StringsKt.startsWith$default((String)string, (String)"Windows", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)$this$windowsPathNormalize$iv$iv, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null) : $this$windowsPathNormalize$iv$iv;
                StringBuilder stringBuilder2 = stringBuilder.append(StringsKt.contains$default((CharSequence)StringsKt.substringAfterLast$default((String)normalizedPath$iv, (String)"/", null, (int)2, null), (CharSequence)".", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.substringBeforeLast$default((String)normalizedPath$iv, (char)'/', null, (int)2, null), (CharSequence)"/"), (CharSequence)"/"), (char)'/', (char)'.', (boolean)false, (int)4, null) : StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)normalizedPath$iv, (CharSequence)"/"), (CharSequence)"/"), (char)'/', (char)'.', (boolean)false, (int)4, null)).append(" ,Schema\u6587\u4ef6\u6240\u5728\u5305: ");
                $this$relativePathToPackageName$iv = relativePath;
                $i$f$getRelativePathToPackageName = false;
                $this$windowsPathNormalize$iv$iv = $this$relativePathToPackageName$iv;
                $i$f$getWindowsPathNormalize = false;
                string = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
                String string3 = normalizedPath$iv = StringsKt.startsWith$default((String)string, (String)"Windows", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)$this$windowsPathNormalize$iv$iv, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null) : $this$windowsPathNormalize$iv$iv;
                throw new SqlExRepositorySchemaException(relativePath, stringBuilder2.append(StringsKt.contains$default((CharSequence)StringsKt.substringAfterLast$default((String)normalizedPath$iv, (String)"/", null, (int)2, null), (CharSequence)".", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.substringBeforeLast$default((String)normalizedPath$iv, (char)'/', null, (int)2, null), (CharSequence)"/"), (CharSequence)"/"), (char)'/', (char)'.', (boolean)false, (int)4, null) : StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)normalizedPath$iv, (CharSequence)"/"), (CharSequence)"/"), (char)'/', (char)'.', (boolean)false, (int)4, null)).toString());
            }
            String $this$schemaFileVersion$iv = relativePath;
            boolean $i$f$getSchemaFileVersion = false;
            Regex regex = new Regex("^(\\d+)");
            String $this$windowsPathNormalize$iv$iv = $this$schemaFileVersion$iv;
            boolean $i$f$getWindowsPathNormalize = false;
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)StringsKt.substringAfterLast$default((String)(StringsKt.startsWith$default((String)string, (String)"Windows", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)$this$windowsPathNormalize$iv$iv, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null) : $this$windowsPathNormalize$iv$iv), (String)"/", null, (int)2, null), (int)0, (int)2, null);
            if (matchResult == null) {
                n = null;
            } else {
                MatchGroupCollection matchGroupCollection = matchResult.getGroups();
                if (matchGroupCollection == null) {
                    n = null;
                } else {
                    MatchGroup matchGroup = matchGroupCollection.get(0);
                    n = matchGroup == null ? null : ((string = matchGroup.getValue()) == null ? null : Integer.valueOf(Integer.parseInt(string)));
                }
            }
            Integer n2 = version = n;
            int n3 = this.currentSchemaVersion + 1;
            if (n2 == null || n2 != n3) {
                if (this.currentSchemaVersion == -1) {
                    throw new SqlExRepositorySchemaException(relativePath, "Schema\u6587\u4ef6\u7684\u7248\u672c\u5fc5\u987b\u4ece0\u5f00\u59cb");
                }
                throw new SqlExRepositorySchemaException(relativePath, "Schema\u6587\u4ef6\u7248\u672c\u5fc5\u987b\u8fde\u7eed\u4e14\u4e0d\u91cd\u590d,\u5f53\u524d\u9700\u8981 " + (this.currentSchemaVersion + 1) + " \u7248\u672c,\u5b9e\u9645\u63d0\u4f9b " + version + " \u7248\u672c");
            }
            this.session.executeScript(script);
            this.schemaContentCache.add(script);
            n3 = this.currentSchemaVersion;
            this.currentSchemaVersion = n3 + 1;
        }
        catch (Exception e) {
            try {
                this.session.execute(Intrinsics.stringPlus((String)"drop database ", (Object)this.databaseName));
            }
            finally {
                this.session.close();
                throw new SqlExRepositorySchemaException(relativePath, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Repository build() {
        try {
            Repository repository = new Repository(this.databaseName, new Session(this.databaseName), this.config, this.schemaContentCache);
            return repository;
        }
        catch (Exception e) {
            try {
                this.session.execute(Intrinsics.stringPlus((String)"drop database ", (Object)this.databaseName));
            }
            finally {
                throw e;
            }
        }
        finally {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            this.session.execute(Intrinsics.stringPlus((String)"drop database ", (Object)this.databaseName));
        }
        catch (Exception exception) {
        }
        finally {
            this.session.close();
        }
    }
}

