/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.parser.generate;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.danwi.sqlex.core.annotation.entity.SqlExColumnName;
import me.danwi.sqlex.parser.Field;
import me.danwi.sqlex.parser.generate.ExtensionsKt;
import me.danwi.sqlex.parser.util.StringExtensionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001c\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\r\u001a;\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0015\"\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0016\u0010\u0005\u001a\u00020\u0006*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"JavaType", "Lcom/squareup/javapoet/TypeName;", "Lme/danwi/sqlex/parser/Field;", "getJavaType", "(Lme/danwi/sqlex/parser/Field;)Lcom/squareup/javapoet/TypeName;", "JdbcType", "Ljava/sql/JDBCType;", "getJdbcType", "(Lme/danwi/sqlex/parser/Field;)Ljava/sql/JDBCType;", "addColumnGetterAndSetter", "Lcom/squareup/javapoet/TypeSpec$Builder;", "field", "nullableAnnotation", "", "toEntityClass", "Lcom/squareup/javapoet/TypeSpec;", "", "className", "", "isStatic", "constructor", "([Lme/danwi/sqlex/parser/Field;Ljava/lang/String;ZZZ)Lcom/squareup/javapoet/TypeSpec;", "parser"})
public final class ExtensionsKt {
    @NotNull
    public static final TypeName getJavaType(@NotNull Field $this$JavaType) {
        Intrinsics.checkNotNullParameter((Object)$this$JavaType, (String)"<this>");
        boolean $i$f$getJavaType = false;
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"bit")) {
            TypeName typeName;
            if ($this$JavaType.getLength() == 1L) {
                TypeName typeName2 = ClassName.BOOLEAN.box();
                Intrinsics.checkNotNullExpressionValue((Object)typeName2, (String)"BOOLEAN.box()");
                typeName = typeName2;
            } else {
                ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(ClassName.BYTE)");
                typeName = (TypeName)arrayTypeName;
            }
            return typeName;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"tinyint")) {
            char thirdChar;
            if ($this$JavaType.getLength() == 1L && $this$JavaType.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar = $this$JavaType.getName().charAt(2)) == '_' || thirdChar == '-' || Character.isUpperCase(thirdChar))) {
                TypeName typeName = ClassName.BOOLEAN.box();
                Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"BOOLEAN.box()");
                return typeName;
            }
            TypeName typeName = ClassName.INT.box();
            Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"INT.box()");
            return typeName;
        }
        String[] stringArray = new String[]{"smallint", "mediumint"};
        if (CollectionsKt.listOf((Object[])stringArray).contains($this$JavaType.getDbType())) {
            stringArray = ClassName.INT.box();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"INT.box()");
            return stringArray;
        }
        stringArray = new String[]{"int", "integer"};
        if (CollectionsKt.listOf((Object[])stringArray).contains($this$JavaType.getDbType())) {
            String[] stringArray2;
            if ($this$JavaType.getUnsigned()) {
                stringArray = ClassName.LONG.box();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"LONG.box()");
                stringArray2 = stringArray;
            } else {
                stringArray = ClassName.INT.box();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"INT.box()");
                stringArray2 = stringArray;
            }
            return stringArray2;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"bigint")) {
            String[] stringArray3;
            if ($this$JavaType.getUnsigned()) {
                stringArray = ClassName.get(BigInteger.class);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(BigInteger::class.java)");
                stringArray3 = stringArray;
            } else {
                stringArray = ClassName.LONG.box();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"LONG.box()");
                stringArray3 = stringArray;
            }
            return stringArray3;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"float")) {
            stringArray = ClassName.FLOAT.box();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"FLOAT.box()");
            return stringArray;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"double")) {
            stringArray = ClassName.DOUBLE.box();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"DOUBLE.box()");
            return stringArray;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"decimal")) {
            stringArray = ClassName.get(BigDecimal.class);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(BigDecimal::class.java)");
            return stringArray;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"date")) {
            stringArray = ClassName.get(LocalDate.class);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(LocalDate::class.java)");
            return stringArray;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"datetime")) {
            stringArray = ClassName.get(LocalDateTime.class);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(LocalDateTime::class.java)");
            return stringArray;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"timestamp")) {
            stringArray = ClassName.get(OffsetDateTime.class);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(OffsetDateTime::class.java)");
            return stringArray;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"time")) {
            stringArray = ClassName.get(LocalTime.class);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(LocalTime::class.java)");
            return stringArray;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"year")) {
            stringArray = ClassName.get(LocalDate.class);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(LocalDate::class.java)");
            return (TypeName)stringArray;
        }
        stringArray = new String[]{"char", "varchar"};
        if (CollectionsKt.listOf((Object[])stringArray).contains($this$JavaType.getDbType())) {
            TypeName typeName;
            if ($this$JavaType.getBinary()) {
                stringArray = ArrayTypeName.of((TypeName)ClassName.BYTE);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"of(ClassName.BYTE)");
                typeName = (TypeName)stringArray;
            } else {
                stringArray = ClassName.get(String.class);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(java.lang.String::class.java)");
                typeName = (TypeName)stringArray;
            }
            return typeName;
        }
        stringArray = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
        if (CollectionsKt.listOf((Object[])stringArray).contains($this$JavaType.getDbType())) {
            stringArray = ArrayTypeName.of((TypeName)ClassName.BYTE);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"of(ClassName.BYTE)");
            return (TypeName)stringArray;
        }
        stringArray = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
        if (CollectionsKt.listOf((Object[])stringArray).contains($this$JavaType.getDbType())) {
            stringArray = ClassName.get(String.class);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(java.lang.String::class.java)");
            return (TypeName)stringArray;
        }
        if (Intrinsics.areEqual((Object)$this$JavaType.getDbType(), (Object)"var_string")) {
            stringArray = ClassName.get(String.class);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(java.lang.String::class.java)");
            return (TypeName)stringArray;
        }
        throw new Exception("db[" + $this$JavaType.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
    }

    @NotNull
    public static final JDBCType getJdbcType(@NotNull Field $this$JdbcType) {
        JDBCType jDBCType;
        Intrinsics.checkNotNullParameter((Object)$this$JdbcType, (String)"<this>");
        boolean $i$f$getJdbcType = false;
        switch ($this$JdbcType.getDbType()) {
            case "bit": {
                jDBCType = JDBCType.BIT;
                break;
            }
            case "tinyint": {
                jDBCType = JDBCType.TINYINT;
                break;
            }
            case "smallint": {
                jDBCType = JDBCType.SMALLINT;
                break;
            }
            case "mediumint": {
                jDBCType = JDBCType.INTEGER;
                break;
            }
            case "int": {
                jDBCType = JDBCType.INTEGER;
                break;
            }
            case "bigint": {
                jDBCType = JDBCType.BIGINT;
                break;
            }
            case "float": {
                jDBCType = JDBCType.REAL;
                break;
            }
            case "double": {
                jDBCType = JDBCType.DOUBLE;
                break;
            }
            case "decimal": {
                jDBCType = JDBCType.DECIMAL;
                break;
            }
            case "date": {
                jDBCType = JDBCType.DATE;
                break;
            }
            case "datetime": {
                jDBCType = JDBCType.TIMESTAMP;
                break;
            }
            case "timestamp": {
                jDBCType = JDBCType.TIMESTAMP;
                break;
            }
            case "time": {
                jDBCType = JDBCType.TIME;
                break;
            }
            case "year": {
                jDBCType = JDBCType.DATE;
                break;
            }
            case "char": {
                if ($this$JdbcType.getBinary()) {
                    jDBCType = JDBCType.BINARY;
                    break;
                }
                jDBCType = JDBCType.CHAR;
                break;
            }
            case "varchar": {
                if ($this$JdbcType.getBinary()) {
                    jDBCType = JDBCType.VARBINARY;
                    break;
                }
                jDBCType = JDBCType.VARCHAR;
                break;
            }
            case "binary": {
                jDBCType = JDBCType.BINARY;
                break;
            }
            case "varbinary": {
                jDBCType = JDBCType.VARBINARY;
                break;
            }
            case "tinyblob": {
                jDBCType = JDBCType.VARBINARY;
                break;
            }
            case "tinytext": {
                jDBCType = JDBCType.VARCHAR;
                break;
            }
            case "blob": {
                jDBCType = JDBCType.LONGVARBINARY;
                break;
            }
            case "text": {
                jDBCType = JDBCType.LONGVARCHAR;
                break;
            }
            case "mediumblob": {
                jDBCType = JDBCType.LONGVARBINARY;
                break;
            }
            case "mediumtext": {
                jDBCType = JDBCType.LONGVARCHAR;
                break;
            }
            case "longblob": {
                jDBCType = JDBCType.LONGVARBINARY;
                break;
            }
            case "longtext": {
                jDBCType = JDBCType.LONGVARCHAR;
                break;
            }
            case "json": {
                jDBCType = JDBCType.LONGVARCHAR;
                break;
            }
            case "geometry": {
                jDBCType = JDBCType.BINARY;
                break;
            }
            case "enum": {
                jDBCType = JDBCType.CHAR;
                break;
            }
            case "set": {
                jDBCType = JDBCType.CHAR;
                break;
            }
            case "null": {
                jDBCType = JDBCType.NULL;
                break;
            }
            default: {
                throw new Exception("db[" + $this$JdbcType.getDbType() + "] -> jdbc \u6620\u5c04\u5931\u8d25!!!");
            }
        }
        return jDBCType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TypeSpec toEntityClass(@NotNull Field[] $this$toEntityClass, @NotNull String className, boolean isStatic, boolean constructor, boolean nullableAnnotation) {
        Collection<String> collection;
        Object object;
        Modifier[] $this$mapTo$iv$iv;
        Modifier[] $this$map$iv;
        MethodSpec.Builder fromMethodBuilder;
        Modifier[] allFieldConstructorBuilder;
        Modifier[] $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        List list;
        List answer$iv$iv$iv22;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toEntityClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((String)className).addModifiers(modifierArray);
        if (isStatic) {
            modifierArray = new Modifier[]{Modifier.STATIC};
            typeSpecBuilder.addModifiers(modifierArray);
        }
        Object $this$groupBy$iv = $this$toEntityClass;
        boolean $i$f$groupBy = false;
        Modifier[] modifierArray2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv;
        int n = 0;
        int n2 = ((void)iterator).length;
        while (n < n2) {
            Object object2;
            void element$iv$iv = iterator[n];
            ++n;
            void it2 = element$iv$iv;
            boolean bl = false;
            String key$iv$iv = StringExtensionKt.getPascalName(it2.getName());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv22 = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv22);
                object2 = answer$iv$iv$iv22;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            void var17_56 = element$iv$iv;
            list = list$iv$iv;
            boolean bl3 = false;
            list.add(var17_56.getName());
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo232 = false;
        iterator = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((List)entry.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Collection duplicateFieldNames = destination$iv$iv.values();
        if (!duplicateFieldNames.isEmpty()) {
            throw new Exception(Intrinsics.stringPlus((String)"\u91cd\u590d\u7684\u5217\u540d ", (Object)CollectionsKt.joinToString$default((Iterable)duplicateFieldNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)));
        }
        Regex regex = new Regex("^[a-zA-Z_][a-zA-Z0-9_]*$");
        Modifier[] $this$filter$iv2 = $this$toEntityClass;
        boolean $i$f$filter2 = false;
        Modifier[] $i$f$filterTo232 = $this$filter$iv2;
        Collection destination$iv$iv222 = new ArrayList();
        int $i$f$filterTo32 = 0;
        for (void var17_59 : $this$filterTo$iv$iv) {
            void it = var17_59;
            boolean bl = false;
            if (!(!regex.matches((CharSequence)StringExtensionKt.getPascalName(it.getName())))) continue;
            destination$iv$iv222.add(var17_59);
        }
        List invalidFieldNames = (List)destination$iv$iv222;
        if (!((Collection)invalidFieldNames).isEmpty()) {
            throw new Exception(Intrinsics.stringPlus((String)"\u975e\u6cd5\u7684\u5217\u540d ", (Object)CollectionsKt.joinToString$default((Iterable)invalidFieldNames, (CharSequence)", ", null, null, (int)0, null, (Function1)toEntityClass.1.INSTANCE, (int)30, null)));
        }
        Modifier[] $this$forEach$iv = $this$toEntityClass;
        boolean $i$f$forEach22 = false;
        for (Modifier modifier : $this$forEach$iv) {
            Modifier it = modifier;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)typeSpecBuilder, (String)"typeSpecBuilder");
            ExtensionsKt.addColumnGetterAndSetter(typeSpecBuilder, (Field)((Object)it), nullableAnnotation);
        }
        if (constructor) {
            void var17_62;
            void $this$filterTo$iv$iv3;
            $this$forEach$iv = new Modifier[]{Modifier.PUBLIC};
            typeSpecBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers($this$forEach$iv).build());
            Modifier[] $i$f$forEach22 = new Modifier[]{Modifier.PUBLIC};
            allFieldConstructorBuilder = MethodSpec.constructorBuilder().addModifiers($i$f$forEach22);
            Modifier[] $this$forEach$iv2 = $this$toEntityClass;
            boolean $i$f$forEach3 = false;
            Modifier[] destination$iv$iv222 = $this$forEach$iv2;
            $i$f$filterTo32 = 0;
            int n3 = destination$iv$iv222.length;
            while ($i$f$filterTo32 < n3) {
                Object object3;
                Modifier element$iv2 = destination$iv$iv222[$i$f$filterTo32];
                ++$i$f$filterTo32;
                Modifier it = element$iv2;
                boolean bl = false;
                String fieldName = StringExtensionKt.getPascalName(((Field)((Object)it)).getName());
                Modifier $this$JavaType$iv = it;
                boolean $i$f$getJavaType = false;
                if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"bit")) {
                    if (((Field)((Object)$this$JavaType$iv)).getLength() == 1L) {
                        String[] value$iv$iv$iv = ClassName.BOOLEAN.box();
                        Intrinsics.checkNotNullExpressionValue((Object)value$iv$iv$iv, (String)"BOOLEAN.box()");
                        object3 = value$iv$iv$iv;
                    } else {
                        ArrayTypeName value$iv$iv$iv = ArrayTypeName.of((TypeName)ClassName.BYTE);
                        Intrinsics.checkNotNullExpressionValue((Object)value$iv$iv$iv, (String)"of(ClassName.BYTE)");
                        object3 = (TypeName)value$iv$iv$iv;
                    }
                } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"tinyint")) {
                    char thirdChar$iv22;
                    if (((Field)((Object)$this$JavaType$iv)).getLength() == 1L && ((Field)((Object)$this$JavaType$iv)).getName().length() > 2 && StringsKt.startsWith$default((String)((Field)((Object)$this$JavaType$iv)).getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv22 = ((Field)((Object)$this$JavaType$iv)).getName().charAt(2)) == '_' || thirdChar$iv22 == '-' || Character.isUpperCase(thirdChar$iv22))) {
                        answer$iv$iv$iv22 = ClassName.BOOLEAN.box();
                        Intrinsics.checkNotNullExpressionValue((Object)answer$iv$iv$iv22, (String)"BOOLEAN.box()");
                        object3 = answer$iv$iv$iv22;
                    } else {
                        TypeName thirdChar$iv22 = ClassName.INT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"INT.box()");
                        object3 = thirdChar$iv22;
                    }
                } else {
                    String[] thirdChar$iv22 = new String[]{"smallint", "mediumint"};
                    if (CollectionsKt.listOf((Object[])thirdChar$iv22).contains(((Field)((Object)$this$JavaType$iv)).getDbType())) {
                        thirdChar$iv22 = ClassName.INT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"INT.box()");
                        object3 = thirdChar$iv22;
                    } else {
                        thirdChar$iv22 = new String[]{"int", "integer"};
                        if (CollectionsKt.listOf((Object[])thirdChar$iv22).contains(((Field)((Object)$this$JavaType$iv)).getDbType())) {
                            if (((Field)((Object)$this$JavaType$iv)).getUnsigned()) {
                                thirdChar$iv22 = ClassName.LONG.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"LONG.box()");
                                object3 = thirdChar$iv22;
                            } else {
                                thirdChar$iv22 = ClassName.INT.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"INT.box()");
                                object3 = thirdChar$iv22;
                            }
                        } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"bigint")) {
                            if (((Field)((Object)$this$JavaType$iv)).getUnsigned()) {
                                thirdChar$iv22 = ClassName.get(BigInteger.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"get(BigInteger::class.java)");
                                object3 = thirdChar$iv22;
                            } else {
                                thirdChar$iv22 = ClassName.LONG.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"LONG.box()");
                                object3 = thirdChar$iv22;
                            }
                        } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"float")) {
                            thirdChar$iv22 = ClassName.FLOAT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"FLOAT.box()");
                            object3 = thirdChar$iv22;
                        } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"double")) {
                            thirdChar$iv22 = ClassName.DOUBLE.box();
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"DOUBLE.box()");
                            object3 = thirdChar$iv22;
                        } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"decimal")) {
                            thirdChar$iv22 = ClassName.get(BigDecimal.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"get(BigDecimal::class.java)");
                            object3 = thirdChar$iv22;
                        } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"date")) {
                            thirdChar$iv22 = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"get(LocalDate::class.java)");
                            object3 = thirdChar$iv22;
                        } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"datetime")) {
                            thirdChar$iv22 = ClassName.get(LocalDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"get(LocalDateTime::class.java)");
                            object3 = thirdChar$iv22;
                        } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"timestamp")) {
                            thirdChar$iv22 = ClassName.get(OffsetDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"get(OffsetDateTime::class.java)");
                            object3 = thirdChar$iv22;
                        } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"time")) {
                            thirdChar$iv22 = ClassName.get(LocalTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"get(LocalTime::class.java)");
                            object3 = thirdChar$iv22;
                        } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"year")) {
                            thirdChar$iv22 = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"get(LocalDate::class.java)");
                            object3 = (TypeName)thirdChar$iv22;
                        } else {
                            thirdChar$iv22 = new String[]{"char", "varchar"};
                            if (CollectionsKt.listOf((Object[])thirdChar$iv22).contains(((Field)((Object)$this$JavaType$iv)).getDbType())) {
                                if (((Field)((Object)$this$JavaType$iv)).getBinary()) {
                                    thirdChar$iv22 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"of(ClassName.BYTE)");
                                    object3 = (TypeName)thirdChar$iv22;
                                } else {
                                    thirdChar$iv22 = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"get(java.lang.String::class.java)");
                                    object3 = (TypeName)thirdChar$iv22;
                                }
                            } else {
                                thirdChar$iv22 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                                if (CollectionsKt.listOf((Object[])thirdChar$iv22).contains(((Field)((Object)$this$JavaType$iv)).getDbType())) {
                                    thirdChar$iv22 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"of(ClassName.BYTE)");
                                    object3 = (TypeName)thirdChar$iv22;
                                } else {
                                    thirdChar$iv22 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                    if (CollectionsKt.listOf((Object[])thirdChar$iv22).contains(((Field)((Object)$this$JavaType$iv)).getDbType())) {
                                        thirdChar$iv22 = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"get(java.lang.String::class.java)");
                                        object3 = (TypeName)thirdChar$iv22;
                                    } else if (Intrinsics.areEqual((Object)((Field)((Object)$this$JavaType$iv)).getDbType(), (Object)"var_string")) {
                                        thirdChar$iv22 = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv22, (String)"get(java.lang.String::class.java)");
                                        object3 = (TypeName)thirdChar$iv22;
                                    } else {
                                        throw new Exception("db[" + ((Field)((Object)$this$JavaType$iv)).getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                    }
                                }
                            }
                        }
                    }
                }
                ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)object3, (String)fieldName, (Modifier[])new Modifier[0]);
                if (nullableAnnotation) {
                    if (((Field)((Object)it)).getNotNull()) {
                        parameterSpec.addAnnotation(NotNull.class);
                    } else {
                        parameterSpec.addAnnotation(Nullable.class);
                    }
                }
                allFieldConstructorBuilder.addParameter(parameterSpec.build());
                allFieldConstructorBuilder.addCode("this." + fieldName + " = " + fieldName + ";\n", new Object[0]);
            }
            typeSpecBuilder.addMethod(allFieldConstructorBuilder.build());
            Modifier[] $this$filter$iv3 = $this$toEntityClass;
            boolean $i$f$filter322 = false;
            Modifier[] $i$f$filterTo32 = $this$filter$iv3;
            Collection collection2 = new ArrayList();
            boolean $i$f$filterTo4 = false;
            Field it = $this$filterTo$iv$iv3;
            boolean bl = false;
            int fieldName = ((void)it).length;
            while (var17_62 < fieldName) {
                void element$iv$iv = it[var17_62];
                ++var17_62;
                void it2 = element$iv$iv;
                boolean bl2 = false;
                if (!(it2.getNotNull() && !it2.isAutoIncrement() && !it2.getHasDefaultValue())) continue;
                collection2.add(element$iv$iv);
            }
            List necessaryColumns = (List)collection2;
            if (!((Collection)necessaryColumns).isEmpty()) {
                Modifier[] $i$f$filter322 = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
                fromMethodBuilder = MethodSpec.methodBuilder((String)"from").addJavadoc("\u901a\u8fc7\u6570\u636e\u5e93\u8868\u5fc5\u8981\u7684\u5b57\u6bb5\u6784\u5efa\u5b9e\u4f53\n<br/>\n\u5fc5\u8981\u7684\u5b57\u6bb5\u6307\u7684\u662f, \u975e\u7a7a\u4e14\u4e0d\u80fd\u81ea\u52a8\u751f\u6210(\u4e0d\u81ea\u589e\u4e14\u6ca1\u6709\u9ed8\u8ba4\u503c)\n<br/>\n\u6ce8\u610f: \u8be5\u65b9\u6cd5\u6784\u9020\u7684\u5b9e\u4f53\u4ec5\u7528\u4f5c\u6570\u636e\u5e93\u63d2\u5165, \u5176\u5185\u90e8\u5c5e\u6027\u4e0d\u662f\u7a7a\u5b89\u5168\u7684(kotlin)  \n\n@deprecated \u8be5\u65b9\u6cd5\u5df2\u7ecf\u5f03\u7528, \u8bf7\u4f7f\u7528 {@link #forInsert} \u65b9\u6cd5", new Object[0]).addAnnotation(Deprecated.class).addModifiers($i$f$filter322).returns((TypeName)ClassName.bestGuess((String)className)).addCode(className + " object = new " + className + "();\n", new Object[0]);
                Iterable $this$forEach$iv3 = necessaryColumns;
                boolean $i$f$forEach2232 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Object object4;
                    it = (Field)element$iv3;
                    boolean bl4 = false;
                    String fieldName2 = StringExtensionKt.getPascalName(it.getName());
                    Field $this$JavaType$iv = it;
                    boolean $i$f$getJavaType = false;
                    if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                        if ($this$JavaType$iv.getLength() == 1L) {
                            String[] bl2 = ClassName.BOOLEAN.box();
                            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"BOOLEAN.box()");
                            object4 = bl2;
                        } else {
                            ArrayTypeName bl2 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"of(ClassName.BYTE)");
                            object4 = (TypeName)bl2;
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                        char thirdChar$iv32;
                        if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv32 = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv32 == '-' || Character.isUpperCase(thirdChar$iv32))) {
                            answer$iv$iv$iv22 = ClassName.BOOLEAN.box();
                            Intrinsics.checkNotNullExpressionValue((Object)answer$iv$iv$iv22, (String)"BOOLEAN.box()");
                            object4 = answer$iv$iv$iv22;
                        } else {
                            TypeName thirdChar$iv32 = ClassName.INT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"INT.box()");
                            object4 = thirdChar$iv32;
                        }
                    } else {
                        String[] thirdChar$iv32 = new String[]{"smallint", "mediumint"};
                        if (CollectionsKt.listOf((Object[])thirdChar$iv32).contains($this$JavaType$iv.getDbType())) {
                            thirdChar$iv32 = ClassName.INT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"INT.box()");
                            object4 = thirdChar$iv32;
                        } else {
                            thirdChar$iv32 = new String[]{"int", "integer"};
                            if (CollectionsKt.listOf((Object[])thirdChar$iv32).contains($this$JavaType$iv.getDbType())) {
                                if ($this$JavaType$iv.getUnsigned()) {
                                    thirdChar$iv32 = ClassName.LONG.box();
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"LONG.box()");
                                    object4 = thirdChar$iv32;
                                } else {
                                    thirdChar$iv32 = ClassName.INT.box();
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"INT.box()");
                                    object4 = thirdChar$iv32;
                                }
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                                if ($this$JavaType$iv.getUnsigned()) {
                                    thirdChar$iv32 = ClassName.get(BigInteger.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"get(BigInteger::class.java)");
                                    object4 = thirdChar$iv32;
                                } else {
                                    thirdChar$iv32 = ClassName.LONG.box();
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"LONG.box()");
                                    object4 = thirdChar$iv32;
                                }
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                                thirdChar$iv32 = ClassName.FLOAT.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"FLOAT.box()");
                                object4 = thirdChar$iv32;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                                thirdChar$iv32 = ClassName.DOUBLE.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"DOUBLE.box()");
                                object4 = thirdChar$iv32;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                                thirdChar$iv32 = ClassName.get(BigDecimal.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"get(BigDecimal::class.java)");
                                object4 = thirdChar$iv32;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                                thirdChar$iv32 = ClassName.get(LocalDate.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"get(LocalDate::class.java)");
                                object4 = thirdChar$iv32;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                                thirdChar$iv32 = ClassName.get(LocalDateTime.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"get(LocalDateTime::class.java)");
                                object4 = thirdChar$iv32;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                                thirdChar$iv32 = ClassName.get(OffsetDateTime.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"get(OffsetDateTime::class.java)");
                                object4 = thirdChar$iv32;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                                thirdChar$iv32 = ClassName.get(LocalTime.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"get(LocalTime::class.java)");
                                object4 = thirdChar$iv32;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                                thirdChar$iv32 = ClassName.get(LocalDate.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"get(LocalDate::class.java)");
                                object4 = (TypeName)thirdChar$iv32;
                            } else {
                                thirdChar$iv32 = new String[]{"char", "varchar"};
                                if (CollectionsKt.listOf((Object[])thirdChar$iv32).contains($this$JavaType$iv.getDbType())) {
                                    if ($this$JavaType$iv.getBinary()) {
                                        thirdChar$iv32 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"of(ClassName.BYTE)");
                                        object4 = (TypeName)thirdChar$iv32;
                                    } else {
                                        thirdChar$iv32 = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"get(java.lang.String::class.java)");
                                        object4 = (TypeName)thirdChar$iv32;
                                    }
                                } else {
                                    thirdChar$iv32 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                                    if (CollectionsKt.listOf((Object[])thirdChar$iv32).contains($this$JavaType$iv.getDbType())) {
                                        thirdChar$iv32 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"of(ClassName.BYTE)");
                                        object4 = (TypeName)thirdChar$iv32;
                                    } else {
                                        thirdChar$iv32 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                        if (CollectionsKt.listOf((Object[])thirdChar$iv32).contains($this$JavaType$iv.getDbType())) {
                                            thirdChar$iv32 = ClassName.get(String.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"get(java.lang.String::class.java)");
                                            object4 = (TypeName)thirdChar$iv32;
                                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                            thirdChar$iv32 = ClassName.get(String.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv32, (String)"get(java.lang.String::class.java)");
                                            object4 = (TypeName)thirdChar$iv32;
                                        } else {
                                            throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)object4, (String)fieldName2, (Modifier[])new Modifier[0]);
                    if (nullableAnnotation) {
                        parameterSpec.addAnnotation(NotNull.class);
                    }
                    fromMethodBuilder.addParameter(parameterSpec.build());
                    fromMethodBuilder.addCode("object." + fieldName2 + " = " + fieldName2 + ";\n", new Object[0]);
                }
                fromMethodBuilder.addCode("return object;", new Object[0]);
                typeSpecBuilder.addMethod(fromMethodBuilder.build());
                Modifier[] $i$f$forEach2232 = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
                MethodSpec.Builder forInsertMethod = MethodSpec.methodBuilder((String)"forInsert").addJavadoc("\u901a\u8fc7\u6570\u636e\u5e93\u8868\u5fc5\u8981\u7684\u5b57\u6bb5\u6784\u5efa\u5b9e\u4f53\n<br/>\n\u5fc5\u8981\u7684\u5b57\u6bb5\u6307\u7684\u662f, \u975e\u7a7a\u4e14\u4e0d\u80fd\u81ea\u52a8\u751f\u6210(\u4e0d\u81ea\u589e\u4e14\u6ca1\u6709\u9ed8\u8ba4\u503c)\n<br/>\n\u6ce8\u610f: \u8be5\u65b9\u6cd5\u6784\u9020\u7684\u5b9e\u4f53\u4ec5\u7528\u4f5c\u6570\u636e\u5e93\u63d2\u5165, \u5176\u5185\u90e8\u5c5e\u6027\u4e0d\u662f\u7a7a\u5b89\u5168\u7684(kotlin) ", new Object[0]).addModifiers($i$f$forEach2232).returns((TypeName)ClassName.bestGuess((String)className)).addCode(className + " object = new " + className + "();\n", new Object[0]);
                Iterable $this$forEach$iv4 = necessaryColumns;
                boolean bl5 = false;
                for (Object element$iv4 : $this$forEach$iv4) {
                    String[] stringArray;
                    Field field = (Field)element$iv4;
                    boolean bl6 = false;
                    String fieldName3 = StringExtensionKt.getPascalName(field.getName());
                    Field $this$JavaType$iv = field;
                    boolean $i$f$getJavaType = false;
                    if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                        if ($this$JavaType$iv.getLength() == 1L) {
                            String[] answer$iv$iv$iv22 = ClassName.BOOLEAN.box();
                            Intrinsics.checkNotNullExpressionValue((Object)answer$iv$iv$iv22, (String)"BOOLEAN.box()");
                            stringArray = answer$iv$iv$iv22;
                        } else {
                            ArrayTypeName answer$iv$iv$iv22 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                            Intrinsics.checkNotNullExpressionValue((Object)answer$iv$iv$iv22, (String)"of(ClassName.BYTE)");
                            stringArray = (TypeName)answer$iv$iv$iv22;
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                        char thirdChar$iv;
                        if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv == '-' || Character.isUpperCase(thirdChar$iv))) {
                            String[] stringArray2 = ClassName.BOOLEAN.box();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"BOOLEAN.box()");
                            stringArray = stringArray2;
                        } else {
                            TypeName typeName = ClassName.INT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"INT.box()");
                            stringArray = typeName;
                        }
                    } else {
                        String[] stringArray3 = new String[]{"smallint", "mediumint"};
                        if (CollectionsKt.listOf((Object[])stringArray3).contains($this$JavaType$iv.getDbType())) {
                            stringArray3 = ClassName.INT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"INT.box()");
                            stringArray = stringArray3;
                        } else {
                            stringArray3 = new String[]{"int", "integer"};
                            if (CollectionsKt.listOf((Object[])stringArray3).contains($this$JavaType$iv.getDbType())) {
                                if ($this$JavaType$iv.getUnsigned()) {
                                    stringArray3 = ClassName.LONG.box();
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"LONG.box()");
                                    stringArray = stringArray3;
                                } else {
                                    stringArray3 = ClassName.INT.box();
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"INT.box()");
                                    stringArray = stringArray3;
                                }
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                                if ($this$JavaType$iv.getUnsigned()) {
                                    stringArray3 = ClassName.get(BigInteger.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"get(BigInteger::class.java)");
                                    stringArray = stringArray3;
                                } else {
                                    stringArray3 = ClassName.LONG.box();
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"LONG.box()");
                                    stringArray = stringArray3;
                                }
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                                stringArray3 = ClassName.FLOAT.box();
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"FLOAT.box()");
                                stringArray = stringArray3;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                                stringArray3 = ClassName.DOUBLE.box();
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"DOUBLE.box()");
                                stringArray = stringArray3;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                                stringArray3 = ClassName.get(BigDecimal.class);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"get(BigDecimal::class.java)");
                                stringArray = stringArray3;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                                stringArray3 = ClassName.get(LocalDate.class);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"get(LocalDate::class.java)");
                                stringArray = stringArray3;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                                stringArray3 = ClassName.get(LocalDateTime.class);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"get(LocalDateTime::class.java)");
                                stringArray = stringArray3;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                                stringArray3 = ClassName.get(OffsetDateTime.class);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"get(OffsetDateTime::class.java)");
                                stringArray = stringArray3;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                                stringArray3 = ClassName.get(LocalTime.class);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"get(LocalTime::class.java)");
                                stringArray = stringArray3;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                                stringArray3 = ClassName.get(LocalDate.class);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"get(LocalDate::class.java)");
                                stringArray = stringArray3;
                            } else {
                                stringArray3 = new String[]{"char", "varchar"};
                                if (CollectionsKt.listOf((Object[])stringArray3).contains($this$JavaType$iv.getDbType())) {
                                    if ($this$JavaType$iv.getBinary()) {
                                        stringArray3 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                        Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"of(ClassName.BYTE)");
                                        stringArray = (TypeName)stringArray3;
                                    } else {
                                        stringArray3 = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"get(java.lang.String::class.java)");
                                        stringArray = (TypeName)stringArray3;
                                    }
                                } else {
                                    stringArray3 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                                    if (CollectionsKt.listOf((Object[])stringArray3).contains($this$JavaType$iv.getDbType())) {
                                        stringArray3 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                        Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"of(ClassName.BYTE)");
                                        stringArray = stringArray3;
                                    } else {
                                        stringArray3 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                        if (CollectionsKt.listOf((Object[])stringArray3).contains($this$JavaType$iv.getDbType())) {
                                            stringArray3 = ClassName.get(String.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"get(java.lang.String::class.java)");
                                            stringArray = stringArray3;
                                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                            stringArray3 = ClassName.get(String.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"get(java.lang.String::class.java)");
                                            stringArray = stringArray3;
                                        } else {
                                            throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)stringArray, (String)fieldName3, (Modifier[])new Modifier[0]);
                    if (nullableAnnotation) {
                        parameterSpec.addAnnotation(NotNull.class);
                    }
                    forInsertMethod.addParameter(parameterSpec.build());
                    forInsertMethod.addCode("object." + fieldName3 + " = " + fieldName3 + ";\n", new Object[0]);
                }
                forInsertMethod.addCode("return object;", new Object[0]);
                typeSpecBuilder.addMethod(forInsertMethod.build());
            }
        }
        allFieldConstructorBuilder = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(allFieldConstructorBuilder).returns((Type)((Object)String.class)).addCode("return \"" + className + "{ \" +", new Object[0]);
        allFieldConstructorBuilder = $this$toEntityClass;
        MethodSpec.Builder builder2 = builder;
        list = typeSpecBuilder;
        boolean $i$f$map = false;
        fromMethodBuilder = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void var17_65 : $this$mapTo$iv$iv) {
            void it;
            void bl6 = var17_65;
            object = destination$iv$iv4;
            boolean bl3 = false;
            object.add(StringExtensionKt.getPascalName(it.getName()));
        }
        object = (List)destination$iv$iv4;
        list.addMethod(builder2.addCode(CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"+ \", \" +", null, null, (int)0, null, (Function1)toEntityClass.7.INSTANCE, (int)30, null), new Object[0]).addCode("+ \" }\";", new Object[0]).build());
        $this$map$iv = new Modifier[]{Modifier.PUBLIC};
        typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers($this$map$iv).returns(ClassName.INT).addCode("return java.util.Objects.hash(" + ArraysKt.joinToString$default((Object[])$this$toEntityClass, (CharSequence)", ", null, null, (int)0, null, (Function1)toEntityClass.8.INSTANCE, (int)30, null) + ");", new Object[0]).build());
        $this$map$iv = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers($this$map$iv).returns(ClassName.BOOLEAN).addParameter((Type)((Object)Object.class), "o", new Modifier[0]).addCode("if (this == o) return true;\n", new Object[0]).addCode("if (o == null || getClass() != o.getClass()) return false;\n", new Object[0]).addCode(className + " other = (" + className + ") o;\n", new Object[0]);
        $this$map$iv = $this$toEntityClass;
        object = new StringBuilder().append("return ");
        builder2 = builder3;
        list = typeSpecBuilder;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        for (Modifier modifier : $this$mapTo$iv$iv) {
            Modifier it = modifier;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(StringExtensionKt.getPascalName(((Field)((Object)it)).getName()));
        }
        collection = (List)destination$iv$iv2;
        list.addMethod(builder2.addCode(((StringBuilder)object).append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)" && ", null, null, (int)0, null, (Function1)toEntityClass.10.INSTANCE, (int)30, null)).append(';').toString(), new Object[0]).build());
        modifierArray2 = typeSpecBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)modifierArray2, (String)"typeSpecBuilder.build()");
        return modifierArray2;
    }

    public static /* synthetic */ TypeSpec toEntityClass$default(Field[] fieldArray, String string, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return ExtensionsKt.toEntityClass(fieldArray, string, bl, bl2, bl3);
    }

    @NotNull
    public static final TypeSpec.Builder addColumnGetterAndSetter(@NotNull TypeSpec.Builder $this$addColumnGetterAndSetter, @NotNull Field field, boolean nullableAnnotation) {
        String[] stringArray;
        String[] stringArray2;
        Intrinsics.checkNotNullParameter((Object)$this$addColumnGetterAndSetter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String columnName = field.getName();
        Field $this$JavaType$iv = field;
        boolean $i$f$getJavaType = false;
        if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
            if ($this$JavaType$iv.getLength() == 1L) {
                String[] stringArray3 = ClassName.BOOLEAN.box();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"BOOLEAN.box()");
                stringArray2 = stringArray3;
            } else {
                ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(ClassName.BYTE)");
                stringArray2 = (TypeName)arrayTypeName;
            }
        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
            char thirdChar$iv2;
            if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv2 = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv2 == '-' || Character.isUpperCase(thirdChar$iv2))) {
                stringArray = ClassName.BOOLEAN.box();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"BOOLEAN.box()");
                stringArray2 = stringArray;
            } else {
                TypeName thirdChar$iv2 = ClassName.INT.box();
                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"INT.box()");
                stringArray2 = thirdChar$iv2;
            }
        } else {
            String[] thirdChar$iv2 = new String[]{"smallint", "mediumint"};
            if (CollectionsKt.listOf((Object[])thirdChar$iv2).contains($this$JavaType$iv.getDbType())) {
                thirdChar$iv2 = ClassName.INT.box();
                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"INT.box()");
                stringArray2 = thirdChar$iv2;
            } else {
                thirdChar$iv2 = new String[]{"int", "integer"};
                if (CollectionsKt.listOf((Object[])thirdChar$iv2).contains($this$JavaType$iv.getDbType())) {
                    if ($this$JavaType$iv.getUnsigned()) {
                        thirdChar$iv2 = ClassName.LONG.box();
                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"LONG.box()");
                        stringArray2 = thirdChar$iv2;
                    } else {
                        thirdChar$iv2 = ClassName.INT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"INT.box()");
                        stringArray2 = thirdChar$iv2;
                    }
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                    if ($this$JavaType$iv.getUnsigned()) {
                        thirdChar$iv2 = ClassName.get(BigInteger.class);
                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(BigInteger::class.java)");
                        stringArray2 = thirdChar$iv2;
                    } else {
                        thirdChar$iv2 = ClassName.LONG.box();
                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"LONG.box()");
                        stringArray2 = thirdChar$iv2;
                    }
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                    thirdChar$iv2 = ClassName.FLOAT.box();
                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"FLOAT.box()");
                    stringArray2 = thirdChar$iv2;
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                    thirdChar$iv2 = ClassName.DOUBLE.box();
                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"DOUBLE.box()");
                    stringArray2 = thirdChar$iv2;
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                    thirdChar$iv2 = ClassName.get(BigDecimal.class);
                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(BigDecimal::class.java)");
                    stringArray2 = thirdChar$iv2;
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                    thirdChar$iv2 = ClassName.get(LocalDate.class);
                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(LocalDate::class.java)");
                    stringArray2 = thirdChar$iv2;
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                    thirdChar$iv2 = ClassName.get(LocalDateTime.class);
                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(LocalDateTime::class.java)");
                    stringArray2 = thirdChar$iv2;
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                    thirdChar$iv2 = ClassName.get(OffsetDateTime.class);
                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(OffsetDateTime::class.java)");
                    stringArray2 = thirdChar$iv2;
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                    thirdChar$iv2 = ClassName.get(LocalTime.class);
                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(LocalTime::class.java)");
                    stringArray2 = thirdChar$iv2;
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                    thirdChar$iv2 = ClassName.get(LocalDate.class);
                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(LocalDate::class.java)");
                    stringArray2 = thirdChar$iv2;
                } else {
                    thirdChar$iv2 = new String[]{"char", "varchar"};
                    if (CollectionsKt.listOf((Object[])thirdChar$iv2).contains($this$JavaType$iv.getDbType())) {
                        if ($this$JavaType$iv.getBinary()) {
                            thirdChar$iv2 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"of(ClassName.BYTE)");
                            stringArray2 = (TypeName)thirdChar$iv2;
                        } else {
                            thirdChar$iv2 = ClassName.get(String.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(java.lang.String::class.java)");
                            stringArray2 = (TypeName)thirdChar$iv2;
                        }
                    } else {
                        thirdChar$iv2 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                        if (CollectionsKt.listOf((Object[])thirdChar$iv2).contains($this$JavaType$iv.getDbType())) {
                            thirdChar$iv2 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"of(ClassName.BYTE)");
                            stringArray2 = thirdChar$iv2;
                        } else {
                            thirdChar$iv2 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                            if (CollectionsKt.listOf((Object[])thirdChar$iv2).contains($this$JavaType$iv.getDbType())) {
                                thirdChar$iv2 = ClassName.get(String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(java.lang.String::class.java)");
                                stringArray2 = thirdChar$iv2;
                            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                thirdChar$iv2 = ClassName.get(String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(java.lang.String::class.java)");
                                stringArray2 = thirdChar$iv2;
                            } else {
                                throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                            }
                        }
                    }
                }
            }
        }
        String[] type = stringArray2;
        boolean notNull = field.getNotNull();
        String pascalName2 = StringExtensionKt.getPascalName(columnName);
        Modifier[] thirdChar$iv2 = new Modifier[]{Modifier.PRIVATE};
        $this$addColumnGetterAndSetter.addField((TypeName)type, pascalName2, thirdChar$iv2);
        stringArray = new String[]{columnName};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)Intrinsics.stringPlus((String)"get", (Object)pascalName2)).addAnnotation(AnnotationSpec.builder(SqlExColumnName.class).addMember("value", "$S", (Object[])stringArray).build());
        stringArray = new String[]{Modifier.PUBLIC};
        MethodSpec.Builder getterMethodSpec = builder.addModifiers((Modifier[])stringArray).addStatement(Intrinsics.stringPlus((String)"return this.", (Object)pascalName2), new Object[0]).returns((TypeName)type);
        if (nullableAnnotation) {
            if (notNull) {
                getterMethodSpec.addAnnotation(NotNull.class);
            } else {
                getterMethodSpec.addAnnotation(Nullable.class);
            }
        }
        $this$addColumnGetterAndSetter.addMethod(getterMethodSpec.build());
        ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)type, (String)"value", (Modifier[])new Modifier[0]);
        if (nullableAnnotation) {
            if (notNull) {
                parameterSpec.addAnnotation(NotNull.class);
            } else {
                parameterSpec.addAnnotation(Nullable.class);
            }
        }
        Object[] objectArray = new Object[]{columnName};
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)Intrinsics.stringPlus((String)"set", (Object)pascalName2)).addAnnotation(AnnotationSpec.builder(SqlExColumnName.class).addMember("value", "$S", objectArray).build());
        objectArray = new Modifier[]{Modifier.PUBLIC};
        $this$addColumnGetterAndSetter.addMethod(builder2.addModifiers((Modifier[])objectArray).addParameter(parameterSpec.build()).addStatement("this." + pascalName2 + " = value", new Object[0]).build());
        return $this$addColumnGetterAndSetter;
    }

    public static /* synthetic */ TypeSpec.Builder addColumnGetterAndSetter$default(TypeSpec.Builder builder, Field field, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ExtensionsKt.addColumnGetterAndSetter(builder, field, bl);
    }
}

