/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.parser.generate;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.annotation.SqlExRepository;
import me.danwi.sqlex.core.jdbc.ParameterSetter;
import me.danwi.sqlex.core.query.Column;
import me.danwi.sqlex.core.query.InsertOption;
import me.danwi.sqlex.core.query.TableDelete;
import me.danwi.sqlex.core.query.TableInsert;
import me.danwi.sqlex.core.query.TableQuery;
import me.danwi.sqlex.core.query.TableUpdate;
import me.danwi.sqlex.core.query.expression.Expression;
import me.danwi.sqlex.core.transaction.TransactionManager;
import me.danwi.sqlex.parser.Field;
import me.danwi.sqlex.parser.Session;
import me.danwi.sqlex.parser.TableInfo;
import me.danwi.sqlex.parser.generate.GeneratedJavaFile;
import me.danwi.sqlex.parser.generate.GeneratedTableFile;
import me.danwi.sqlex.parser.util.StringExtensionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001b\u0010 \u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0018H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lme/danwi/sqlex/parser/generate/GeneratedTableFile;", "Lme/danwi/sqlex/parser/generate/GeneratedJavaFile;", "rootPackage", "", "tableName", "entityQualifiedName", "session", "Lme/danwi/sqlex/parser/Session;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lme/danwi/sqlex/parser/Session;)V", "entityTypeName", "Lcom/squareup/javapoet/ClassName;", "updateClassName", "updateClassTypeName", "kotlin.jvm.PlatformType", "generate", "Lcom/squareup/javapoet/TypeSpec;", "generateColumnExpression", "", "Lcom/squareup/javapoet/FieldSpec;", "columns", "", "Lme/danwi/sqlex/parser/Field;", "([Lme/danwi/sqlex/parser/Field;)Ljava/util/List;", "generateConstructorMethod", "Lcom/squareup/javapoet/MethodSpec;", "generatedColumn", "generateDeleteMethod", "generateFields", "generateSelectMethod", "generateShortCutMethods", "tableInfo", "Lme/danwi/sqlex/parser/TableInfo;", "generateUpdateClass", "([Lme/danwi/sqlex/parser/Field;)Lcom/squareup/javapoet/TypeSpec;", "generateUpdateMethod", "parser"})
public final class GeneratedTableFile
extends GeneratedJavaFile {
    @NotNull
    private final String rootPackage;
    @NotNull
    private final String tableName;
    @NotNull
    private final Session session;
    @NotNull
    private final ClassName entityTypeName;
    @NotNull
    private final String updateClassName;
    private final ClassName updateClassTypeName;

    public GeneratedTableFile(@NotNull String rootPackage, @NotNull String tableName, @NotNull String entityQualifiedName, @NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)rootPackage, (String)"rootPackage");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)entityQualifiedName, (String)"entityQualifiedName");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(rootPackage, Intrinsics.stringPlus((String)StringExtensionKt.getPascalName(tableName), (Object)"Table"));
        this.rootPackage = rootPackage;
        this.tableName = tableName;
        this.session = session;
        String[] stringArray = ClassName.bestGuess((String)Intrinsics.stringPlus((String)"sqlex.no.not.hide.package.", (Object)entityQualifiedName));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"bestGuess(DoNotHidePacka\u2026ix + entityQualifiedName)");
        this.entityTypeName = stringArray;
        this.updateClassName = "Update";
        stringArray = new String[]{this.updateClassName};
        this.updateClassTypeName = ClassName.get((String)this.rootPackage, (String)this.getClassName(), (String[])stringArray);
    }

    @Override
    @NotNull
    protected TypeSpec generate() {
        TypeName typeName;
        Field generatedColumn;
        Field field;
        TableInfo tableInfo;
        block48: {
            tableInfo = this.session.getTableInfo(this.tableName);
            for (Field field2 : tableInfo.getColumns()) {
                Field it = field2;
                boolean bl = false;
                if (!it.isAutoIncrement()) continue;
                field = field2;
                break block48;
            }
            field = null;
        }
        Field field3 = generatedColumn = field;
        if (field3 == null) {
            typeName = null;
        } else {
            Field $this$JavaType$iv = field3;
            boolean $i$f$getJavaType = false;
            if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                if ($this$JavaType$iv.getLength() == 1L) {
                    TypeName typeName2 = ClassName.BOOLEAN.box();
                    Intrinsics.checkNotNullExpressionValue((Object)typeName2, (String)"BOOLEAN.box()");
                    typeName = typeName2;
                } else {
                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(ClassName.BYTE)");
                    typeName = (TypeName)arrayTypeName;
                }
            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                char c;
                if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((c = $this$JavaType$iv.getName().charAt(2)) == '_' || c == '-' || Character.isUpperCase(c))) {
                    TypeName typeName3 = ClassName.BOOLEAN.box();
                    Intrinsics.checkNotNullExpressionValue((Object)typeName3, (String)"BOOLEAN.box()");
                    typeName = typeName3;
                } else {
                    TypeName typeName4 = ClassName.INT.box();
                    Intrinsics.checkNotNullExpressionValue((Object)typeName4, (String)"INT.box()");
                    typeName = typeName4;
                }
            } else {
                Object[] objectArray = new String[]{"smallint", "mediumint"};
                if (CollectionsKt.listOf((Object[])objectArray).contains($this$JavaType$iv.getDbType())) {
                    TypeName typeName5 = ClassName.INT.box();
                    Intrinsics.checkNotNullExpressionValue((Object)typeName5, (String)"INT.box()");
                    typeName = typeName5;
                } else {
                    Object[] objectArray2 = new String[]{"int", "integer"};
                    if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                        if ($this$JavaType$iv.getUnsigned()) {
                            TypeName typeName6 = ClassName.LONG.box();
                            Intrinsics.checkNotNullExpressionValue((Object)typeName6, (String)"LONG.box()");
                            typeName = typeName6;
                        } else {
                            TypeName typeName7 = ClassName.INT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)typeName7, (String)"INT.box()");
                            typeName = typeName7;
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                        if ($this$JavaType$iv.getUnsigned()) {
                            ClassName className = ClassName.get(BigInteger.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(BigInteger::class.java)");
                            typeName = (TypeName)className;
                        } else {
                            TypeName typeName8 = ClassName.LONG.box();
                            Intrinsics.checkNotNullExpressionValue((Object)typeName8, (String)"LONG.box()");
                            typeName = typeName8;
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                        TypeName typeName9 = ClassName.FLOAT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)typeName9, (String)"FLOAT.box()");
                        typeName = typeName9;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                        TypeName typeName10 = ClassName.DOUBLE.box();
                        Intrinsics.checkNotNullExpressionValue((Object)typeName10, (String)"DOUBLE.box()");
                        typeName = typeName10;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                        ClassName className = ClassName.get(BigDecimal.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(BigDecimal::class.java)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                        ClassName className = ClassName.get(LocalDate.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(LocalDate::class.java)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                        ClassName className = ClassName.get(LocalDateTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(LocalDateTime::class.java)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                        ClassName className = ClassName.get(OffsetDateTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(OffsetDateTime::class.java)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                        ClassName className = ClassName.get(LocalTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(LocalTime::class.java)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                        ClassName className = ClassName.get(LocalDate.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(LocalDate::class.java)");
                        typeName = (TypeName)className;
                    } else {
                        Object[] objectArray3 = new String[]{"char", "varchar"};
                        if (CollectionsKt.listOf((Object[])objectArray3).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getBinary()) {
                                ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(ClassName.BYTE)");
                                typeName = (TypeName)arrayTypeName;
                            } else {
                                ClassName className = ClassName.get(String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(java.lang.String::class.java)");
                                typeName = (TypeName)className;
                            }
                        } else {
                            Object[] objectArray4 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                            if (CollectionsKt.listOf((Object[])objectArray4).contains($this$JavaType$iv.getDbType())) {
                                ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(ClassName.BYTE)");
                                typeName = (TypeName)arrayTypeName;
                            } else {
                                Object[] objectArray5 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                if (CollectionsKt.listOf((Object[])objectArray5).contains($this$JavaType$iv.getDbType())) {
                                    ClassName className = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(java.lang.String::class.java)");
                                    typeName = (TypeName)className;
                                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                    ClassName className = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(java.lang.String::class.java)");
                                    typeName = (TypeName)className;
                                } else {
                                    throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                }
                            }
                        }
                    }
                }
            }
        }
        TypeName typeName11 = typeName;
        if (typeName == null) {
            typeName11 = (TypeName)ClassName.get(Void.class);
        }
        TypeName generatedColumnJavaType = typeName11;
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeName[] typeNameArray = new TypeName[]{(TypeName)this.entityTypeName, generatedColumnJavaType};
        Object[] objectArray = new Object[]{ClassName.get((String)this.rootPackage, (String)"Repository", (String[])new String[0])};
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((String)this.getClassName()).addModifiers(modifierArray).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TableInsert.class), (TypeName[])typeNameArray)).addAnnotation(AnnotationSpec.builder(SqlExRepository.class).addMember("value", "$T.class", objectArray).build());
        typeSpecBuilder.addFields((Iterable)this.generateFields());
        typeSpecBuilder.addMethod(this.generateConstructorMethod(generatedColumn));
        typeSpecBuilder.addFields((Iterable)this.generateColumnExpression(tableInfo.getColumns()));
        typeSpecBuilder.addType(this.generateUpdateClass(tableInfo.getColumns()));
        typeSpecBuilder.addMethod(this.generateUpdateMethod());
        typeSpecBuilder.addMethod(this.generateDeleteMethod());
        typeSpecBuilder.addMethod(this.generateSelectMethod());
        typeSpecBuilder.addMethods((Iterable)this.generateShortCutMethods(tableInfo));
        TypeSpec typeSpec = typeSpecBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"typeSpecBuilder.build()");
        return typeSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldSpec> generateColumnExpression(Field[] columns) {
        void $this$mapTo$iv$iv;
        Field[] $this$map$iv = columns;
        boolean $i$f$map = false;
        Field[] fieldArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = 0;
        int n2 = ((void)var7_7).length;
        while (n < n2) {
            JDBCType jDBCType;
            void it;
            void item$iv$iv = var7_7[n];
            ++n;
            void var11_11 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL};
            FieldSpec.Builder builder = FieldSpec.builder((TypeName)((TypeName)ClassName.get(Column.class)), (String)StringExtensionKt.getPascalName(it.getName()), (Modifier[])new Modifier[0]).addModifiers(objectArray);
            objectArray = new Object[14];
            objectArray[0] = ClassName.get(Column.class);
            objectArray[1] = this.tableName;
            objectArray[2] = it.getName();
            objectArray[3] = it.getDbType();
            void $this$JdbcType$iv = it;
            boolean $i$f$getJdbcType = false;
            switch ($this$JdbcType$iv.getDbType()) {
                case "bit": {
                    jDBCType = JDBCType.BIT;
                    break;
                }
                case "tinyint": {
                    jDBCType = JDBCType.TINYINT;
                    break;
                }
                case "smallint": {
                    jDBCType = JDBCType.SMALLINT;
                    break;
                }
                case "mediumint": {
                    jDBCType = JDBCType.INTEGER;
                    break;
                }
                case "int": {
                    jDBCType = JDBCType.INTEGER;
                    break;
                }
                case "bigint": {
                    jDBCType = JDBCType.BIGINT;
                    break;
                }
                case "float": {
                    jDBCType = JDBCType.REAL;
                    break;
                }
                case "double": {
                    jDBCType = JDBCType.DOUBLE;
                    break;
                }
                case "decimal": {
                    jDBCType = JDBCType.DECIMAL;
                    break;
                }
                case "date": {
                    jDBCType = JDBCType.DATE;
                    break;
                }
                case "datetime": {
                    jDBCType = JDBCType.TIMESTAMP;
                    break;
                }
                case "timestamp": {
                    jDBCType = JDBCType.TIMESTAMP;
                    break;
                }
                case "time": {
                    jDBCType = JDBCType.TIME;
                    break;
                }
                case "year": {
                    jDBCType = JDBCType.DATE;
                    break;
                }
                case "char": {
                    if ($this$JdbcType$iv.getBinary()) {
                        jDBCType = JDBCType.BINARY;
                        break;
                    }
                    jDBCType = JDBCType.CHAR;
                    break;
                }
                case "varchar": {
                    if ($this$JdbcType$iv.getBinary()) {
                        jDBCType = JDBCType.VARBINARY;
                        break;
                    }
                    jDBCType = JDBCType.VARCHAR;
                    break;
                }
                case "binary": {
                    jDBCType = JDBCType.BINARY;
                    break;
                }
                case "varbinary": {
                    jDBCType = JDBCType.VARBINARY;
                    break;
                }
                case "tinyblob": {
                    jDBCType = JDBCType.VARBINARY;
                    break;
                }
                case "tinytext": {
                    jDBCType = JDBCType.VARCHAR;
                    break;
                }
                case "blob": {
                    jDBCType = JDBCType.LONGVARBINARY;
                    break;
                }
                case "text": {
                    jDBCType = JDBCType.LONGVARCHAR;
                    break;
                }
                case "mediumblob": {
                    jDBCType = JDBCType.LONGVARBINARY;
                    break;
                }
                case "mediumtext": {
                    jDBCType = JDBCType.LONGVARCHAR;
                    break;
                }
                case "longblob": {
                    jDBCType = JDBCType.LONGVARBINARY;
                    break;
                }
                case "longtext": {
                    jDBCType = JDBCType.LONGVARCHAR;
                    break;
                }
                case "json": {
                    jDBCType = JDBCType.LONGVARCHAR;
                    break;
                }
                case "geometry": {
                    jDBCType = JDBCType.BINARY;
                    break;
                }
                case "enum": {
                    jDBCType = JDBCType.CHAR;
                    break;
                }
                case "set": {
                    jDBCType = JDBCType.CHAR;
                    break;
                }
                case "null": {
                    jDBCType = JDBCType.NULL;
                    break;
                }
                default: {
                    throw new Exception("db[" + $this$JdbcType$iv.getDbType() + "] -> jdbc \u6620\u5c04\u5931\u8d25!!!");
                }
            }
            objectArray[4] = Intrinsics.stringPlus((String)"java.sql.JDBCType.", (Object)jDBCType.name());
            objectArray[5] = Long.valueOf(it.getLength());
            objectArray[6] = Boolean.valueOf(it.getUnsigned());
            objectArray[7] = Boolean.valueOf(it.getBinary());
            objectArray[8] = Long.valueOf(it.getDecimal());
            objectArray[9] = Boolean.valueOf(it.isPrimaryKey());
            objectArray[10] = Boolean.valueOf(it.isAutoIncrement());
            objectArray[11] = Boolean.valueOf(it.isUnique());
            objectArray[12] = Boolean.valueOf(it.getNotNull());
            objectArray[13] = Boolean.valueOf(it.getHasDefaultValue());
            collection.add(builder.initializer(CodeBlock.of((String)"new $T($S,$S, $S,$L,$LL, $L,$L,$LL, $L,$L,$L, $L,$L)", (Object[])objectArray)).build());
        }
        return (List)destination$iv$iv;
    }

    private final List<FieldSpec> generateFields() {
        Object[] objectArray = new FieldSpec[3];
        Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
        objectArray[0] = FieldSpec.builder((TypeName)((TypeName)ClassName.get(TransactionManager.class)), (String)"transactionManager", (Modifier[])modifierArray).build();
        modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
        objectArray[1] = FieldSpec.builder((TypeName)((TypeName)ClassName.get(ParameterSetter.class)), (String)"parameterSetter", (Modifier[])modifierArray).build();
        modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
        objectArray[2] = FieldSpec.builder((TypeName)((TypeName)ClassName.get(ExceptionTranslator.class)), (String)"translator", (Modifier[])modifierArray).build();
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final MethodSpec generateConstructorMethod(Field generatedColumn) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder constructorMethod = MethodSpec.constructorBuilder().addModifiers(objectArray).addParameter((TypeName)ClassName.get(TransactionManager.class), "transactionManager", new Modifier[0]).addParameter((TypeName)ClassName.get(ParameterSetter.class), "parameterSetter", new Modifier[0]).addParameter((TypeName)ClassName.get(ExceptionTranslator.class), "translator", new Modifier[0]);
        if (generatedColumn != null) {
            String[] stringArray;
            objectArray = new Object[2];
            objectArray[0] = this.tableName;
            Field $this$JavaType$iv = generatedColumn;
            boolean $i$f$getJavaType = false;
            if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                if ($this$JavaType$iv.getLength() == 1L) {
                    String[] stringArray2 = ClassName.BOOLEAN.box();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"BOOLEAN.box()");
                    stringArray = stringArray2;
                } else {
                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(ClassName.BYTE)");
                    stringArray = (TypeName)arrayTypeName;
                }
            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                char thirdChar$iv;
                if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv == '-' || Character.isUpperCase(thirdChar$iv))) {
                    String[] stringArray3 = ClassName.BOOLEAN.box();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"BOOLEAN.box()");
                    stringArray = stringArray3;
                } else {
                    TypeName typeName = ClassName.INT.box();
                    Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"INT.box()");
                    stringArray = typeName;
                }
            } else {
                String[] stringArray4 = new String[]{"smallint", "mediumint"};
                if (CollectionsKt.listOf((Object[])stringArray4).contains($this$JavaType$iv.getDbType())) {
                    stringArray4 = ClassName.INT.box();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"INT.box()");
                    stringArray = stringArray4;
                } else {
                    stringArray4 = new String[]{"int", "integer"};
                    if (CollectionsKt.listOf((Object[])stringArray4).contains($this$JavaType$iv.getDbType())) {
                        if ($this$JavaType$iv.getUnsigned()) {
                            stringArray4 = ClassName.LONG.box();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"LONG.box()");
                            stringArray = stringArray4;
                        } else {
                            stringArray4 = ClassName.INT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"INT.box()");
                            stringArray = stringArray4;
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                        if ($this$JavaType$iv.getUnsigned()) {
                            stringArray4 = ClassName.get(BigInteger.class);
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(BigInteger::class.java)");
                            stringArray = stringArray4;
                        } else {
                            stringArray4 = ClassName.LONG.box();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"LONG.box()");
                            stringArray = stringArray4;
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                        stringArray4 = ClassName.FLOAT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"FLOAT.box()");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                        stringArray4 = ClassName.DOUBLE.box();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"DOUBLE.box()");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                        stringArray4 = ClassName.get(BigDecimal.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(BigDecimal::class.java)");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                        stringArray4 = ClassName.get(LocalDate.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(LocalDate::class.java)");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                        stringArray4 = ClassName.get(LocalDateTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(LocalDateTime::class.java)");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                        stringArray4 = ClassName.get(OffsetDateTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(OffsetDateTime::class.java)");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                        stringArray4 = ClassName.get(LocalTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(LocalTime::class.java)");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                        stringArray4 = ClassName.get(LocalDate.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(LocalDate::class.java)");
                        stringArray = stringArray4;
                    } else {
                        stringArray4 = new String[]{"char", "varchar"};
                        if (CollectionsKt.listOf((Object[])stringArray4).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getBinary()) {
                                stringArray4 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"of(ClassName.BYTE)");
                                stringArray = (TypeName)stringArray4;
                            } else {
                                stringArray4 = ClassName.get(String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(java.lang.String::class.java)");
                                stringArray = (TypeName)stringArray4;
                            }
                        } else {
                            stringArray4 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                            if (CollectionsKt.listOf((Object[])stringArray4).contains($this$JavaType$iv.getDbType())) {
                                stringArray4 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"of(ClassName.BYTE)");
                                stringArray = stringArray4;
                            } else {
                                stringArray4 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                if (CollectionsKt.listOf((Object[])stringArray4).contains($this$JavaType$iv.getDbType())) {
                                    stringArray4 = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(java.lang.String::class.java)");
                                    stringArray = stringArray4;
                                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                    stringArray4 = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(java.lang.String::class.java)");
                                    stringArray = stringArray4;
                                } else {
                                    throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                }
                            }
                        }
                    }
                }
            }
            objectArray[1] = stringArray;
            constructorMethod.addCode("super($S, $T.class, transactionManager, parameterSetter, translator);\n", objectArray);
        } else {
            objectArray = new Object[]{this.tableName};
            constructorMethod.addCode("super($S, null, transactionManager, parameterSetter, translator);\n", objectArray);
        }
        objectArray = constructorMethod.addCode("this.transactionManager = transactionManager;\n", new Object[0]).addCode("this.parameterSetter = parameterSetter;\n", new Object[0]).addCode("this.translator = translator;", new Object[0]).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"constructorMethod\n      \u2026r;\")\n            .build()");
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec generateUpdateClass(Field[] columns) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.updateClassName).addModifiers(objectArray);
        objectArray = new TypeName[]{(TypeName)this.updateClassTypeName};
        TypeSpec.Builder typeSpecBuilder = builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TableUpdate.class), (TypeName[])objectArray));
        objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder2 = MethodSpec.constructorBuilder().addModifiers(objectArray).addParameter((TypeName)ClassName.get(TransactionManager.class), "transactionManager", new Modifier[0]).addParameter((TypeName)ClassName.get(ParameterSetter.class), "parameterSetter", new Modifier[0]).addParameter((TypeName)ClassName.get(ExceptionTranslator.class), "translator", new Modifier[0]);
        objectArray = new Object[]{this.tableName};
        typeSpecBuilder.addMethod(builder2.addCode("super($S, transactionManager, parameterSetter, translator);\n", objectArray).build());
        objectArray = columns;
        TypeSpec.Builder builder3 = typeSpecBuilder;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var8_9 = $this$mapTo$iv$iv;
        int n = 0;
        int n2 = ((void)var8_9).length;
        while (n < n2) {
            String[] stringArray;
            void it;
            void item$iv$iv = var8_9[n];
            ++n;
            void var12_13 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$JavaType$iv = it;
            boolean $i$f$getJavaType = false;
            if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                if ($this$JavaType$iv.getLength() == 1L) {
                    String[] stringArray2 = ClassName.BOOLEAN.box();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"BOOLEAN.box()");
                    stringArray = stringArray2;
                } else {
                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(ClassName.BYTE)");
                    stringArray = (TypeName)arrayTypeName;
                }
            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                char thirdChar$iv;
                if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv == '-' || Character.isUpperCase(thirdChar$iv))) {
                    String[] stringArray3 = ClassName.BOOLEAN.box();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"BOOLEAN.box()");
                    stringArray = stringArray3;
                } else {
                    TypeName typeName = ClassName.INT.box();
                    Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"INT.box()");
                    stringArray = typeName;
                }
            } else {
                String[] stringArray4 = new String[]{"smallint", "mediumint"};
                if (CollectionsKt.listOf((Object[])stringArray4).contains($this$JavaType$iv.getDbType())) {
                    stringArray4 = ClassName.INT.box();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"INT.box()");
                    stringArray = stringArray4;
                } else {
                    stringArray4 = new String[]{"int", "integer"};
                    if (CollectionsKt.listOf((Object[])stringArray4).contains($this$JavaType$iv.getDbType())) {
                        if ($this$JavaType$iv.getUnsigned()) {
                            stringArray4 = ClassName.LONG.box();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"LONG.box()");
                            stringArray = stringArray4;
                        } else {
                            stringArray4 = ClassName.INT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"INT.box()");
                            stringArray = stringArray4;
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                        if ($this$JavaType$iv.getUnsigned()) {
                            stringArray4 = ClassName.get(BigInteger.class);
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(BigInteger::class.java)");
                            stringArray = stringArray4;
                        } else {
                            stringArray4 = ClassName.LONG.box();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"LONG.box()");
                            stringArray = stringArray4;
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                        stringArray4 = ClassName.FLOAT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"FLOAT.box()");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                        stringArray4 = ClassName.DOUBLE.box();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"DOUBLE.box()");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                        stringArray4 = ClassName.get(BigDecimal.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(BigDecimal::class.java)");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                        stringArray4 = ClassName.get(LocalDate.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(LocalDate::class.java)");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                        stringArray4 = ClassName.get(LocalDateTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(LocalDateTime::class.java)");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                        stringArray4 = ClassName.get(OffsetDateTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(OffsetDateTime::class.java)");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                        stringArray4 = ClassName.get(LocalTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(LocalTime::class.java)");
                        stringArray = stringArray4;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                        stringArray4 = ClassName.get(LocalDate.class);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(LocalDate::class.java)");
                        stringArray = stringArray4;
                    } else {
                        stringArray4 = new String[]{"char", "varchar"};
                        if (CollectionsKt.listOf((Object[])stringArray4).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getBinary()) {
                                stringArray4 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"of(ClassName.BYTE)");
                                stringArray = (TypeName)stringArray4;
                            } else {
                                stringArray4 = ClassName.get(String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(java.lang.String::class.java)");
                                stringArray = (TypeName)stringArray4;
                            }
                        } else {
                            stringArray4 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                            if (CollectionsKt.listOf((Object[])stringArray4).contains($this$JavaType$iv.getDbType())) {
                                stringArray4 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"of(ClassName.BYTE)");
                                stringArray = stringArray4;
                            } else {
                                stringArray4 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                if (CollectionsKt.listOf((Object[])stringArray4).contains($this$JavaType$iv.getDbType())) {
                                    stringArray4 = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(java.lang.String::class.java)");
                                    stringArray = stringArray4;
                                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                    stringArray4 = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray4, (String)"get(java.lang.String::class.java)");
                                    stringArray = stringArray4;
                                } else {
                                    throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                }
                            }
                        }
                    }
                }
            }
            ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)stringArray, (String)"value", (Modifier[])new Modifier[0]).addAnnotation(it.getNotNull() ? NotNull.class : Nullable.class);
            Object[] objectArray2 = new Modifier[]{Modifier.PUBLIC};
            MethodSpec.Builder builder4 = MethodSpec.methodBuilder((String)Intrinsics.stringPlus((String)"set", (Object)StringExtensionKt.getPascalName(it.getName()))).addModifiers(objectArray2).returns((TypeName)this.updateClassTypeName).addParameter(parameterSpec.build());
            objectArray2 = new Object[]{it.getName()};
            collection.add(builder4.addCode("super.values.put($S, value);\n", objectArray2).addCode("return this;", new Object[0]).build());
        }
        builder3.addMethods((Iterable)((List)destination$iv$iv));
        objectArray = typeSpecBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"typeSpecBuilder.build()");
        return objectArray;
    }

    private final MethodSpec generateUpdateMethod() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"update").addModifiers(objectArray).returns((TypeName)this.updateClassTypeName);
        objectArray = new Object[]{this.updateClassTypeName};
        MethodSpec methodSpec = builder.addCode("return new $T(this.transactionManager, this.parameterSetter, this.translator);", objectArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(\"update\")\n\u2026   )\n            .build()");
        return methodSpec;
    }

    private final MethodSpec generateDeleteMethod() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"delete").addModifiers(objectArray).returns((TypeName)ClassName.get(TableDelete.class));
        objectArray = new Object[]{TableDelete.class, this.tableName};
        MethodSpec methodSpec = builder.addCode("return new $T($S, this.transactionManager, this.parameterSetter, this.translator);", objectArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(\"delete\")\n\u2026   )\n            .build()");
        return methodSpec;
    }

    private final MethodSpec generateSelectMethod() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"select").addModifiers(objectArray);
        objectArray = new TypeName[]{(TypeName)this.entityTypeName};
        MethodSpec.Builder builder2 = builder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TableQuery.class), (TypeName[])objectArray));
        objectArray = new Object[]{TableQuery.class, this.tableName, this.entityTypeName};
        MethodSpec methodSpec = builder2.addCode("return new $T<>($S, this.transactionManager, this.parameterSetter, this.translator, $T.class);", objectArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(\"select\")\n\u2026   )\n            .build()");
        return methodSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MethodSpec> generateShortCutMethods(TableInfo tableInfo) {
        List list;
        Modifier[] $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Field field;
        Field field2;
        Field field32;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        Object[] $this$map$iv = (Object[])tableInfo.getUniques();
        boolean $i$f$map22 = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_13 = $this$mapTo$iv$iv;
        int n = 0;
        int n2 = ((void)var8_13).length;
        while (n < n2) {
            void $this$mapTo$iv$iv2;
            void it;
            Iterator item$iv$iv = var8_13[n];
            ++n;
            String[] stringArray = (String[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$map$iv2 = it;
            boolean $i$f$map = false;
            void var16_52 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv2).length);
            boolean $i$f$mapTo2 = false;
            void var19_64 = $this$mapTo$iv$iv2;
            int n3 = 0;
            int n4 = ((void)var19_64).length;
            while (n3 < n4) {
                block149: {
                    Field field4;
                    Field[] fieldArray;
                    void item$iv$iv2 = var19_64[n3];
                    ++n3;
                    void var23_87 = item$iv$iv2;
                    object2 = destination$iv$iv2;
                    boolean bl2 = false;
                    object = tableInfo.getColumns();
                    for (Field field32 : fieldArray = object) {
                        void it2;
                        Field c = field32;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)c.getName(), (Object)it2)) continue;
                        field4 = field32;
                        break block149;
                    }
                    field4 = field2 = null;
                }
                if (field2 == null) {
                    return CollectionsKt.emptyList();
                }
                object2.add(field);
            }
            List list2 = (List)destination$iv$iv2;
            collection.add(list2);
        }
        List uniqueColumns = (List)destination$iv$iv;
        Iterable $i$f$map22 = uniqueColumns;
        boolean $i$f$mapNotNull22 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            void $this$mapTo$iv$iv3;
            Object item$iv$iv3;
            void $this$mapTo$iv$iv4;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            List it = (List)element$iv$iv;
            boolean bl4 = false;
            Iterable $this$map$iv3 = it;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv3;
            Object destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv4) {
                String[] stringArray;
                void c;
                object2 = (Field)item$iv$iv3;
                Collection bl2 = destination$iv$iv4;
                boolean bl5 = false;
                void $this$JavaType$iv = c;
                boolean $i$f$getJavaType = false;
                if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                    if ($this$JavaType$iv.getLength() == 1L) {
                        String[] stringArray2 = ClassName.BOOLEAN.box();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"BOOLEAN.box()");
                        stringArray = stringArray2;
                    } else {
                        ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                        Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(ClassName.BYTE)");
                        stringArray = (TypeName)arrayTypeName;
                    }
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                    char thirdChar$iv2;
                    if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv2 = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv2 == '-' || Character.isUpperCase(thirdChar$iv2))) {
                        String[] stringArray3 = ClassName.BOOLEAN.box();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"BOOLEAN.box()");
                        stringArray = stringArray3;
                    } else {
                        TypeName thirdChar$iv2 = ClassName.INT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"INT.box()");
                        stringArray = thirdChar$iv2;
                    }
                } else {
                    String[] thirdChar$iv2 = new String[]{"smallint", "mediumint"};
                    if (CollectionsKt.listOf((Object[])thirdChar$iv2).contains($this$JavaType$iv.getDbType())) {
                        thirdChar$iv2 = ClassName.INT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"INT.box()");
                        stringArray = thirdChar$iv2;
                    } else {
                        thirdChar$iv2 = new String[]{"int", "integer"};
                        if (CollectionsKt.listOf((Object[])thirdChar$iv2).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                thirdChar$iv2 = ClassName.LONG.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"LONG.box()");
                                stringArray = thirdChar$iv2;
                            } else {
                                thirdChar$iv2 = ClassName.INT.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"INT.box()");
                                stringArray = thirdChar$iv2;
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                thirdChar$iv2 = ClassName.get(BigInteger.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(BigInteger::class.java)");
                                stringArray = thirdChar$iv2;
                            } else {
                                thirdChar$iv2 = ClassName.LONG.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"LONG.box()");
                                stringArray = thirdChar$iv2;
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                            thirdChar$iv2 = ClassName.FLOAT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"FLOAT.box()");
                            stringArray = thirdChar$iv2;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                            thirdChar$iv2 = ClassName.DOUBLE.box();
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"DOUBLE.box()");
                            stringArray = thirdChar$iv2;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                            thirdChar$iv2 = ClassName.get(BigDecimal.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(BigDecimal::class.java)");
                            stringArray = thirdChar$iv2;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                            thirdChar$iv2 = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(LocalDate::class.java)");
                            stringArray = thirdChar$iv2;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                            thirdChar$iv2 = ClassName.get(LocalDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(LocalDateTime::class.java)");
                            stringArray = thirdChar$iv2;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                            thirdChar$iv2 = ClassName.get(OffsetDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(OffsetDateTime::class.java)");
                            stringArray = thirdChar$iv2;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                            thirdChar$iv2 = ClassName.get(LocalTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(LocalTime::class.java)");
                            stringArray = thirdChar$iv2;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                            thirdChar$iv2 = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(LocalDate::class.java)");
                            stringArray = thirdChar$iv2;
                        } else {
                            thirdChar$iv2 = new String[]{"char", "varchar"};
                            if (CollectionsKt.listOf((Object[])thirdChar$iv2).contains($this$JavaType$iv.getDbType())) {
                                if ($this$JavaType$iv.getBinary()) {
                                    thirdChar$iv2 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"of(ClassName.BYTE)");
                                    stringArray = (TypeName)thirdChar$iv2;
                                } else {
                                    thirdChar$iv2 = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(java.lang.String::class.java)");
                                    stringArray = (TypeName)thirdChar$iv2;
                                }
                            } else {
                                thirdChar$iv2 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                                if (CollectionsKt.listOf((Object[])thirdChar$iv2).contains($this$JavaType$iv.getDbType())) {
                                    thirdChar$iv2 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"of(ClassName.BYTE)");
                                    stringArray = thirdChar$iv2;
                                } else {
                                    thirdChar$iv2 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                    if (CollectionsKt.listOf((Object[])thirdChar$iv2).contains($this$JavaType$iv.getDbType())) {
                                        thirdChar$iv2 = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(java.lang.String::class.java)");
                                        stringArray = thirdChar$iv2;
                                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                        thirdChar$iv2 = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv2, (String)"get(java.lang.String::class.java)");
                                        stringArray = thirdChar$iv2;
                                    } else {
                                        throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                    }
                                }
                            }
                        }
                    }
                }
                field32 = ParameterSpec.builder((TypeName)stringArray, (String)StringExtensionKt.getPascalName(c.getName()), (Modifier[])new Modifier[0]).build();
                bl2.add(field32);
            }
            List parameters = (List)destination$iv$iv4;
            Modifier[] $this$map$iv4 = (Modifier[])it;
            boolean $i$f$map3 = false;
            destination$iv$iv4 = $this$map$iv4;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            item$iv$iv3 = $this$mapTo$iv$iv3.iterator();
            while (item$iv$iv3.hasNext()) {
                void c;
                Object item$iv$iv4 = item$iv$iv3.next();
                Field bl5 = (Field)item$iv$iv4;
                Collection bl2 = destination$iv$iv5;
                boolean bl6 = false;
                Object[] $i$f$getJavaType = new Object[]{Expression.class};
                field32 = CodeBlock.of((String)("where(" + this.getClassName() + '.' + StringExtensionKt.getPascalName(c.getName()) + ".eq($T.arg(" + StringExtensionKt.getPascalName(c.getName()) + ")))"), (Object[])$i$f$getJavaType);
                bl2.add(field32);
            }
            List whereCodeSegments = (List)destination$iv$iv5;
            $this$map$iv4 = new Modifier[]{Modifier.PUBLIC};
            MethodSpec bl3 = MethodSpec.methodBuilder((String)Intrinsics.stringPlus((String)"findBy", (Object)CollectionsKt.joinToString$default((Iterable)it, (CharSequence)"And", null, null, (int)0, null, (Function1)generateShortCutMethods.findMethods.1.1.INSTANCE, (int)30, null))).addAnnotation(Nullable.class).addModifiers($this$map$iv4).returns((TypeName)this.entityTypeName).addParameters((Iterable)parameters).addCode("return this.select().", new Object[0]).addCode(CodeBlock.join((Iterable)whereCodeSegments, (String)".")).addCode(".findOne();", new Object[0]).build();
            if (bl3 == null) continue;
            Field it$iv$iv = field2;
            boolean bl7 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List findMethods2 = (List)destination$iv$iv3;
        Iterable $i$f$mapNotNull22 = uniqueColumns;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv3 = $this$mapNotNull$iv;
        Object[] destination$iv$iv6 = (Field[])new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        Field[] $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        int $i$f$forEach22 = 0;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            void $this$mapTo$iv$iv5;
            ParameterSpec parameterSpec;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            List it3 = (List)element$iv$iv;
            boolean bl8 = false;
            Iterable $this$map$iv5 = it3;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv3 = $this$map$iv5;
            Iterable destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo5 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                Object object3;
                void c;
                Field bl2 = (Field)item$iv$iv4;
                object = destination$iv$iv7;
                boolean bl9 = false;
                void $this$JavaType$iv = c;
                boolean $i$f$getJavaType = false;
                if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                    if ($this$JavaType$iv.getLength() == 1L) {
                        String[] stringArray = ClassName.BOOLEAN.box();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"BOOLEAN.box()");
                        object3 = stringArray;
                    } else {
                        ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                        Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(ClassName.BYTE)");
                        object3 = (TypeName)arrayTypeName;
                    }
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                    char thirdChar$iv;
                    if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv == '-' || Character.isUpperCase(thirdChar$iv))) {
                        field32 = ClassName.BOOLEAN.box();
                        Intrinsics.checkNotNullExpressionValue((Object)field32, (String)"BOOLEAN.box()");
                        object3 = field32;
                    } else {
                        TypeName typeName = ClassName.INT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"INT.box()");
                        object3 = typeName;
                    }
                } else {
                    String[] stringArray = new String[]{"smallint", "mediumint"};
                    if (CollectionsKt.listOf((Object[])stringArray).contains($this$JavaType$iv.getDbType())) {
                        stringArray = ClassName.INT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"INT.box()");
                        object3 = stringArray;
                    } else {
                        stringArray = new String[]{"int", "integer"};
                        if (CollectionsKt.listOf((Object[])stringArray).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                stringArray = ClassName.LONG.box();
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"LONG.box()");
                                object3 = stringArray;
                            } else {
                                stringArray = ClassName.INT.box();
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"INT.box()");
                                object3 = stringArray;
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                stringArray = ClassName.get(BigInteger.class);
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(BigInteger::class.java)");
                                object3 = stringArray;
                            } else {
                                stringArray = ClassName.LONG.box();
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"LONG.box()");
                                object3 = stringArray;
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                            stringArray = ClassName.FLOAT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"FLOAT.box()");
                            object3 = stringArray;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                            stringArray = ClassName.DOUBLE.box();
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"DOUBLE.box()");
                            object3 = stringArray;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                            stringArray = ClassName.get(BigDecimal.class);
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(BigDecimal::class.java)");
                            object3 = stringArray;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                            stringArray = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(LocalDate::class.java)");
                            object3 = stringArray;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                            stringArray = ClassName.get(LocalDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(LocalDateTime::class.java)");
                            object3 = stringArray;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                            stringArray = ClassName.get(OffsetDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(OffsetDateTime::class.java)");
                            object3 = stringArray;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                            stringArray = ClassName.get(LocalTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(LocalTime::class.java)");
                            object3 = stringArray;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                            stringArray = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(LocalDate::class.java)");
                            object3 = (TypeName)stringArray;
                        } else {
                            stringArray = new String[]{"char", "varchar"};
                            if (CollectionsKt.listOf((Object[])stringArray).contains($this$JavaType$iv.getDbType())) {
                                if ($this$JavaType$iv.getBinary()) {
                                    stringArray = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"of(ClassName.BYTE)");
                                    object3 = (TypeName)stringArray;
                                } else {
                                    stringArray = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(java.lang.String::class.java)");
                                    object3 = (TypeName)stringArray;
                                }
                            } else {
                                stringArray = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                                if (CollectionsKt.listOf((Object[])stringArray).contains($this$JavaType$iv.getDbType())) {
                                    stringArray = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"of(ClassName.BYTE)");
                                    object3 = (TypeName)stringArray;
                                } else {
                                    stringArray = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                    if (CollectionsKt.listOf((Object[])stringArray).contains($this$JavaType$iv.getDbType())) {
                                        stringArray = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(java.lang.String::class.java)");
                                        object3 = (TypeName)stringArray;
                                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                        stringArray = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"get(java.lang.String::class.java)");
                                        object3 = (TypeName)stringArray;
                                    } else {
                                        throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                    }
                                }
                            }
                        }
                    }
                }
                parameterSpec = ParameterSpec.builder((TypeName)object3, (String)StringExtensionKt.getPascalName(c.getName()), (Modifier[])new Modifier[0]).build();
                object.add(parameterSpec);
            }
            List parameters = (List)destination$iv$iv7;
            Iterable $this$map$iv6 = it3;
            boolean $i$f$map4 = false;
            destination$iv$iv7 = $this$map$iv6;
            Collection destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
            boolean $i$f$mapTo6 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv5) {
                void c;
                Field bl9 = (Field)item$iv$iv;
                object = destination$iv$iv8;
                boolean bl10 = false;
                Object[] objectArray2 = new Object[]{Expression.class};
                parameterSpec = CodeBlock.of((String)("where(" + this.getClassName() + '.' + StringExtensionKt.getPascalName(c.getName()) + ".eq($T.arg(" + StringExtensionKt.getPascalName(c.getName()) + ")))"), (Object[])objectArray2);
                object.add(parameterSpec);
            }
            List whereCodeSegments = (List)destination$iv$iv8;
            Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
            field2 = MethodSpec.methodBuilder((String)Intrinsics.stringPlus((String)"deleteBy", (Object)CollectionsKt.joinToString$default((Iterable)it3, (CharSequence)"And", null, null, (int)0, null, (Function1)generateShortCutMethods.deleteMethods.1.1.INSTANCE, (int)30, null))).addModifiers(modifierArray).returns(ClassName.BOOLEAN).addParameters((Iterable)parameters).addCode("return this.delete().", new Object[0]).addCode(CodeBlock.join((Iterable)whereCodeSegments, (String)".")).addCode(".execute() > 0;", new Object[0]).build();
            if (field2 == null) continue;
            Field it$iv$iv = field;
            boolean bl11 = false;
            destination$iv$iv6.add(it$iv$iv);
        }
        List deleteMethods2 = (List)destination$iv$iv6;
        if (!((Collection)uniqueColumns).isEmpty()) {
            Field generatedColumn;
            MethodSpec.Builder saveWithOptionsMethod;
            block150: {
                Field field5;
                $this$mapNotNullTo$iv$iv = new Modifier[]{Modifier.PUBLIC};
                saveWithOptionsMethod = MethodSpec.methodBuilder((String)"save").addAnnotation(Nullable.class).addModifiers($this$mapNotNullTo$iv$iv).returns((TypeName)this.entityTypeName).addParameter((TypeName)this.entityTypeName, "entity", new Modifier[0]).addParameter(ClassName.INT, "options", new Modifier[0]);
                destination$iv$iv6 = tableInfo.getColumns();
                for (Field element$iv$iv$iv3 : $i$f$mapNotNullTo2 = destination$iv$iv6) {
                    Field it = element$iv$iv$iv3;
                    boolean bl = false;
                    if (!it.isAutoIncrement()) continue;
                    field5 = element$iv$iv$iv3;
                    break block150;
                }
                field5 = generatedColumn = null;
            }
            if (generatedColumn != null) {
                String[] stringArray;
                destination$iv$iv6 = new Object[1];
                Field $this$JavaType$iv = generatedColumn;
                boolean $i$f$getJavaType = false;
                if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                    if ($this$JavaType$iv.getLength() == 1L) {
                        String[] $i$f$forEach22 = ClassName.BOOLEAN.box();
                        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach22, (String)"BOOLEAN.box()");
                        stringArray = $i$f$forEach22;
                    } else {
                        ArrayTypeName $i$f$forEach22 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach22, (String)"of(ClassName.BYTE)");
                        stringArray = (TypeName)$i$f$forEach22;
                    }
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                    char thirdChar$iv3;
                    if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv3 = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv3 == '-' || Character.isUpperCase(thirdChar$iv3))) {
                        String[] element$iv$iv$iv2 = ClassName.BOOLEAN.box();
                        Intrinsics.checkNotNullExpressionValue((Object)element$iv$iv$iv2, (String)"BOOLEAN.box()");
                        stringArray = element$iv$iv$iv2;
                    } else {
                        TypeName thirdChar$iv3 = ClassName.INT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"INT.box()");
                        stringArray = thirdChar$iv3;
                    }
                } else {
                    String[] thirdChar$iv3 = new String[]{"smallint", "mediumint"};
                    if (CollectionsKt.listOf((Object[])thirdChar$iv3).contains($this$JavaType$iv.getDbType())) {
                        thirdChar$iv3 = ClassName.INT.box();
                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"INT.box()");
                        stringArray = thirdChar$iv3;
                    } else {
                        thirdChar$iv3 = new String[]{"int", "integer"};
                        if (CollectionsKt.listOf((Object[])thirdChar$iv3).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                thirdChar$iv3 = ClassName.LONG.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"LONG.box()");
                                stringArray = thirdChar$iv3;
                            } else {
                                thirdChar$iv3 = ClassName.INT.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"INT.box()");
                                stringArray = thirdChar$iv3;
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                thirdChar$iv3 = ClassName.get(BigInteger.class);
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"get(BigInteger::class.java)");
                                stringArray = thirdChar$iv3;
                            } else {
                                thirdChar$iv3 = ClassName.LONG.box();
                                Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"LONG.box()");
                                stringArray = thirdChar$iv3;
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                            thirdChar$iv3 = ClassName.FLOAT.box();
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"FLOAT.box()");
                            stringArray = thirdChar$iv3;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                            thirdChar$iv3 = ClassName.DOUBLE.box();
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"DOUBLE.box()");
                            stringArray = thirdChar$iv3;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                            thirdChar$iv3 = ClassName.get(BigDecimal.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"get(BigDecimal::class.java)");
                            stringArray = thirdChar$iv3;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                            thirdChar$iv3 = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"get(LocalDate::class.java)");
                            stringArray = thirdChar$iv3;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                            thirdChar$iv3 = ClassName.get(LocalDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"get(LocalDateTime::class.java)");
                            stringArray = thirdChar$iv3;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                            thirdChar$iv3 = ClassName.get(OffsetDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"get(OffsetDateTime::class.java)");
                            stringArray = thirdChar$iv3;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                            thirdChar$iv3 = ClassName.get(LocalTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"get(LocalTime::class.java)");
                            stringArray = thirdChar$iv3;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                            thirdChar$iv3 = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"get(LocalDate::class.java)");
                            stringArray = thirdChar$iv3;
                        } else {
                            thirdChar$iv3 = new String[]{"char", "varchar"};
                            if (CollectionsKt.listOf((Object[])thirdChar$iv3).contains($this$JavaType$iv.getDbType())) {
                                if ($this$JavaType$iv.getBinary()) {
                                    thirdChar$iv3 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"of(ClassName.BYTE)");
                                    stringArray = (TypeName)thirdChar$iv3;
                                } else {
                                    thirdChar$iv3 = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"get(java.lang.String::class.java)");
                                    stringArray = (TypeName)thirdChar$iv3;
                                }
                            } else {
                                thirdChar$iv3 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                                if (CollectionsKt.listOf((Object[])thirdChar$iv3).contains($this$JavaType$iv.getDbType())) {
                                    thirdChar$iv3 = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"of(ClassName.BYTE)");
                                    stringArray = thirdChar$iv3;
                                } else {
                                    thirdChar$iv3 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                    if (CollectionsKt.listOf((Object[])thirdChar$iv3).contains($this$JavaType$iv.getDbType())) {
                                        thirdChar$iv3 = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"get(java.lang.String::class.java)");
                                        stringArray = thirdChar$iv3;
                                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                        thirdChar$iv3 = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)thirdChar$iv3, (String)"get(java.lang.String::class.java)");
                                        stringArray = thirdChar$iv3;
                                    } else {
                                        throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                    }
                                }
                            }
                        }
                    }
                }
                destination$iv$iv6[0] = stringArray;
                saveWithOptionsMethod.addCode("$T generatedColumnValue = this.insert(entity, options);\n", destination$iv$iv6);
                saveWithOptionsMethod.addCode("if(generatedColumnValue != null) entity.set" + StringExtensionKt.getPascalName(generatedColumn.getName()) + "(generatedColumnValue);\n", new Object[0]);
            } else {
                saveWithOptionsMethod.addCode("this.insert(entity, options);\n", new Object[0]);
            }
            Iterable $this$forEach$iv = uniqueColumns;
            boolean $i$f$forEach232 = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv6;
                List it = (List)element$iv;
                boolean bl = false;
                Iterable $this$map$iv7 = it;
                boolean $i$f$map = false;
                Iterable it3 = $this$map$iv7;
                Collection destination$iv$iv9 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
                boolean $i$f$mapTo7 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv6) {
                    void c;
                    Field $this$mapTo$iv$iv5 = (Field)item$iv$iv;
                    Collection collection = destination$iv$iv9;
                    boolean bl12 = false;
                    object2 = "entity.get" + StringExtensionKt.getPascalName(c.getName()) + "()";
                    collection.add(object2);
                }
                List fieldGetters = (List)destination$iv$iv9;
                String condition2 = CollectionsKt.joinToString$default((Iterable)fieldGetters, (CharSequence)" && ", null, null, (int)0, null, (Function1)generateShortCutMethods.saveMethods.1.condition.1.INSTANCE, (int)30, null);
                String findMethodName2 = Intrinsics.stringPlus((String)"findBy", (Object)CollectionsKt.joinToString$default((Iterable)it, (CharSequence)"And", null, null, (int)0, null, (Function1)generateShortCutMethods.saveMethods.1.findMethodName.1.INSTANCE, (int)30, null));
                String parameters = CollectionsKt.joinToString$default((Iterable)fieldGetters, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                saveWithOptionsMethod.addCode("if(" + condition2 + ") return this." + findMethodName2 + '(' + parameters + ");\n", new Object[0]);
            }
            saveWithOptionsMethod.addCode("return null;", new Object[0]);
            Object[] $i$f$forEach232 = new Modifier[]{Modifier.PUBLIC};
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"save").addAnnotation(Nullable.class).addModifiers($i$f$forEach232).returns((TypeName)this.entityTypeName).addParameter((TypeName)this.entityTypeName, "entity", new Modifier[0]);
            $i$f$forEach232 = new Object[]{InsertOption.class};
            MethodSpec.Builder saveMethod = builder.addCode("return this.save(entity, $T.NULL_IS_NONE);", $i$f$forEach232);
            Object[] objectArray3 = new Modifier[]{Modifier.PUBLIC};
            MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"saveOrUpdate").addAnnotation(Nullable.class).addModifiers(objectArray3).returns((TypeName)this.entityTypeName).addParameter((TypeName)this.entityTypeName, "entity", new Modifier[0]);
            objectArray3 = new Object[]{InsertOption.class, InsertOption.class};
            MethodSpec.Builder saveOrUpdateMethod = builder2.addCode("return this.save(entity, $T.NULL_IS_NONE | $T.INSERT_OR_UPDATE);", objectArray3);
            objectArray3 = new MethodSpec[]{saveWithOptionsMethod.build(), saveMethod.build(), saveOrUpdateMethod.build()};
            list = CollectionsKt.listOf((Object[])objectArray3);
        } else {
            list = CollectionsKt.emptyList();
        }
        List saveMethods2 = list;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)findMethods2, (Iterable)deleteMethods2), (Iterable)saveMethods2);
    }
}

