/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.util;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.RequestHandler;
import me.desair.tus.server.RequestValidator;
import me.desair.tus.server.TusExtension;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;

public abstract class AbstractTusExtension
implements TusExtension {
    private List<RequestValidator> requestValidators = new LinkedList<RequestValidator>();
    private List<RequestHandler> requestHandlers = new LinkedList<RequestHandler>();

    public AbstractTusExtension() {
        this.initValidators(this.requestValidators);
        this.initRequestHandlers(this.requestHandlers);
    }

    protected abstract void initValidators(List<RequestValidator> var1);

    protected abstract void initRequestHandlers(List<RequestHandler> var1);

    @Override
    public void validate(HttpMethod method, HttpServletRequest servletRequest, UploadStorageService uploadStorageService, String ownerKey) throws TusException, IOException {
        for (RequestValidator requestValidator : this.requestValidators) {
            if (!requestValidator.supports(method)) continue;
            requestValidator.validate(method, servletRequest, uploadStorageService, ownerKey);
        }
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        for (RequestHandler requestHandler : this.requestHandlers) {
            if (!requestHandler.supports(method)) continue;
            requestHandler.process(method, servletRequest, servletResponse, uploadStorageService, ownerKey);
        }
    }

    @Override
    public void handleError(HttpMethod method, TusServletRequest request, TusServletResponse response, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        for (RequestHandler requestHandler : this.requestHandlers) {
            if (!requestHandler.supports(method) || !requestHandler.isErrorHandler()) continue;
            requestHandler.process(method, request, response, uploadStorageService, ownerKey);
        }
    }
}

