/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.checksum;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ChecksumAlgorithm {
    MD5("MD5", "md5"),
    SHA1("SHA-1", "sha1"),
    SHA256("SHA-256", "sha256"),
    SHA384("SHA-384", "sha384"),
    SHA512("SHA-512", "sha512");

    public static final String CHECKSUM_VALUE_SEPARATOR = " ";
    private static final Logger log;
    private String javaName;
    private String tusName;

    private ChecksumAlgorithm(String javaName, String tusName) {
        this.javaName = javaName;
        this.tusName = tusName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getTusName() {
        return this.tusName;
    }

    public String toString() {
        return this.getTusName();
    }

    public MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.getJavaName());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("We are trying the use an algorithm that is not supported by this JVM", (Throwable)e);
            return null;
        }
    }

    public static ChecksumAlgorithm forTusName(String name) {
        for (ChecksumAlgorithm alg : ChecksumAlgorithm.values()) {
            if (!alg.getTusName().equals(name)) continue;
            return alg;
        }
        return null;
    }

    public static ChecksumAlgorithm forUploadChecksumHeader(String uploadChecksumHeader) {
        String algorithm = StringUtils.substringBefore((String)uploadChecksumHeader, (String)CHECKSUM_VALUE_SEPARATOR);
        return ChecksumAlgorithm.forTusName(algorithm);
    }

    static {
        log = LoggerFactory.getLogger(ChecksumAlgorithm.class);
    }
}

