/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.concatenation;

import java.io.IOException;
import java.util.Objects;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.upload.UploadType;
import me.desair.tus.server.util.AbstractRequestHandler;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;

public class ConcatenationHeadRequestHandler
extends AbstractRequestHandler {
    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.HEAD.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(servletRequest.getRequestURI(), ownerKey);
        if (!UploadType.REGULAR.equals((Object)uploadInfo.getUploadType())) {
            servletResponse.setHeader("Upload-Concat", uploadInfo.getUploadConcatHeaderValue());
        }
        if (UploadType.CONCATENATED.equals((Object)uploadInfo.getUploadType())) {
            if (uploadInfo.isUploadInProgress()) {
                uploadStorageService.getUploadConcatenationService().merge(uploadInfo);
            }
            if (uploadInfo.hasLength()) {
                servletResponse.setHeader("Upload-Length", Objects.toString(uploadInfo.getLength()));
            }
            if (!uploadInfo.isUploadInProgress()) {
                servletResponse.setHeader("Upload-Offset", Objects.toString(uploadInfo.getOffset()));
            }
        }
    }
}

