/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.core.validation;

import jakarta.servlet.http.HttpServletRequest;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.RequestValidator;
import me.desair.tus.server.exception.InvalidTusResumableException;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.Utils;
import org.apache.commons.lang3.StringUtils;

public class TusResumableValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws TusException {
        String requestVersion = Utils.getHeader(request, "Tus-Resumable");
        if (!StringUtils.equals((CharSequence)requestVersion, (CharSequence)"1.0.0")) {
            throw new InvalidTusResumableException("This server does not support tus protocol version " + requestVersion);
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return !HttpMethod.OPTIONS.equals((Object)method) && !HttpMethod.GET.equals((Object)method);
    }
}

