/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload.concatenation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import me.desair.tus.server.exception.UploadNotFoundException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadInputStreamEnumeration
implements Enumeration<InputStream> {
    private static final Logger log = LoggerFactory.getLogger(UploadInputStreamEnumeration.class);
    private List<UploadInfo> uploads;
    private UploadStorageService uploadStorageService;
    private Iterator<UploadInfo> uploadIterator;
    private InputStream currentInputStream = null;

    public UploadInputStreamEnumeration(List<UploadInfo> uploadList, UploadStorageService uploadStorageService) {
        this.uploads = new ArrayList<UploadInfo>(uploadList);
        this.uploadStorageService = uploadStorageService;
        this.uploadIterator = this.uploads.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        this.currentInputStream = this.uploadIterator != null && this.uploadIterator.hasNext() ? this.getNextInputStream() : null;
        if (this.currentInputStream == null) {
            this.uploadIterator = null;
            return false;
        }
        return true;
    }

    @Override
    public InputStream nextElement() {
        return this.currentInputStream;
    }

    private InputStream getNextInputStream() {
        InputStream is = null;
        UploadInfo info = this.uploadIterator.next();
        if (info != null) {
            try {
                is = this.uploadStorageService.getUploadedBytes(info.getId());
            }
            catch (IOException | UploadNotFoundException ex) {
                log.error("Error while retrieving input stream for upload with ID " + info.getId(), (Throwable)ex);
                is = null;
            }
        }
        return is;
    }
}

