/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload.concatenation;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desair.tus.server.exception.UploadNotFoundException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.upload.concatenation.UploadConcatenationService;
import me.desair.tus.server.upload.concatenation.UploadInputStreamEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualConcatenationService
implements UploadConcatenationService {
    private static final Logger log = LoggerFactory.getLogger(VirtualConcatenationService.class);
    private UploadStorageService uploadStorageService;

    public VirtualConcatenationService(UploadStorageService uploadStorageService) {
        this.uploadStorageService = uploadStorageService;
    }

    @Override
    public void merge(UploadInfo uploadInfo) throws IOException, UploadNotFoundException {
        if (uploadInfo != null && uploadInfo.isUploadInProgress() && uploadInfo.getConcatenationPartIds() != null) {
            Long expirationPeriod = this.uploadStorageService.getUploadExpirationPeriod();
            List<UploadInfo> partialUploads = this.getPartialUploads(uploadInfo);
            Long totalLength = this.calculateTotalLength(partialUploads);
            boolean completed = this.checkAllCompleted(expirationPeriod, partialUploads);
            if (totalLength != null && totalLength > 0L) {
                uploadInfo.setLength(totalLength);
                if (completed) {
                    uploadInfo.setOffset(totalLength);
                }
                if (expirationPeriod != null) {
                    uploadInfo.updateExpiration(expirationPeriod);
                }
                this.updateUpload(uploadInfo);
            }
        }
    }

    @Override
    public InputStream getConcatenatedBytes(UploadInfo uploadInfo) throws IOException, UploadNotFoundException {
        this.merge(uploadInfo);
        if (uploadInfo == null || uploadInfo.isUploadInProgress()) {
            return null;
        }
        List<UploadInfo> uploads = this.getPartialUploads(uploadInfo);
        return new SequenceInputStream(new UploadInputStreamEnumeration(uploads, this.uploadStorageService));
    }

    @Override
    public List<UploadInfo> getPartialUploads(UploadInfo info) throws IOException, UploadNotFoundException {
        List<String> concatenationParts = info.getConcatenationPartIds();
        if (concatenationParts == null || concatenationParts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UploadInfo> output = new ArrayList<UploadInfo>(concatenationParts.size());
        for (String childUri : concatenationParts) {
            UploadInfo childInfo = this.uploadStorageService.getUploadInfo(childUri, info.getOwnerKey());
            if (childInfo == null) {
                throw new UploadNotFoundException("Upload with URI " + childUri + " was not found for owner " + info.getOwnerKey());
            }
            output.add(childInfo);
        }
        return output;
    }

    private Long calculateTotalLength(List<UploadInfo> partialUploads) {
        Long totalLength = 0L;
        for (UploadInfo childInfo : partialUploads) {
            if (childInfo.getLength() == null) {
                totalLength = null;
                continue;
            }
            if (totalLength == null) continue;
            totalLength = totalLength + childInfo.getLength();
        }
        return totalLength;
    }

    private boolean checkAllCompleted(Long expirationPeriod, List<UploadInfo> partialUploads) throws IOException {
        boolean completed = true;
        for (UploadInfo childInfo : partialUploads) {
            if (childInfo.isUploadInProgress()) {
                completed = false;
                continue;
            }
            if (expirationPeriod == null) continue;
            childInfo.updateExpiration(expirationPeriod);
            this.updateUpload(childInfo);
        }
        return completed;
    }

    private void updateUpload(UploadInfo uploadInfo) throws IOException {
        try {
            this.uploadStorageService.update(uploadInfo);
        }
        catch (UploadNotFoundException e) {
            log.warn("Unexpected exception occurred while saving upload info with ID " + uploadInfo.getId(), (Throwable)e);
        }
    }
}

