/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload.disk;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import me.desair.tus.server.TusFileUploadService;
import me.desair.tus.server.upload.UploadId;
import me.desair.tus.server.upload.disk.StoragePathNotAvailableException;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDiskBasedService {
    private static final Logger log = LoggerFactory.getLogger(TusFileUploadService.class);
    private Path storagePath;

    public AbstractDiskBasedService(String path) {
        Validate.notBlank((CharSequence)path, (String)"The storage path cannot be blank", (Object[])new Object[0]);
        this.storagePath = Paths.get(path, new String[0]);
    }

    protected Path getStoragePath() {
        return this.storagePath;
    }

    protected Path getPathInStorageDirectory(UploadId id) {
        if (!Files.exists(this.storagePath, new LinkOption[0])) {
            this.init();
        }
        if (id == null) {
            return null;
        }
        return this.storagePath.resolve(id.toString());
    }

    private synchronized void init() {
        if (!Files.exists(this.storagePath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.storagePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                String message = "Unable to create the directory specified by the storage path " + this.storagePath;
                log.error(message, (Throwable)e);
                throw new StoragePathNotAvailableException(message, e);
            }
        }
    }
}

