/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import me.desair.tus.server.TusExtension;
import me.desair.tus.server.checksum.ChecksumAlgorithm;
import me.desair.tus.server.util.HttpChunkedEncodingInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;

public class TusServletRequest
extends HttpServletRequestWrapper {
    private CountingInputStream countingInputStream;
    private Map<ChecksumAlgorithm, DigestInputStream> digestInputStreamMap = new EnumMap<ChecksumAlgorithm, DigestInputStream>(ChecksumAlgorithm.class);
    private InputStream contentInputStream = null;
    private boolean isChunkedTransferDecodingEnabled = true;
    private Map<String, List<String>> trailerHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Set<String> processedBySet = new TreeSet<String>();

    public TusServletRequest(HttpServletRequest request, boolean isChunkedTransferDecodingEnabled) {
        super(request);
        this.isChunkedTransferDecodingEnabled = isChunkedTransferDecodingEnabled;
    }

    public TusServletRequest(HttpServletRequest request) {
        this(request, false);
    }

    public InputStream getContentInputStream() throws IOException {
        if (this.contentInputStream == null) {
            this.contentInputStream = super.getInputStream();
            boolean isChunked = this.hasChunkedTransferEncoding();
            if (isChunked && this.isChunkedTransferDecodingEnabled) {
                this.contentInputStream = new HttpChunkedEncodingInputStream(this.contentInputStream, this.trailerHeaders);
            }
            this.countingInputStream = new CountingInputStream(this.contentInputStream);
            this.contentInputStream = this.countingInputStream;
            ChecksumAlgorithm checksumAlgorithm = ChecksumAlgorithm.forUploadChecksumHeader(this.getHeader("Upload-Checksum"));
            List<ChecksumAlgorithm> algorithms = isChunked ? Arrays.asList(ChecksumAlgorithm.values()) : (checksumAlgorithm != null ? Collections.singletonList(checksumAlgorithm) : Collections.emptyList());
            for (ChecksumAlgorithm algorithm : algorithms) {
                DigestInputStream is = new DigestInputStream(this.contentInputStream, algorithm.getMessageDigest());
                this.digestInputStreamMap.put(algorithm, is);
                this.contentInputStream = is;
            }
        }
        return this.contentInputStream;
    }

    public long getBytesRead() {
        return this.countingInputStream == null ? 0L : this.countingInputStream.getByteCount();
    }

    public boolean hasCalculatedChecksum() {
        return !this.digestInputStreamMap.isEmpty();
    }

    public String getCalculatedChecksum(ChecksumAlgorithm algorithm) {
        MessageDigest messageDigest = this.getMessageDigest(algorithm);
        return messageDigest == null ? null : Base64.encodeBase64String((byte[])messageDigest.digest());
    }

    public Set<ChecksumAlgorithm> getEnabledChecksums() {
        return this.digestInputStreamMap.keySet();
    }

    public String getHeader(String name) {
        List<String> values;
        String value = super.getHeader(name);
        if (StringUtils.isBlank((CharSequence)value) && this.trailerHeaders.containsKey(name) && (values = this.trailerHeaders.get(name)) != null && !values.isEmpty()) {
            value = values.get(0);
        }
        return value;
    }

    public boolean isProcessedBy(TusExtension processor) {
        return this.processedBySet.contains(processor.getName());
    }

    public void addProcessor(TusExtension processor) {
        this.processedBySet.add(processor.getName());
    }

    private boolean hasChunkedTransferEncoding() {
        return StringUtils.equalsIgnoreCase((CharSequence)"chunked", (CharSequence)this.getHeader("Transfer-Encoding"));
    }

    private MessageDigest getMessageDigest(ChecksumAlgorithm algorithm) {
        if (this.digestInputStreamMap.containsKey((Object)algorithm)) {
            return this.digestInputStreamMap.get((Object)algorithm).getMessageDigest();
        }
        return null;
    }
}

