/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.util;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TusServletResponse
extends HttpServletResponseWrapper {
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public TusServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void setDateHeader(String name, long date) {
        super.setDateHeader(name, date);
        this.overwriteHeader(name, Objects.toString(date));
    }

    public void addDateHeader(String name, long date) {
        super.addDateHeader(name, date);
        this.recordHeader(name, Objects.toString(date));
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.overwriteHeader(name, value);
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        this.recordHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.overwriteHeader(name, Objects.toString(value));
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        this.recordHeader(name, Objects.toString(value));
    }

    public String getHeader(String name) {
        String value = this.headers.containsKey(name) ? this.headers.get(name).get(0) : super.getHeader(name);
        return StringUtils.trimToNull((String)value);
    }

    private void recordHeader(String name, String value) {
        List values = this.headers.computeIfAbsent(name, k -> new LinkedList());
        values.add(value);
    }

    private void overwriteHeader(String name, String value) {
        LinkedList<String> values = new LinkedList<String>();
        values.add(value);
        this.headers.put(name, values);
    }
}

