/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import java.time.Clock;
import java.time.Instant;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;
import me.dinowernli.grpc.prometheus.ServerMetrics;

class MonitoringServerCall<R, S>
extends ForwardingServerCall.SimpleForwardingServerCall<R, S> {
    private static final long MILLIS_PER_SECOND = 1000L;
    private final Clock clock;
    private final GrpcMethod grpcMethod;
    private final ServerMetrics serverMetrics;
    private final Configuration configuration;
    private final Instant startInstant;

    MonitoringServerCall(ServerCall<R, S> serverCall, Clock clock, GrpcMethod grpcMethod, ServerMetrics serverMetrics, Configuration configuration) {
        super(serverCall);
        this.clock = clock;
        this.grpcMethod = grpcMethod;
        this.serverMetrics = serverMetrics;
        this.configuration = configuration;
        this.startInstant = clock.instant();
        this.reportStartMetrics();
    }

    public void close(Status status, Metadata metadata) {
        this.reportEndMetrics(status);
        super.close(status, metadata);
    }

    public void sendMessage(S s) {
        if (this.grpcMethod.streamsResponses()) {
            this.serverMetrics.recordStreamMessageSent();
        }
        super.sendMessage(s);
    }

    private void reportStartMetrics() {
        this.serverMetrics.recordCallStarted();
    }

    private void reportEndMetrics(Status status) {
        this.serverMetrics.recordServerHandled(status.getCode());
        if (this.configuration.isIncludeLatencyHistograms()) {
            double d = (double)(this.clock.millis() - this.startInstant.toEpochMilli()) / 1000.0;
            this.serverMetrics.recordLatency(d);
        }
    }
}

