/*
 * Decompiled with CFR 0.152.
 */
package me.dm7.barcodescanner.zbar;

import android.content.Context;
import android.hardware.Camera;
import android.text.TextUtils;
import android.util.AttributeSet;
import java.util.Collection;
import java.util.List;
import me.dm7.barcodescanner.core.BarcodeScannerView;
import me.dm7.barcodescanner.core.DisplayUtils;
import me.dm7.barcodescanner.zbar.BarcodeFormat;
import me.dm7.barcodescanner.zbar.Result;
import net.sourceforge.zbar.Image;
import net.sourceforge.zbar.ImageScanner;
import net.sourceforge.zbar.Symbol;
import net.sourceforge.zbar.SymbolSet;

public class ZBarScannerView
extends BarcodeScannerView {
    private ImageScanner mScanner;
    private List<BarcodeFormat> mFormats;
    private ResultHandler mResultHandler;

    public ZBarScannerView(Context context) {
        super(context);
        this.setupScanner();
    }

    public ZBarScannerView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setupScanner();
    }

    public void setFormats(List<BarcodeFormat> formats) {
        this.mFormats = formats;
        this.setupScanner();
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.mResultHandler = resultHandler;
    }

    public Collection<BarcodeFormat> getFormats() {
        if (this.mFormats == null) {
            return BarcodeFormat.ALL_FORMATS;
        }
        return this.mFormats;
    }

    public void setupScanner() {
        this.mScanner = new ImageScanner();
        this.mScanner.setConfig(0, 256, 3);
        this.mScanner.setConfig(0, 257, 3);
        this.mScanner.setConfig(0, 0, 0);
        for (BarcodeFormat format : this.getFormats()) {
            this.mScanner.setConfig(format.getId(), 0, 1);
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        Camera.Size size = parameters.getPreviewSize();
        int width = size.width;
        int height = size.height;
        if (DisplayUtils.getScreenOrientation((Context)this.getContext()) == 1) {
            byte[] rotatedData = new byte[data.length];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    rotatedData[x * height + height - y - 1] = data[x + y * width];
                }
            }
            int tmp = width;
            width = height;
            height = tmp;
            data = rotatedData;
        }
        Image barcode = new Image(width, height, "Y800");
        barcode.setData(data);
        int result = this.mScanner.scanImage(barcode);
        if (result != 0) {
            this.stopCamera();
            if (this.mResultHandler != null) {
                SymbolSet syms = this.mScanner.getResults();
                Result rawResult = new Result();
                for (Symbol sym : syms) {
                    String symData = sym.getData();
                    if (TextUtils.isEmpty((CharSequence)symData)) continue;
                    rawResult.setContents(symData);
                    rawResult.setBarcodeFormat(BarcodeFormat.getFormatById(sym.getType()));
                    break;
                }
                this.mResultHandler.handleResult(rawResult);
            }
        } else {
            camera.setOneShotPreviewCallback((Camera.PreviewCallback)this);
        }
    }

    static {
        System.loadLibrary("iconv");
    }

    public static interface ResultHandler {
        public void handleResult(Result var1);
    }
}

