/*
 * Decompiled with CFR 0.152.
 */
package me.dm7.barcodescanner.zbar;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import me.dm7.barcodescanner.core.BarcodeScannerView;
import me.dm7.barcodescanner.core.DisplayUtils;
import me.dm7.barcodescanner.zbar.BarcodeFormat;
import me.dm7.barcodescanner.zbar.Result;
import net.sourceforge.zbar.Image;
import net.sourceforge.zbar.ImageScanner;
import net.sourceforge.zbar.Symbol;
import net.sourceforge.zbar.SymbolSet;

public class ZBarScannerView
extends BarcodeScannerView {
    private static final String TAG = "ZBarScannerView";
    private ImageScanner mScanner;
    private List<BarcodeFormat> mFormats;
    private ResultHandler mResultHandler;

    public ZBarScannerView(Context context) {
        super(context);
        this.setupScanner();
    }

    public ZBarScannerView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setupScanner();
    }

    public void setFormats(List<BarcodeFormat> formats) {
        this.mFormats = formats;
        this.setupScanner();
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.mResultHandler = resultHandler;
    }

    public Collection<BarcodeFormat> getFormats() {
        if (this.mFormats == null) {
            return BarcodeFormat.ALL_FORMATS;
        }
        return this.mFormats;
    }

    public void setupScanner() {
        this.mScanner = new ImageScanner();
        this.mScanner.setConfig(0, 256, 3);
        this.mScanner.setConfig(0, 257, 3);
        this.mScanner.setConfig(0, 0, 0);
        for (BarcodeFormat format : this.getFormats()) {
            this.mScanner.setConfig(format.getId(), 0, 1);
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.mResultHandler == null) {
            return;
        }
        try {
            Camera.Parameters parameters = camera.getParameters();
            Camera.Size size = parameters.getPreviewSize();
            int width = size.width;
            int height = size.height;
            if (DisplayUtils.getScreenOrientation((Context)this.getContext()) == 1) {
                int rotationCount = this.getRotationCount();
                if (rotationCount == 1 || rotationCount == 3) {
                    int tmp = width;
                    width = height;
                    height = tmp;
                }
                data = this.getRotatedData(data, camera);
            }
            Rect rect = this.getFramingRectInPreview(width, height);
            Image barcode = new Image(width, height, "Y800");
            barcode.setData(data);
            barcode.setCrop(rect.left, rect.top, rect.width(), rect.height());
            int result = this.mScanner.scanImage(barcode);
            if (result != 0) {
                SymbolSet syms = this.mScanner.getResults();
                final Result rawResult = new Result();
                for (Symbol sym : syms) {
                    String symData = Build.VERSION.SDK_INT >= 19 ? new String(sym.getDataBytes(), StandardCharsets.UTF_8) : sym.getData();
                    if (TextUtils.isEmpty((CharSequence)symData)) continue;
                    rawResult.setContents(symData);
                    rawResult.setBarcodeFormat(BarcodeFormat.getFormatById(sym.getType()));
                    break;
                }
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ResultHandler tmpResultHandler = ZBarScannerView.this.mResultHandler;
                        ZBarScannerView.this.mResultHandler = null;
                        ZBarScannerView.this.stopCameraPreview();
                        if (tmpResultHandler != null) {
                            tmpResultHandler.handleResult(rawResult);
                        }
                    }
                });
            } else {
                camera.setOneShotPreviewCallback((Camera.PreviewCallback)this);
            }
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)e.toString(), (Throwable)e);
        }
    }

    public void resumeCameraPreview(ResultHandler resultHandler) {
        this.mResultHandler = resultHandler;
        super.resumeCameraPreview();
    }

    static {
        System.loadLibrary("iconv");
    }

    public static interface ResultHandler {
        public void handleResult(Result var1);
    }
}

