/*
 * Decompiled with CFR 0.152.
 */
package me.drakeet.materialdialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import me.drakeet.materialdialog.R;

public class MaterialDialog {
    private static final int BUTTON_BOTTOM = 9;
    private static final int BUTTON_TOP = 9;
    private boolean mCancel;
    private Context mContext;
    private AlertDialog mAlertDialog;
    private Builder mBuilder;
    private View mView;
    private int mTitleResId;
    private CharSequence mTitle;
    private int mMessageResId;
    private CharSequence mMessage;
    private Button mPositiveButton;
    private LinearLayout.LayoutParams mLayoutParams;
    private Button mNegativeButton;
    private boolean mHasShow = false;
    private int mBackgroundResId = -1;
    private Drawable mBackgroundDrawable;
    private View mMessageContentView;
    private int mMessageContentViewResId;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private int pId = -1;
    private int nId = -1;
    private String pText;
    private String nText;
    View.OnClickListener pListener;
    View.OnClickListener nListener;

    public MaterialDialog(Context context) {
        this.mContext = context;
    }

    public void show() {
        if (!this.mHasShow) {
            this.mBuilder = new Builder();
        } else {
            this.mAlertDialog.show();
        }
        this.mHasShow = true;
    }

    public MaterialDialog setView(View view) {
        this.mView = view;
        if (this.mBuilder != null) {
            this.mBuilder.setView(view);
        }
        return this;
    }

    public MaterialDialog setContentView(View view) {
        this.mMessageContentView = view;
        this.mMessageContentViewResId = 0;
        if (this.mBuilder != null) {
            this.mBuilder.setContentView(this.mMessageContentView);
        }
        return this;
    }

    public MaterialDialog setContentView(int layoutResId) {
        this.mMessageContentViewResId = layoutResId;
        this.mMessageContentView = null;
        if (this.mBuilder != null) {
            this.mBuilder.setContentView(layoutResId);
        }
        return this;
    }

    public MaterialDialog setBackground(Drawable drawable2) {
        this.mBackgroundDrawable = drawable2;
        if (this.mBuilder != null) {
            this.mBuilder.setBackground(this.mBackgroundDrawable);
        }
        return this;
    }

    public MaterialDialog setBackgroundResource(int resId) {
        this.mBackgroundResId = resId;
        if (this.mBuilder != null) {
            this.mBuilder.setBackgroundResource(this.mBackgroundResId);
        }
        return this;
    }

    public void dismiss() {
        this.mAlertDialog.dismiss();
    }

    private int dip2px(float dpValue) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private static boolean isLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public MaterialDialog setTitle(int resId) {
        this.mTitleResId = resId;
        if (this.mBuilder != null) {
            this.mBuilder.setTitle(resId);
        }
        return this;
    }

    public MaterialDialog setTitle(CharSequence title) {
        this.mTitle = title;
        if (this.mBuilder != null) {
            this.mBuilder.setTitle(title);
        }
        return this;
    }

    public MaterialDialog setMessage(int resId) {
        this.mMessageResId = resId;
        if (this.mBuilder != null) {
            this.mBuilder.setMessage(resId);
        }
        return this;
    }

    public MaterialDialog setMessage(CharSequence message) {
        this.mMessage = message;
        if (this.mBuilder != null) {
            this.mBuilder.setMessage(message);
        }
        return this;
    }

    public MaterialDialog setPositiveButton(int resId, View.OnClickListener listener) {
        this.pId = resId;
        this.pListener = listener;
        return this;
    }

    public Button getPositiveButton() {
        return this.mPositiveButton;
    }

    public Button getNegativeButton() {
        return this.mNegativeButton;
    }

    public MaterialDialog setPositiveButton(String text, View.OnClickListener listener) {
        this.pText = text;
        this.pListener = listener;
        return this;
    }

    public MaterialDialog setNegativeButton(int resId, View.OnClickListener listener) {
        this.nId = resId;
        this.nListener = listener;
        return this;
    }

    public MaterialDialog setNegativeButton(String text, View.OnClickListener listener) {
        this.nText = text;
        this.nListener = listener;
        return this;
    }

    public MaterialDialog setCanceledOnTouchOutside(boolean cancel) {
        this.mCancel = cancel;
        if (this.mBuilder != null) {
            this.mBuilder.setCanceledOnTouchOutside(this.mCancel);
        }
        return this;
    }

    public MaterialDialog setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    private boolean isNullOrEmpty(String nText) {
        return nText == null || nText.isEmpty();
    }

    private void setListViewHeightBasedOnChildren(ListView listView) {
        ListAdapter listAdapter = listView.getAdapter();
        if (listAdapter == null) {
            return;
        }
        int totalHeight = 0;
        for (int i = 0; i < listAdapter.getCount(); ++i) {
            View listItem = listAdapter.getView(i, null, (ViewGroup)listView);
            listItem.measure(0, 0);
            totalHeight += listItem.getMeasuredHeight();
        }
        ViewGroup.LayoutParams params = listView.getLayoutParams();
        params.height = totalHeight + listView.getDividerHeight() * (listAdapter.getCount() - 1);
        listView.setLayoutParams(params);
    }

    private class Builder {
        private TextView mTitleView;
        private ViewGroup mMessageContentRoot;
        private TextView mMessageView;
        private Window mAlertDialogWindow;
        private LinearLayout mButtonLayout;

        private Builder() {
            LinearLayout linearLayout;
            MaterialDialog.this.mAlertDialog = new AlertDialog.Builder(MaterialDialog.this.mContext).create();
            MaterialDialog.this.mAlertDialog.show();
            MaterialDialog.this.mAlertDialog.getWindow().clearFlags(131080);
            MaterialDialog.this.mAlertDialog.getWindow().setSoftInputMode(15);
            this.mAlertDialogWindow = MaterialDialog.this.mAlertDialog.getWindow();
            this.mAlertDialogWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            View contentView = LayoutInflater.from((Context)MaterialDialog.this.mContext).inflate(R.layout.layout_material_dialog, null);
            contentView.setFocusable(true);
            contentView.setFocusableInTouchMode(true);
            this.mAlertDialogWindow.setBackgroundDrawableResource(R.drawable.material_dialog_window);
            this.mAlertDialogWindow.setContentView(contentView);
            this.mTitleView = (TextView)this.mAlertDialogWindow.findViewById(R.id.title);
            this.mMessageView = (TextView)this.mAlertDialogWindow.findViewById(R.id.message);
            this.mButtonLayout = (LinearLayout)this.mAlertDialogWindow.findViewById(R.id.buttonLayout);
            MaterialDialog.this.mPositiveButton = (Button)this.mButtonLayout.findViewById(R.id.btn_p);
            MaterialDialog.this.mNegativeButton = (Button)this.mButtonLayout.findViewById(R.id.btn_n);
            this.mMessageContentRoot = (ViewGroup)this.mAlertDialogWindow.findViewById(R.id.message_content_root);
            if (MaterialDialog.this.mView != null) {
                linearLayout = (LinearLayout)this.mAlertDialogWindow.findViewById(R.id.contentView);
                linearLayout.removeAllViews();
                linearLayout.addView(MaterialDialog.this.mView);
            }
            if (MaterialDialog.this.mTitleResId != 0) {
                this.setTitle(MaterialDialog.this.mTitleResId);
            }
            if (MaterialDialog.this.mTitle != null) {
                this.setTitle(MaterialDialog.this.mTitle);
            }
            if (MaterialDialog.this.mTitle == null && MaterialDialog.this.mTitleResId == 0) {
                this.mTitleView.setVisibility(8);
            }
            if (MaterialDialog.this.mMessageResId != 0) {
                this.setMessage(MaterialDialog.this.mMessageResId);
            }
            if (MaterialDialog.this.mMessage != null) {
                this.setMessage(MaterialDialog.this.mMessage);
            }
            if (MaterialDialog.this.pId != -1) {
                MaterialDialog.this.mPositiveButton.setVisibility(0);
                MaterialDialog.this.mPositiveButton.setText(MaterialDialog.this.pId);
                MaterialDialog.this.mPositiveButton.setOnClickListener(MaterialDialog.this.pListener);
                if (MaterialDialog.isLollipop()) {
                    MaterialDialog.this.mPositiveButton.setElevation(0.0f);
                }
            }
            if (MaterialDialog.this.nId != -1) {
                MaterialDialog.this.mNegativeButton.setVisibility(0);
                MaterialDialog.this.mNegativeButton.setText(MaterialDialog.this.nId);
                MaterialDialog.this.mNegativeButton.setOnClickListener(MaterialDialog.this.nListener);
                if (MaterialDialog.isLollipop()) {
                    MaterialDialog.this.mNegativeButton.setElevation(0.0f);
                }
            }
            if (!MaterialDialog.this.isNullOrEmpty(MaterialDialog.this.pText)) {
                MaterialDialog.this.mPositiveButton.setVisibility(0);
                MaterialDialog.this.mPositiveButton.setText((CharSequence)MaterialDialog.this.pText);
                MaterialDialog.this.mPositiveButton.setOnClickListener(MaterialDialog.this.pListener);
                if (MaterialDialog.isLollipop()) {
                    MaterialDialog.this.mPositiveButton.setElevation(0.0f);
                }
            }
            if (!MaterialDialog.this.isNullOrEmpty(MaterialDialog.this.nText)) {
                MaterialDialog.this.mNegativeButton.setVisibility(0);
                MaterialDialog.this.mNegativeButton.setText((CharSequence)MaterialDialog.this.nText);
                MaterialDialog.this.mNegativeButton.setOnClickListener(MaterialDialog.this.nListener);
                if (MaterialDialog.isLollipop()) {
                    MaterialDialog.this.mNegativeButton.setElevation(0.0f);
                }
            }
            if (MaterialDialog.this.isNullOrEmpty(MaterialDialog.this.pText) && MaterialDialog.this.pId == -1) {
                MaterialDialog.this.mPositiveButton.setVisibility(8);
            }
            if (MaterialDialog.this.isNullOrEmpty(MaterialDialog.this.nText) && MaterialDialog.this.nId == -1) {
                MaterialDialog.this.mNegativeButton.setVisibility(8);
            }
            if (MaterialDialog.this.mBackgroundResId != -1) {
                linearLayout = (LinearLayout)this.mAlertDialogWindow.findViewById(R.id.material_background);
                linearLayout.setBackgroundResource(MaterialDialog.this.mBackgroundResId);
            }
            if (MaterialDialog.this.mBackgroundDrawable != null) {
                linearLayout = (LinearLayout)this.mAlertDialogWindow.findViewById(R.id.material_background);
                linearLayout.setBackground(MaterialDialog.this.mBackgroundDrawable);
            }
            if (MaterialDialog.this.mMessageContentView != null) {
                this.setContentView(MaterialDialog.this.mMessageContentView);
            } else if (MaterialDialog.this.mMessageContentViewResId != 0) {
                this.setContentView(MaterialDialog.this.mMessageContentViewResId);
            }
            MaterialDialog.this.mAlertDialog.setCanceledOnTouchOutside(MaterialDialog.this.mCancel);
            MaterialDialog.this.mAlertDialog.setCancelable(MaterialDialog.this.mCancel);
            if (MaterialDialog.this.mOnDismissListener != null) {
                MaterialDialog.this.mAlertDialog.setOnDismissListener(MaterialDialog.this.mOnDismissListener);
            }
        }

        public void setTitle(int resId) {
            this.mTitleView.setText(resId);
        }

        public void setTitle(CharSequence title) {
            this.mTitleView.setText(title);
        }

        public void setMessage(int resId) {
            if (this.mMessageView != null) {
                this.mMessageView.setText(resId);
            }
        }

        public void setMessage(CharSequence message) {
            if (this.mMessageView != null) {
                this.mMessageView.setText(message);
            }
        }

        public void setPositiveButton(String text, View.OnClickListener listener) {
            Button button = new Button(MaterialDialog.this.mContext);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            button.setLayoutParams((ViewGroup.LayoutParams)params);
            button.setBackgroundResource(R.drawable.material_card);
            button.setTextColor(Color.argb((int)255, (int)35, (int)159, (int)242));
            button.setText((CharSequence)text);
            button.setGravity(17);
            button.setTextSize(14.0f);
            button.setPadding(MaterialDialog.this.dip2px(12.0f), 0, MaterialDialog.this.dip2px(32.0f), MaterialDialog.this.dip2px(9.0f));
            button.setOnClickListener(listener);
            this.mButtonLayout.addView((View)button);
        }

        public void setNegativeButton(String text, View.OnClickListener listener) {
            Button button = new Button(MaterialDialog.this.mContext);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            button.setLayoutParams((ViewGroup.LayoutParams)params);
            button.setBackgroundResource(R.drawable.material_card);
            button.setText((CharSequence)text);
            button.setTextColor(Color.argb((int)222, (int)0, (int)0, (int)0));
            button.setTextSize(14.0f);
            button.setGravity(17);
            button.setPadding(0, 0, 0, MaterialDialog.this.dip2px(8.0f));
            button.setOnClickListener(listener);
            if (this.mButtonLayout.getChildCount() > 0) {
                params.setMargins(20, 0, 10, MaterialDialog.this.dip2px(9.0f));
                button.setLayoutParams((ViewGroup.LayoutParams)params);
                this.mButtonLayout.addView((View)button, 1);
            } else {
                button.setLayoutParams((ViewGroup.LayoutParams)params);
                this.mButtonLayout.addView((View)button);
            }
        }

        public void setView(View view) {
            LinearLayout l = (LinearLayout)this.mAlertDialogWindow.findViewById(R.id.contentView);
            l.removeAllViews();
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -2);
            view.setLayoutParams(layoutParams);
            view.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    Builder.this.mAlertDialogWindow.setSoftInputMode(5);
                    InputMethodManager imm = (InputMethodManager)MaterialDialog.this.mContext.getSystemService("input_method");
                    imm.toggleSoftInput(2, 1);
                }
            });
            l.addView(view);
            if (view instanceof ViewGroup) {
                int i;
                ViewGroup viewGroup = (ViewGroup)view;
                for (i = 0; i < viewGroup.getChildCount(); ++i) {
                    if (!(viewGroup.getChildAt(i) instanceof EditText)) continue;
                    EditText editText = (EditText)viewGroup.getChildAt(i);
                    editText.setFocusable(true);
                    editText.requestFocus();
                    editText.setFocusableInTouchMode(true);
                }
                for (i = 0; i < viewGroup.getChildCount(); ++i) {
                    if (!(viewGroup.getChildAt(i) instanceof AutoCompleteTextView)) continue;
                    AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)viewGroup.getChildAt(i);
                    autoCompleteTextView.setFocusable(true);
                    autoCompleteTextView.requestFocus();
                    autoCompleteTextView.setFocusableInTouchMode(true);
                }
            }
        }

        public void setContentView(View contentView) {
            LinearLayout linearLayout;
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
            contentView.setLayoutParams(layoutParams);
            if (contentView instanceof ListView) {
                MaterialDialog.this.setListViewHeightBasedOnChildren((ListView)contentView);
            }
            if ((linearLayout = (LinearLayout)this.mAlertDialogWindow.findViewById(R.id.message_content_view)) != null) {
                linearLayout.removeAllViews();
                linearLayout.addView(contentView);
            }
            for (int i = 0; i < (linearLayout != null ? linearLayout.getChildCount() : 0); ++i) {
                if (!(linearLayout.getChildAt(i) instanceof AutoCompleteTextView)) continue;
                AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)linearLayout.getChildAt(i);
                autoCompleteTextView.setFocusable(true);
                autoCompleteTextView.requestFocus();
                autoCompleteTextView.setFocusableInTouchMode(true);
            }
        }

        public void setContentView(int layoutResId) {
            this.mMessageContentRoot.removeAllViews();
            LayoutInflater.from((Context)this.mMessageContentRoot.getContext()).inflate(layoutResId, this.mMessageContentRoot);
        }

        public void setBackground(Drawable drawable2) {
            LinearLayout linearLayout = (LinearLayout)this.mAlertDialogWindow.findViewById(R.id.material_background);
            linearLayout.setBackground(drawable2);
        }

        public void setBackgroundResource(int resId) {
            LinearLayout linearLayout = (LinearLayout)this.mAlertDialogWindow.findViewById(R.id.material_background);
            linearLayout.setBackgroundResource(resId);
        }

        public void setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
            MaterialDialog.this.mAlertDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
            MaterialDialog.this.mAlertDialog.setCancelable(canceledOnTouchOutside);
        }
    }
}

