package eleme.openapi.sdk.api.entity.alliance;

import eleme.openapi.sdk.api.enumeration.alliance.*;
import eleme.openapi.sdk.api.entity.alliance.*;
import java.util.*;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;

public class ChannelOrderInfoModel{

    /**
     * 饿了么订单类型，DELIVERY：外卖单；SELF_TAKE：自取单
     */
    private String orderType;
    public String getOrderType() {
        return orderType;
    }
    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }
    
    /**
     * 饿了么订单号
     */
    private Long alscOrderNo;
    public Long getAlscOrderNo() {
        return alscOrderNo;
    }
    public void setAlscOrderNo(Long alscOrderNo) {
        this.alscOrderNo = alscOrderNo;
    }
    
    /**
     * 饿了么订单状态
     */
    private String status;
    public String getStatus() {
        return status;
    }
    public void setStatus(String status) {
        this.status = status;
    }
    
    /**
     * 二级商家类目
     */
    private String shopCategory;
    public String getShopCategory() {
        return shopCategory;
    }
    public void setShopCategory(String shopCategory) {
        this.shopCategory = shopCategory;
    }
    
    /**
     * 一级商家类目
     */
    private String parentShopCategory;
    public String getParentShopCategory() {
        return parentShopCategory;
    }
    public void setParentShopCategory(String parentShopCategory) {
        this.parentShopCategory = parentShopCategory;
    }
    
    /**
     * 商家名称
     */
    private String shopName;
    public String getShopName() {
        return shopName;
    }
    public void setShopName(String shopName) {
        this.shopName = shopName;
    }
    
    /**
     * 商家纬度
     */
    private String shopLat;
    public String getShopLat() {
        return shopLat;
    }
    public void setShopLat(String shopLat) {
        this.shopLat = shopLat;
    }
    
    /**
     * 商家经度
     */
    private String shopLng;
    public String getShopLng() {
        return shopLng;
    }
    public void setShopLng(String shopLng) {
        this.shopLng = shopLng;
    }
    
    /**
     * 商家联系电话
     */
    private String shopPhone;
    public String getShopPhone() {
        return shopPhone;
    }
    public void setShopPhone(String shopPhone) {
        this.shopPhone = shopPhone;
    }
    
    /**
     * 应付配送费
     */
    private Long deliveryFee;
    public Long getDeliveryFee() {
        return deliveryFee;
    }
    public void setDeliveryFee(Long deliveryFee) {
        this.deliveryFee = deliveryFee;
    }
    
    /**
     * 应付打包费
     */
    private Long packageFee;
    public Long getPackageFee() {
        return packageFee;
    }
    public void setPackageFee(Long packageFee) {
        this.packageFee = packageFee;
    }
    
    /**
     * 订单金额
     */
    private Long totalAmount;
    public Long getTotalAmount() {
        return totalAmount;
    }
    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }
    
    /**
     * 订单买家应付金额
     */
    private Long realAmount;
    public Long getRealAmount() {
        return realAmount;
    }
    public void setRealAmount(Long realAmount) {
        this.realAmount = realAmount;
    }
    
    /**
     * 优惠总额，包含商户补贴，平台补贴，代理商补贴
     */
    private Long subsidyAmount;
    public Long getSubsidyAmount() {
        return subsidyAmount;
    }
    public void setSubsidyAmount(Long subsidyAmount) {
        this.subsidyAmount = subsidyAmount;
    }
    
    /**
     * 子单商品信息
     */
    private List<SubOrderInfoModel> subOrderInfoList;
    public List<SubOrderInfoModel> getSubOrderInfoList() {
        return subOrderInfoList;
    }
    public void setSubOrderInfoList(List<SubOrderInfoModel> subOrderInfoList) {
        this.subOrderInfoList = subOrderInfoList;
    }
    
    /**
     * 是否是预订单
     */
    private Boolean isBookingOrder;
    public Boolean getIsBookingOrder() {
        return isBookingOrder;
    }
    public void setIsBookingOrder(Boolean isBookingOrder) {
        this.isBookingOrder = isBookingOrder;
    }
    
    /**
     * 订单地址信息
     */
    private OrderAddressModel address;
    public OrderAddressModel getAddress() {
        return address;
    }
    public void setAddress(OrderAddressModel address) {
        this.address = address;
    }
    
    /**
     * 渠道侧的openid
     */
    private String channelOpenId;
    public String getChannelOpenId() {
        return channelOpenId;
    }
    public void setChannelOpenId(String channelOpenId) {
        this.channelOpenId = channelOpenId;
    }
    
    /**
     * 饿了么订单创建时间
     */
    private Long createAt;
    public Long getCreateAt() {
        return createAt;
    }
    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }
    
    /**
     * 饿了么订单预计送达时间
     */
    private Long estimateDeliveryAt;
    public Long getEstimateDeliveryAt() {
        return estimateDeliveryAt;
    }
    public void setEstimateDeliveryAt(Long estimateDeliveryAt) {
        this.estimateDeliveryAt = estimateDeliveryAt;
    }
    
    /**
     * 饿了么的预订单的预计送达开始时间
     */
    private Long estimateDeliveryStartTime;
    public Long getEstimateDeliveryStartTime() {
        return estimateDeliveryStartTime;
    }
    public void setEstimateDeliveryStartTime(Long estimateDeliveryStartTime) {
        this.estimateDeliveryStartTime = estimateDeliveryStartTime;
    }
    
    /**
     * 饿了么的预订单的预计送达结束时间
     */
    private Long estimateDeliveryEndTime;
    public Long getEstimateDeliveryEndTime() {
        return estimateDeliveryEndTime;
    }
    public void setEstimateDeliveryEndTime(Long estimateDeliveryEndTime) {
        this.estimateDeliveryEndTime = estimateDeliveryEndTime;
    }
    
    /**
     * 到店自取：用户到店自取的自取时间
     */
    private Long pickUpTime;
    public Long getPickUpTime() {
        return pickUpTime;
    }
    public void setPickUpTime(Long pickUpTime) {
        this.pickUpTime = pickUpTime;
    }
    
    /**
     * 饿了么订单更新时间
     */
    private Long updatedAt;
    public Long getUpdatedAt() {
        return updatedAt;
    }
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }
    
    /**
     * 饿了么订单完成时间
     */
    private Long finishAt;
    public Long getFinishAt() {
        return finishAt;
    }
    public void setFinishAt(Long finishAt) {
        this.finishAt = finishAt;
    }
    
    /**
     * 配送类型
     */
    private String deliveryType;
    public String getDeliveryType() {
        return deliveryType;
    }
    public void setDeliveryType(String deliveryType) {
        this.deliveryType = deliveryType;
    }
    
    /**
     * 是否是代理商
     */
    private Boolean isDeliveryAgent;
    public Boolean getIsDeliveryAgent() {
        return isDeliveryAgent;
    }
    public void setIsDeliveryAgent(Boolean isDeliveryAgent) {
        this.isDeliveryAgent = isDeliveryAgent;
    }
    
    /**
     * 逆向单信息
     */
    private List<RefundOrderInfoModel> refundOrderInfoList;
    public List<RefundOrderInfoModel> getRefundOrderInfoList() {
        return refundOrderInfoList;
    }
    public void setRefundOrderInfoList(List<RefundOrderInfoModel> refundOrderInfoList) {
        this.refundOrderInfoList = refundOrderInfoList;
    }
    
}