package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.activity.*;
import eleme.openapi.sdk.api.enumeration.activity.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 活动服务
 */
@Service("eleme.activity")
public class ActivityService extends BaseNopService {
    public ActivityService(Config config,Token token) {
        super(config, token, ActivityService.class);
    }

    /**
     * 创建减配送费活动
     *
     * @param request 创建减配送费活动的结构体
     * @return 若成功返回则返回success为true，否则为false并返回失败原因。
     * @throws ServiceException 服务异常
     */
    public ExecuteShippingFeeActivityResponse create(CreateShippingFeeActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.shippingFee.create", params);
    }

    /**
     * 更新减配送费活动
     *
     * @param request 更新减配送费活动的结构体
     * @return 若成功返回则返回success为true，否则为false并返回失败原因。
     * @throws ServiceException 服务异常
     */
    public ExecuteShippingFeeActivityResponse update(UpdateShippingFeeActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.shippingFee.update", params);
    }

    /**
     * 作废减配送费活动
     *
     * @param request 作废减配送费活动的结构体
     * @return 若成功返回则返回success为true，否则为false并返回失败原因。
     * @throws ServiceException 服务异常
     */
    public ExecuteShippingFeeActivityResponse offline(OfflineShippingFeeActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.shippingFee.offline", params);
    }

    /**
     * 查询减配送费活动
     *
     * @param request 查询减配送费活动的结构体
     * @return 若成功返回则返回success为true，否则为false并返回失败原因。
     * @throws ServiceException 服务异常
     */
    public SearchShippingFeeActivityResponse query(QueryShippingFeeActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.shippingFee.query", params);
    }

    /**
     * 通过店铺Id查询该店铺被邀约的美食活动
     *
     * @param shopId 店铺Id
     * @return 店铺的邀约活动信息列表
     * @throws ServiceException 服务异常
     */
    public List<OActivityDetail> queryInvitedFoodActivities(Long shopId) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return call("eleme.activity.food.queryInvitedFoodActivities", params);
    }

    /**
     * 报名美食活动
     *
     * @param activityId 活动Id
     * @param activityApplyInfo 活动报名信息
     * @return 报名结果（true表示操作成功）
     * @throws ServiceException 服务异常
     */
    public Boolean applyFoodActivity(Long activityId, ActivityApplyInfo activityApplyInfo) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityId", activityId);
        params.put("activityApplyInfo", activityApplyInfo);
        return call("eleme.activity.food.applyFoodActivity", params);
    }

    /**
     * 通过店铺Id和活动Id分页查询店铺已报名的美食活动
     *
     * @param activityId 活动Id
     * @param shopId 店铺Id
     * @param pageNo 页码
     * @param pageSize 每页数量
     * @return 该活动中所报名菜品的信息
     * @throws ServiceException 服务异常
     */
    public List<OActivityFoodApplyResult> queryFoodActivities(Long activityId, Long shopId, Long pageNo, Long pageSize) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityId", activityId);
        params.put("shopId", shopId);
        params.put("pageNo", pageNo);
        params.put("pageSize", pageSize);
        return call("eleme.activity.food.queryFoodActivities", params);
    }

    /**
     * 修改美食活动的菜品库存
     *
     * @param activityId 活动Id
     * @param shopId 店铺Id
     * @param itemId 菜品Id
     * @param stock 库存
     * @return 报名结果（true表示操作成功）
     * @throws ServiceException 服务异常
     */
    public Boolean updateFoodActivityItemStock(Long activityId, Long shopId, Long itemId, Long stock) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityId", activityId);
        params.put("shopId", shopId);
        params.put("itemId", itemId);
        params.put("stock", stock);
        return call("eleme.activity.food.updateFoodActivityItemStock", params);
    }

    /**
     * 取消参与了美食活动的菜品
     *
     * @param activityId 活动Id
     * @param shopId 店铺Id
     * @param itemId 菜品Id
     * @return 报名结果（true表示操作成功）
 该接口目前只支持限量抢购活动
     * @throws ServiceException 服务异常
     */
    public Boolean offlineFoodActivityItem(Long activityId, Long shopId, Long itemId) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityId", activityId);
        params.put("shopId", shopId);
        params.put("itemId", itemId);
        return call("eleme.activity.food.offlineFoodActivityItem", params);
    }

    /**
     * 作废店铺与美食活动的关联关系
     *
     * @param activityId 活动Id
     * @param shopId 店铺Id
     * @return 报名结果（true表示操作成功）
 该接口目前只支持限量抢购活动
     * @throws ServiceException 服务异常
     */
    public Boolean unbindFoodActivity(Long activityId, Long shopId) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityId", activityId);
        params.put("shopId", shopId);
        return call("eleme.activity.food.unbindFoodActivity", params);
    }

    /**
     * 定向赠红包
     *
     * @param shopId 店铺Id
     * @param mobile 需要发放红包的用户手机号
     * @param couponTemplate 定向赠红包的模板信息
     * @return 发放结果：成功或失败信息
     * @throws ServiceException 服务异常
     */
    public PresentResult presentCoupon(Long shopId, String mobile, CouponTemplate couponTemplate) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("mobile", mobile);
        params.put("couponTemplate", couponTemplate);
        return call("eleme.activity.coupon.presentCoupon", params);
    }

    /**
     * 托管单店红包服务
     *
     * @param shopIds 餐厅id列表,长度不能超过20
     * @param hostedType 红包服务业务类型,暂只支持超级会员,"SUPER_VIP"
     * @param discounts 扣减额,请设置在[4,15]元,小数点后最多1位
     * @return 红包服务执行结果列表 example:[{"shopId":964715,"result":true,"reason":null},{"shopId":324966853,"result":false,"reason":"通用红包活动单店暂无权限操作"}]
     * @throws ServiceException 服务异常
     */
    public List<ServiceResult> hostShops(List<Long> shopIds, HostedType hostedType, Double discounts) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        params.put("hostedType", hostedType);
        params.put("discounts", discounts);
        return call("eleme.activity.coupon.hostShops", params);
    }

    /**
     * 查询红包服务托管情况
     *
     * @param shopIds 餐厅id列表,长度不能超过20
     * @param hostedType 红包服务业务类型,暂只支持超级会员,"SUPER_VIP"
     * @return 红包服务部分信息映射表 key:shopId ,value:OActivityService
 example:{"964715":{"result":true,"discounts":4.0,"dailyStock":100000,"openStatus":true,"reason":null},"720315": {"result":false,"discounts":null,"dailyStock":null,"openStatus":null,"reason": "通用红包活动单店暂无权限操作"}}
     * @throws ServiceException 服务异常
     */
    public Map<Long,OActivityService> queryHostInfo(List<Long> shopIds, HostedType hostedType) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        params.put("hostedType", hostedType);
        return call("eleme.activity.coupon.queryHostInfo", params);
    }

    /**
     * 取消托管单店红包服务
     *
     * @param shopIds 餐厅id列表,长度不能超过20
     * @param hostedType 红包服务业务类型,暂只支持超级会员,"SUPER_VIP"
     * @return 红包服务执行结果列表 example:[{"shopId":964715,"result":true},{"shopId":324966853,"result":false,"reason":"通用红包活动单店暂无权限操作"}]
     * @throws ServiceException 服务异常
     */
    public List<ServiceResult> unhostShops(List<Long> shopIds, HostedType hostedType) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        params.put("hostedType", hostedType);
        return call("eleme.activity.coupon.unhostShops", params);
    }

    /**
     * 更改单店红包服务托管方式
     *
     * @param shopId 店铺Id
     * @param hostedType 红包服务业务类型,暂只支持超级会员,"SUPER_VIP"
     * @param oActivityServiceDetails 服务内容
     * @return 红包服务执行结果,example:{"shopId":964715",result":true,"reason":null}
     * @throws ServiceException 服务异常
     */
    public ServiceResult rehostShop(Long shopId, HostedType hostedType, OActivityServiceDetails oActivityServiceDetails) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("hostedType", hostedType);
        params.put("oActivityServiceDetails", oActivityServiceDetails);
        return call("eleme.activity.coupon.rehostShop", params);
    }

    /**
     * 定向赠红包(单店红包)
     *
     * @param shopId 店铺id
     * @param targetList 目标列表
     * @param targetListType 目标类型
     * @param targetCouponDetail 定向赠红包模板细节
     * @return 定向赠红包创建结果列表 example:[{"userId":null,"telephoneNumber":"18800009993","result":true,"couponId":"10065539304","reason":null}]
     * @throws ServiceException 服务异常
     */
    public List<TargetCouponResult> presentTargetCoupons(Long shopId, List<String> targetList, TargetListType targetListType, TargetCouponDetail targetCouponDetail) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("targetList", targetList);
        params.put("targetListType", targetListType);
        params.put("targetCouponDetail", targetCouponDetail);
        return call("eleme.activity.coupon.presentTargetCoupons", params);
    }

    /**
     * 定向赠通用红包
     *
     * @param chainId 连锁店id
     * @param targetList 目标列表
     * @param targetListType 目标类型
     * @param commonTargetCouponDetail 通用定向赠红包模板细节
     * @return 定向赠红包创建结果列表 example:[{"userId":null,"telephoneNumber":"18800009993","result":true,"couponId":"10065539304","reason":null}]
     * @throws ServiceException 服务异常
     */
    public List<TargetCouponResult> presentCommonTargetCoupons(Long chainId, List<String> targetList, TargetListType targetListType, CommonTargetCouponDetail commonTargetCouponDetail) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("targetList", targetList);
        params.put("targetListType", targetListType);
        params.put("commonTargetCouponDetail", commonTargetCouponDetail);
        return call("eleme.activity.coupon.presentCommonTargetCoupons", params);
    }

    /**
     * 分页查询店铺的定向赠红包信息(接口不在新接入，返回的是userId，不返回openUserId)
     *
     * @param targetCouponQueryRequest 定向赠红包查询入参对象
     * @return 定向赠红包信息列表 example:[{"couponId":"10072706280","status":"UNUSED","userId":"13524618","chainId":94202131,"useTime":null,"orderId":null,"shopId":null},{"couponId":"10072705256","status":"UNUSED","userId":"13524618","chainId":94202131,"useTime":null,"orderId":null,"shopId":null},{"couponId":"10065538990","status":"EXPIRED","userId":"25020977","chainId":94202131,"useTime":null,"orderId":null,"shopId":null}]
     * @throws ServiceException 服务异常
     */
    public List<TargetCouponInfo> queryTargetCouponInfo(TargetCouponQueryRequest targetCouponQueryRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("targetCouponQueryRequest", targetCouponQueryRequest);
        return call("eleme.activity.coupon.queryTargetCouponInfo", params);
    }

    /**
     * 分页查询店铺的定向赠红包信息(新接入需要使用此接口，返回的是加密的openUserId，userId不返回)
     *
     * @param targetCouponQueryRequest 定向赠红包查询入参对象
     * @return 定向赠红包信息列表 example:[{"couponId":"10072706280","status":"UNUSED","userId":"13524618","chainId":94202131,"useTime":null,"orderId":null,"shopId":null},{"couponId":"10072705256","status":"UNUSED","userId":"13524618","chainId":94202131,"useTime":null,"orderId":null,"shopId":null},{"couponId":"10065538990","status":"EXPIRED","userId":"25020977","chainId":94202131,"useTime":null,"orderId":null,"shopId":null}]
     * @throws ServiceException 服务异常
     */
    public List<TargetCouponInfo> queryTargetCouponInfoV2(TargetCouponQueryRequest targetCouponQueryRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("targetCouponQueryRequest", targetCouponQueryRequest);
        return call("eleme.activity.coupon.queryTargetCouponInfoV2", params);
    }

    /**
     * 定向赠通用商品券
     *
     * @param chainId 连锁店id
     * @param targetList 目标列表
     * @param targetListType 目标类型
     * @param commonTargetSkuCouponDetail 通用定向赠连锁商品券模板细节
     * @return 创建结果列表 example:[{"userId":1233445,"telephoneNumber":null,"result":true,"couponId":"10065539304","reason":null}]
     * @throws ServiceException 服务异常
     */
    public List<TargetCouponResult> presentCommonTargetSkuCoupons(Long chainId, List<String> targetList, TargetListType targetListType, CommonTargetSkuCouponDetail commonTargetSkuCouponDetail) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("targetList", targetList);
        params.put("targetListType", targetListType);
        params.put("commonTargetSkuCouponDetail", commonTargetSkuCouponDetail);
        return call("eleme.activity.coupon.presentCommonTargetSkuCoupons", params);
    }

    /**
     * 定向赠连锁通用商品券
     *
     * @param chainId 连锁店id
     * @param targetList 目标列表
     * @param targetListType 目标类型
     * @param chainSkuCouponDetail 通用定向赠连锁商品券模板细节
     * @return 创建结果列表 example:[{"userId":1233445,"telephoneNumber":null,"result":true,"couponId":"10065539304","reason":null}]
     * @throws ServiceException 服务异常
     */
    public List<TargetCouponResult> presentChainSkuCoupons(Long chainId, List<String> targetList, TargetListType targetListType, ChainSkuCouponDetail chainSkuCouponDetail) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("chainId", chainId);
        params.put("targetList", targetList);
        params.put("targetListType", targetListType);
        params.put("chainSkuCouponDetail", chainSkuCouponDetail);
        return call("eleme.activity.coupon.presentChainSkuCoupons", params);
    }

    /**
     * 定向赠指定商品券
     *
     * @param targetList 目标列表
     * @param targetListType 目标类型
     * @param skuCouponDetail 商品券模板细节
     * @return 创建结果列表 example:[{"userId":1233445,"telephoneNumber":null,"result":true,
 "couponId":"10065539304","reason":null}]
     * @throws ServiceException 服务异常
     */
    public List<TargetCouponResult> presentSkuCoupons(List<String> targetList, TargetListType targetListType, SkuCouponDetail skuCouponDetail) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("targetList", targetList);
        params.put("targetListType", targetListType);
        params.put("skuCouponDetail", skuCouponDetail);
        return call("eleme.activity.coupon.presentSkuCoupons", params);
    }

    /**
     * 券状态变更
     *
     * @param criteria 券状态修改对象
     * @param type 操作类型
     * @return 券状态
     * @throws ServiceException 服务异常
     */
    public CouponStatus updateCouponStatus(CouponTransactionCriteria criteria, Integer type) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("criteria", criteria);
        params.put("type", type);
        return call("eleme.activity.coupon.updateCouponStatus", params);
    }

    /**
     * 创建券模板
     *
     * @param activityTemplate 创建券模板对象
     * @return 模板相关的信息,示例: {"templateId": 2101050332031901294,"success": true,"reason": null,"errorCode": null}
     * @throws ServiceException 服务异常
     */
    public CreateTemplateResult createActivityTemplateV2(ActivityTemplate activityTemplate) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityTemplate", activityTemplate);
        return call("eleme.activity.coupon.createActivityTemplateV2", params);
    }

    /**
     * 修改券模板
     *
     * @param updateModel 修改券模板对象
     * @return 修改券模板的结果,示例: {"templateId":2101040325815901082,"success":true,"reason":null,"errorCode":null}
     * @throws ServiceException 服务异常
     */
    public ModifyTemplateResult modifyActivityTemplateV2(ActivityTemplateUpdateModel updateModel) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("updateModel", updateModel);
        return call("eleme.activity.coupon.modifyActivityTemplateV2", params);
    }

    /**
     * 作废券模板
     *
     * @param invalidModel 作废券模板对象
     * @return 作废券模板的结果,示例: {"templateId":2101040325815901082,"success":true,"reason":null,"errorCode":null}
     * @throws ServiceException 服务异常
     */
    public InvalidTemplateResult invalidActivityTemplateV2(ActivityTemplateInvalidModel invalidModel) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("invalidModel", invalidModel);
        return call("eleme.activity.coupon.invalidActivityTemplateV2", params);
    }

    /**
     * 查询券模板
     *
     * @param queryModel 查询券模板对象
     * @return 查询结果,示例: {"activityTemplateDetail":{"templateId":2101040325815901082,"reductionAmt":700,"thresholdAmt":2000,"duration":7,"mutex":true,"gmtStart":1609399691000,"gmtEnd":1612078090000,"status":"ENABLED"},"success":true,"reason":null,"errorCode":null}
     * @throws ServiceException 服务异常
     */
    public QueryTemplateResult queryByTemplateIdV2(ActivityTemplateQueryModel queryModel) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("queryModel", queryModel);
        return call("eleme.activity.coupon.queryByTemplateIdV2", params);
    }

    /**
     * 根据券模板发券
     *
     * @param presentWithTemplateModel 发券对象
     * @return 发券结果,示例:{"presentWithTemplateSingleResults":{"18918568891":{"success":true,"couponId":"129827711670","reason":null,"errorCode":null,"target":"18918568891"}},"couponId":null,"success":true,"reason":null,"errorCode":null}
     * @throws ServiceException 服务异常
     */
    public PresentWithTemplateResult presentCouponWithTemplateIdV2(PresentWithTemplateModel presentWithTemplateModel) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("presentWithTemplateModel", presentWithTemplateModel);
        return call("eleme.activity.coupon.presentCouponWithTemplateIdV2", params);
    }

    /**
     * 批量创建商品活动
     *
     * @param request 批量创建活动请求参数
     * @return 创建成功返回活动id,否则返回失败原因。
     * @throws ServiceException 服务异常
     */
    public BatchCommonSkuActivityResponse batchCreate(BatchCreateSkuActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.play.batchCreate", params);
    }

    /**
     * 批量更新商品活动
     *
     * @param request 批量更新活动参数
     * @return 若成功返回则返回success为true，否则为false并返回失败原因。
     * @throws ServiceException 服务异常
     */
    public BatchCommonSkuActivityResponse batchUpdate(BatchUpdateSkuActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.play.batchUpdate", params);
    }

    /**
     * 批量下线商品活动
     *
     * @param request 批量下线活动
     * @return 若成功返回则返回success为true，否则为false并返回失败原因。
     * @throws ServiceException 服务异常
     */
    public BatchCommonSkuActivityResponse batchOffline(BatchOfflineSkuActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.play.batchOffline", params);
    }

    /**
     * 批量查询商品活动列表
     *
     * @param request 批量查询活动列表
     * @return 批量活动列表
     * @throws ServiceException 服务异常
     */
    public BatchSearchSkuActivityResponse batchSearch(BatchSearchSkuActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.play.batchSearch", params);
    }

    /**
     * 查询订单内营销相关数据
     *
     * @param orderId 饿了么订单Id
     * @return 营销相关数据
     * @throws ServiceException 服务异常
     */
    public OrderSubsidyResult queryOrderSubsidy(String orderId) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return call("eleme.activity.marketing.queryOrderSubsidy", params);
    }

    /**
     * 抖音创建招商活动后调用，创建e侧抖音频道
     *
     * @param request 创建e侧抖音频道
     * @return E招商频道id
     * @throws ServiceException 服务异常
     */
    public CreateCampaignChannelResponse createCampaignDyChannel(CreateCampaignChannelRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.dy.createCampaignDyChannel", params);
    }

    /**
     * 抖音审核状态回调
     *
     * @param request 抖音审核状态回调
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public ResultResponse auditStatusCallBack(AuditStatusCallBackRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.dy.auditStatusCallBack", params);
    }

    /**
     * 抖音查询e侧报名单状态，用于核对状态一致性
     *
     * @param request 查询e侧报名单状态
     * @return e侧报名单状态
     * @throws ServiceException 服务异常
     */
    public QueryApplyStatusResponse queryEleApplyStatus(QueryEleApplyStatusRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.dy.queryEleApplyStatus", params);
    }

    /**
     * 抖音侧商品退出报名时调用，e侧商品退出报名
     *
     * @param request 商品退出报名
     * @return 返回值
     * @throws ServiceException 服务异常
     */
    public ResultResponse offlineSkuApply(OfflineSkuApplyRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.dy.offlineSkuApply", params);
    }

    /**
     * 抖音侧创建券活动时调用
     *
     * @param request 抖音创建券活动
     * @return e行业玩法实例id
     * @throws ServiceException 服务异常
     */
    public CreateCouponActivityResponse createCouponActivity(CreateCouponActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.dy.createCouponActivity", params);
    }

    /**
     * 抖音侧修改券活动时调用
     *
     * @param request 抖音创建券活动
     * @return e行业玩法实例id
     * @throws ServiceException 服务异常
     */
    public ModifyCouponActivityResponse modifyCouponActivity(ModifyCouponActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.dy.modifyCouponActivity", params);
    }

    /**
     * 根据dy券活动id查询券活动信息
     *
     * @param request 抖音查询券活动信息
     * @return 券活动信息
     * @throws ServiceException 服务异常
     */
    public QueryDyCouponActivityResponse queryDyCouponActivity(QueryDyCouponActivityRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.activity.dy.queryDyCouponActivity", params);
    }

    /**
     * 创建并绑定连锁店特价活动
     *
     * @param activity 活动创建信息
     * @param chainId 连锁店Id
     * @param shopApplyInfo  绑定的商品信息
     * @return 活动参与详情|{"activityId": 47240183, "relations": [{"shopId": 150005159, "specId": 1014651, "participateId": 10168284}, {"shopId": 150005160, "specId": 1014652, "participateId": 10168285}]}
     * @throws ServiceException 服务异常
     */
    public SkuActivityFoodDetail createAndParticipateChainPriceActivity(SkuPriceActivityDTO activity, Long chainId, List<SkuActivityShopApplyInfoDTO> shopApplyInfo) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activity", activity);
        params.put("chainId", chainId);
        params.put("shopApplyInfo", shopApplyInfo);
        return call("eleme.activity.skuchain.createAndParticipateChainPriceActivity", params);
    }

    /**
     * 根据活动Id和店铺Id和商品规格Id，作废参与关系
     *
     * @param activityId 活动Id
     * @param shopId 店铺Id
     * @param specId 商品规格Id
     * @param comment 作废原因
     * @throws ServiceException 服务异常
     */
    public void inValidSkuActivityById(Long activityId, Long shopId, Long specId, String comment) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("activityId", activityId);
        params.put("shopId", shopId);
        params.put("specId", specId);
        params.put("comment", comment);
        call("eleme.activity.skuchain.inValidSkuActivityById", params);
    }
}
