package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.brandOpenShop.*;
import eleme.openapi.sdk.api.enumeration.brandOpenShop.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 品牌建店服务
 */
@Service("eleme.brandOpenShop")
public class BrandOpenShopService extends BaseNopService {
    public BrandOpenShopService(Config config,Token token) {
        super(config, token, BrandOpenShopService.class);
    }

    /**
     * 查询当前账号归属的连锁树结构
     *
     * @return 连锁节点列表
     * @throws ServiceException 服务异常
     */
    public ChainNodeTreeFetchResponse getChainNodeTree() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.brandOpenShop.getChainNodeTree", params);
    }

    /**
     * 查询所有餐饮品类信息
     *
     * @return 餐饮品类列表
     * @throws ServiceException 服务异常
     */
    public AllCateringCategoryFetchResponse getAllCateringCategory() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.brandOpenShop.getAllCateringCategory", params);
    }

    /**
     * 上传图片
     *
     * @param request 图片上传请求
     * @return 图片上传结果
     * @throws ServiceException 服务异常
     */
    public FileUploadResponse uploadImage(UploadFileRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.brandOpenShop.uploadImage", params);
    }

    /**
     * 创建批量开店任务
     *
     * @param request 批量开店任务创建/更新请求
     * @return 批量开店任务操作结果
     * @throws ServiceException 服务异常
     */
    public ShopBatchTaskCreateResponse createShopBatchTask(ShopBatchTaskCreateOrUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.brandOpenShop.createShopBatchTask", params);
    }

    /**
     * 创建/更新开店申请单
     *
     * @param request 开店申请单创建/更新请求
     * @return 开店申请单创建/更新结果
     * @throws ServiceException 服务异常
     */
    public ShopApplyCreateResponse createShopApply(CreateBasicShopInfoRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.brandOpenShop.createShopApply", params);
    }

    /**
     * 开店任务提交审核
     *
     * @param request 提交审核请求
     * @return 提交审核结果
     * @throws ServiceException 服务异常
     */
    public AuditBatchSubmitResponse batchSubmitAudit(BatchTaskAuditSubmitRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.brandOpenShop.batchSubmitAudit", params);
    }

    /**
     * 开店申请单提交审核
     *
     * @param request 提交审核请求
     * @return 提交审核结果
     * @throws ServiceException 服务异常
     */
    public AuditSubmitResponse submitAudit(UpdateBasicShopInfoRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.brandOpenShop.submitAudit", params);
    }

    /**
     * 查询开店任务详情
     *
     * @param request 查询条件
     * @return 开店任务详情
     * @throws ServiceException 服务异常
     */
    public ShopBatchTaskQueryResponse queryShopBatchTask(ShopBatchTaskQueryRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.brandOpenShop.queryShopBatchTask", params);
    }

    /**
     * 查询开店申请单详情
     *
     * @param request 查询条件
     * @return 开店申请单详情
     * @throws ServiceException 服务异常
     */
    public ShopApplyDetailQueryResponse queryApplyDetail(ApplyDetailQueryRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.brandOpenShop.queryApplyDetail", params);
    }

    /**
     * 获取所有支持的餐饮证照配置
     *
     * @return 餐饮证照配置信息
     * @throws ServiceException 服务异常
     */
    public AllCateringLicenseConfigObtainResponse obtainAllCateringLicenseConfig() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.brandOpenShop.obtainAllCateringLicenseConfig", params);
    }

    /**
     * 获取当前账号支持的品牌信息
     *
     * @return 品牌信息列表
     * @throws ServiceException 服务异常
     */
    public SupportBrandFetchResponse supportBrandList() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.brandOpenShop.supportBrandList", params);
    }
}
