package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.invoice.*;
import eleme.openapi.sdk.api.enumeration.invoice.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 开票服务
 */
@Service("eleme.invoice")
public class InvoiceService extends BaseNopService {
    public InvoiceService(Config config,Token token) {
        super(config, token, InvoiceService.class);
    }

    /**
     * 受理成功
     *
     * @param request 开具单受理成功通知入参
     * @throws ServiceException 服务异常
     */
    public void acceptSuccess(InvoiceAcceptSuccessRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        call("eleme.invoice.issue.acceptSuccess", params);
    }

    /**
     * 受理失败
     *
     * @param request 开具单受理失败通知入参
     * @throws ServiceException 服务异常
     */
    public void acceptFailure(InvoiceAcceptFailureRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        call("eleme.invoice.issue.acceptFailure", params);
    }

    /**
     * 开具成功
     *
     * @param request 开具单开具成功通知入参
     * @throws ServiceException 服务异常
     */
    public void issueSuccess(InvoiceIssueSuccessRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        call("eleme.invoice.issue.issueSuccess", params);
    }

    /**
     * 开具失败
     *
     * @param request 开具单开具失败通知入参
     * @throws ServiceException 服务异常
     */
    public void issueFailure(InvoiceIssueFailureRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        call("eleme.invoice.issue.issueFailure", params);
    }

    /**
     * 退票成功
     *
     * @param request 开具单退票成功通知入参
     * @throws ServiceException 服务异常
     */
    public void redSuccess(InvoiceRedSuccessRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        call("eleme.invoice.issue.redSuccess", params);
    }

    /**
     * 闪电开票服务注册成功
     *
     * @param request 注册成功通知入参
     * @throws ServiceException 服务异常
     */
    public void registerSuccess(FlashInvoiceServiceRegisterSuccessRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        call("eleme.invoice.flash.registerSuccess", params);
    }

    /**
     * 闪电开票服务注册失败
     *
     * @param request 注册失败通知入参
     * @throws ServiceException 服务异常
     */
    public void registerFailure(FlashInvoiceServiceRegisterFailureRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        call("eleme.invoice.flash.registerFailure", params);
    }

    /**
     * 闪电开票服务有效期更新
     *
     * @param request 续签通知入参
     * @throws ServiceException 服务异常
     */
    public void renewSuccess(FlashInvoiceServiceRegisterSuccessRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        call("eleme.invoice.flash.renewSuccess", params);
    }

    /**
     * 闪电开票服务退订
     *
     * @param request 退订通知入参
     * @throws ServiceException 服务异常
     */
    public void terminateSuccess(FlashInvoiceServiceTerminateSuccessRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        call("eleme.invoice.flash.terminateSuccess", params);
    }

    /**
     * 批量查询店铺开票设置
     *
     * @param request 查询请求
     * @return 开票设置
     * @throws ServiceException 服务异常
     */
    public ShopSettingsBatchQueryResponse batchQueryShopSettings(ShopSettingsBatchQueryRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.invoice.seller.batchQueryShopSettings", params);
    }

    /**
     * 批量更新店铺开票设置
     *
     * @param request 更新请求
     * @return 更新结果
     * @throws ServiceException 服务异常
     */
    public ShopSettingsBatchUpdateResponse batchUpdateShopSettings(ShopSettingsBatchUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.invoice.seller.batchUpdateShopSettings", params);
    }

    /**
     * 批量查询店铺开票申请
     *
     * @param request 查询请求
     * @return 开票申请
     * @throws ServiceException 服务异常
     */
    public ShopApplicationBatchQueryResponse batchQueryShopApplication(ShopApplicationBatchQueryRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.invoice.seller.batchQueryShopApplication", params);
    }

    /**
     * 批量更新店铺开票申请
     *
     * @param request 更新请求
     * @return 更新结果
     * @throws ServiceException 服务异常
     */
    public ShopApplicationBatchUpdateResponse batchUpdateShopApplication(ShopApplicationBatchUpdateRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.invoice.seller.batchUpdateShopApplication", params);
    }
}
