package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.merchant.*;
import eleme.openapi.sdk.api.enumeration.merchant.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 自然人商户入驻服务
 */
@Service("eleme.merchant")
public class MerchantService extends BaseNopService {
    public MerchantService(Config config,Token token) {
        super(config, token, MerchantService.class);
    }

    /**
     * 查询商户电子签合同模版
     *
     * @return 合同模板信息
     * @throws ServiceException 服务异常
     */
    public ContractTemplateVO getMerchantContractTemplate() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.merchant.getMerchantContractTemplate", params);
    }

    /**
     * 文件上传(用于资质证照类文件上传)
     *
     * @param request 请求参数
     * @return UploadFileResponse返回信息
     * @throws ServiceException 服务异常
     */
    public UploadFileResponse upload(UploadFileRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.upload", params);
    }

    /**
     * 发送普通短信验证码(下发短信验证码至商户手机号)
     *
     * @param request 请求参数
     * @return true|false
     * @throws ServiceException 服务异常
     */
    public Boolean sendVerifyCode(PersonalIdentityVerifyRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.sendVerifyCode", params);
    }

    /**
     * 实名认证发送验证码请求(此接口用于商户姓名、身份证、手机号或银行卡等关键要素校验,以及认证验证码的发送)
     *
     * @param request 请求参数
     * @return true|false
     * @throws ServiceException 服务异常
     */
    public Boolean sendAuthVerifyCode(PersonalIdentityAuthRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.sendAuthVerifyCode", params);
    }

    /**
     * 创建商户入驻申请
     *
     * @param request 请求参数
     * @return 返回申请业务ID，如: "123456"
     * @throws ServiceException 服务异常
     */
    public String createApply(CreatePersonalMerchantApplyRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.createApply", params);
    }

    /**
     * 修改商户入驻申请的商户身份信息
     *
     * @param request 请求参数
     * @return true|false
     * @throws ServiceException 服务异常
     */
    public Boolean modifyIdentityApply(ModifyMerchantIdentityApplyRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.modifyIdentityApply", params);
    }

    /**
     * 修改商户入驻申请的认证信息，需携带实名认证验证码
     *
     * @param request 请求参数
     * @return true|false
     * @throws ServiceException 服务异常
     */
    public Boolean modifyAuthApply(ModifyMerchantApplyAuthRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.modifyAuthApply", params);
    }

    /**
     * 商户入驻申请送审
     *
     * @param request 请求参数
     * @return true|false
     * @throws ServiceException 服务异常
     */
    public Boolean submitAudit(SubmitMerchantAuditRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.submitAudit", params);
    }

    /**
     * 发送签约短信验证码
     *
     * @param request 请求参数
     * @return true|false
     * @throws ServiceException 服务异常
     */
    public Boolean sendSignVerifyCode(SendSignVerifyCodeRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.sendSignVerifyCode", params);
    }

    /**
     * 商户签约(签署电子合同)
     *
     * @param request 请求参数
     * @return true|false
     * @throws ServiceException 服务异常
     */
    public Boolean signContract(PersonalMerchantApplySignRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.signContract", params);
    }

    /**
     * 查询商户入驻申请详情
     *
     * @param request 请求参数
     * @return 商户申请信息
     * @throws ServiceException 服务异常
     */
    public PersonalMerchantApplyVO getById(GetPersonalMerchantApplyRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.getById", params);
    }

    /**
     * 修改已生效商户认证信息，需携带实名认证验证码
     *
     * @param request 请求参数
     * @return true|false
     * @throws ServiceException 服务异常
     */
    public Boolean modifyAuthInfo(ModifyMerchantAuthInfoRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.modifyAuthInfo", params);
    }

    /**
     * 根据证件号+证件类型修改商户认证信息，需携带实名认证验证码
     *
     * @param request 请求参数
     * @return 返回商户详细信息
     * @throws ServiceException 服务异常
     */
    public PersonalMerchantDetailVO modifyByLicenseTypeAndNo(ModifyByLicenseTypeAndNoRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.modifyByLicenseTypeAndNo", params);
    }

    /**
     * 根据证件类型+证件号码查询自然人商户(返回信息不包含入驻申请ID和商户ID等信息，且身份信息会脱敏处理)
     *
     * @param request 请求参数
     * @return 返回商户信息
     * @throws ServiceException 服务异常
     */
    public PersonalMerchantDigestVO getByLicenseTypeAndNo(LicenseTypeAndNoQueryRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.getByLicenseTypeAndNo", params);
    }

    /**
     * 根据证件类型+证件号码查询自然人商户详情，需要携带商户身份签名+短信验证
     *
     * @param request 请求参数
     * @return 返回商户详细信息
     * @throws ServiceException 服务异常
     */
    public PersonalMerchantDetailVO getMerchantByVerifyCode(GetMerchantByVerifyCodeRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.merchant.getMerchantByVerifyCode", params);
    }
}
