package eleme.openapi.sdk.media;

/**
 * @author jinli Feb 5, 2015
 */
public class MediaConfiguration {

    public static String CHARSET = "UTF-8";

    public static String SDK_VERSION = "1.0.0";

    public static String UPLOAD_API_UPLOAD = "/api/proxy/upload.json";
    public static String UPLOAD_API_BLOCK_INIT = "/api/proxy/blockInit.json";
    public static String UPLOAD_API_BLOCK_UPLOAD = "/api/proxy/blockUpload.json";
    public static String UPLOAD_API_BLOCK_COMPLETE = "/api/proxy/blockComplete.json";
    public static String UPLOAD_API_BLOCK_CANCEL = "/api/proxy/blockCancel.json";

    public static String UPLOAD_ENDPOINT = "http://upload.media.aliyun.com";
    public static String MANAGE_ENDPOINT = "http://rs.media.aliyun.com";
    public static String DATA_ENDPOINT = "https://tracemedia.taobao.com";
    public static String MANAGE_API_VERSION = "3.0";
    public static String MANAGE_API_VERSION_3_1 = "3.1";

    public static int MAX_HTTP_CONNECTIONS = 50;

    private String ak;
    private String sk;
    private String namespace;
    private String uploadEndpoint = UPLOAD_ENDPOINT;


    private static MediaConfiguration lastConfiguration;

    static {
        //设置默认的log实现. 使用log4j
        Class log4jClass = null;
        try {
            log4jClass = MediaConfiguration.class.getClassLoader().loadClass("org.apache.log4j.Logger");
        } catch (ClassNotFoundException e) {
            //
        }
        if (log4jClass != null) {
            System.setProperty("libs.logging.org.apache.commons.logging.Log", "libs.logging.org.apache.commons.logging.impl.Log4JLogger");
        }
    }

    public MediaConfiguration() {
        lastConfiguration = this;
    }


    public String getAk() {
        return ak;
    }

    public void setAk(String ak) {
        this.ak = ak;
    }

    public String getSk() {
        return sk;
    }

    public void setSk(String sk) {
        this.sk = sk;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUploadEndpoint() {
        return uploadEndpoint;
    }

    public void setUploadEndpoint(String uploadEndpoint) {
        this.uploadEndpoint = uploadEndpoint;
    }

    public static MediaConfiguration getLastConfiguration() {
        return lastConfiguration;
    }

    public static void setLastConfiguration(MediaConfiguration config) {
        lastConfiguration = config;
    }
}
