package eleme.openapi.sdk.media;


import eleme.openapi.sdk.utils.JacksonUtils;

import java.io.Serializable;

/**
 * @author jinli Mar 16, 2015
 */
public class Result<T> implements Serializable {

    private static final long serialVersionUID = -6753637594891783185L;

    private String requestId;   // request id, unique
    private int httpStatus;     // http status
    private String code;        // response code 
    private String message;     // response message
    private boolean success;    // success or not of response
    private T data;             // the data of response
    private Throwable t;             // the data of response

    public static <T> Result<T> create(int httpStatus, T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setHttpStatus(httpStatus);
        result.setData(data);
        return result;
    }

    public static <T> Result<T> create(int httpStatus, T data, String requestId) {
        Result<T> result = create(httpStatus, data);
        result.setRequestId(requestId);
        return result;
    }

    public static <T> Result<T> create(Throwable t) {
        return create(0, null, "ClientError", t.getMessage());
    }

    public static <T> Result<T> create(int httpStatus, String requestId, String code, String message) {
        Result<T> result = new Result<T>();
        result.setSuccess(false);
        result.setRequestId(requestId);
        result.setHttpStatus(httpStatus);
        result.setCode(code);
        result.setMessage(message);
        return result;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public int getHttpStatus() {
        return httpStatus;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }


    public Throwable getT() {
        return t;
    }

    public void setT(Throwable t) {
        this.t = t;
    }

    @Override
    public String toString() {
        return JacksonUtils.obj2json(this);
    }

}
