package eleme.openapi.sdk.media.common;

import java.util.ArrayList;

/**
 * @author jinli Feb 5, 2015
 */
public class PagedList<T> extends ArrayList<T> {

    private static final long serialVersionUID = 1L;

    private int page;           // current page number
    private int pageSize;       // page size, items per page
    private int total;          // total count of items

    public PagedList(int page, int pageSize, int total) {
        this.page = page;
        this.pageSize = pageSize;
        this.total = total;
    }

    public int getPage() {
        return page;
    }

    public int getPageSize() {
        return pageSize;
    }

    public int getTotal() {
        return total;
    }

}
