package eleme.openapi.sdk.media.manage;

import java.io.Serializable;

/**
 * Created by huamulou on 15/9/23.
 */
public class MediaEncodeRequest implements Serializable {
    private GlobalFileResource input;                               //输入的文件, 必须
    private GlobalFileResource output;                              //输出的文件, 必须
    private GlobalFileResource watermark;                           //使用的图片水印文件, 非必须, 如果配置了水印模板则必须
    private boolean usePreset = false;                              //是否使用系统模板, 必须
    private boolean force = false;                                  //存在同名文件是否覆盖, 必须
    private String notifyUrl;                                       //任务完成之后通知的url, 非必须
    private String encodeTemplate;                                  //视频模板名称, 必须
    private String watermarkTemplate;                               //水印模板名称，非必须
    private String seek;                                            //截取参数，从seek开始
    private String duration;                                        //截取参数，截取duration长度


    public GlobalFileResource getInput() {
        return input;
    }

    public void setInput(GlobalFileResource input) {
        this.input = input;
    }

    public GlobalFileResource getOutput() {
        return output;
    }

    public void setOutput(GlobalFileResource output) {
        this.output = output;
    }

    public GlobalFileResource getWatermark() {
        return watermark;
    }

    public void setWatermark(GlobalFileResource watermark) {
        this.watermark = watermark;
    }

    public boolean isUsePreset() {
        return usePreset;
    }

    public void setUsePreset(boolean usePreset) {
        this.usePreset = usePreset;
    }

    public boolean isForce() {
        return force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getEncodeTemplate() {
        return encodeTemplate;
    }

    public void setEncodeTemplate(String encodeTemplate) {
        this.encodeTemplate = encodeTemplate;
    }

    public String getWatermarkTemplate() {
        return watermarkTemplate;
    }

    public void setWatermarkTemplate(String watermarkTemplate) {
        this.watermarkTemplate = watermarkTemplate;
    }

    public String getSeek() {
        return seek;
    }

    public void setSeek(String seek) {
        this.seek = seek;
    }

    public String getDuration() {
        return duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }
}
