package eleme.openapi.sdk.media.upload;

import eleme.openapi.sdk.media.Result;

/**
 * upload client
 *
 * @author jinli Feb 5, 2015
 */
public interface UploadClient {

    /**
     * upload media files
     *
     * @param req req
     * @return UploadResponse
     */
    Result<UploadResponse> upload(UploadRequest req);

    /**
     * multipart init
     *
     * @param req req
     * @return MultipartInitResponse
     */
    Result<MultipartInitResponse> multipartInit(MultipartInitRequest req);

    /**
     * multipart upload
     *
     * @param req req
     * @return MultipartUploadResponse
     */
    Result<MultipartUploadResponse> multipartUpload(MultipartUploadRequest req);

    /**
     * multipart complete
     *
     * @param req req
     * @return MultipartCompleteResponse
     */
    Result<MultipartCompleteResponse> multipartComplete(MultipartCompleteRequest req);

    /**
     * multipart cancel
     *
     * @param req req
     * @return Void void
     */
    Result<Void> multipartCancel(MultipartCancelRequest req);


    /**
     * use trace for performance tuning
     * default is on
     *
     * @param traceOn traceOn
     */
    void setTraceOn(boolean traceOn);
}
