package eleme.openapi.sdk.media.upload;

import java.io.Serializable;

/**
 * @author jinli Feb 5, 2015
 */
public class UploadPolicy implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final int DETECT_MIME = 1;
    public static final int DETECT_MIME_NONE = 0;
    public static final int INSERT_ONLY = 1;
    public static final int INSERT_ONLY_NONE = 0;
    public static final int VIDEO_SYNC = 1;         // 视频同步
    public static final int DIVA_ENCODE = 1;        // DIVA转码
    public static final int VIDEO_SYNC_NONE = 0;    // 不进行视频跨OSS同步
    public static final int VIDEO_SCAN_NONE = 0;    // 不进行视频扫描
    public static final int DIVA_ENCODE_NONE = 0;   // 不进行全景图转码

    private String namespace;                     // media namespace name
    private String bucket;                        // media bucket name
    private String dir;                           // media file dir, magic vars and custom vars are supported
    private String name;                          // media file name, magic vars and custom vars are supported
    private long expiration;                      // expiration time, unix time, in milliseconds
    private long sizeLimit;                       // upload size limited, in bytes
    private String mimeLimit;                     // upload mime type limited
    private int detectMime = DETECT_MIME;         // is auto detecte media file mime type, default is true
    private int insertOnly = INSERT_ONLY_NONE;    // upload mode. it's not allowd uploading the same name files
    private String cacheControl;                  // set file max-age header

    private String callbackUrl;                   // callback urls, ip address is recommended
    private String callbackHost;                  // callback host
    private String callbackBody;                  // callback body, magic vars and custom vars are supported
    private String callbackBodyType;              // callback body type, default is 'application/x-www-form-urlencoded; charset=utf-8'
    private String returnBody;                    // return body, magic vars and custom vars are supported


    private String tbEndUser;                     // set tb end user;
    private String bizCode;                       // set biz Code;
    private Integer videoScan = VIDEO_SCAN_NONE;    // 视频安全扫描设置
    private Integer videoSync = VIDEO_SYNC_NONE;    // 中美数据同步设置
    private Integer divaEncode = DIVA_ENCODE_NONE;  // 全景图转码相关配置

    public MediaEncodePolicy mediaEncode;

    public void setDetectMime(int detectMime){
        this.detectMime = detectMime;
    }

    public int getDetectMime() {
        return detectMime;
    }

    public int getInsertOnly() {
        return insertOnly;
    }

    public void setInsertOnly(int insertOnly) {
        this.insertOnly = insertOnly;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getBucket() {
        return bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public long getExpiration() {
        return expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public String getDir() {
        return dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSizeLimit() {
        return sizeLimit;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public String getMimeLimit() {
        return mimeLimit;
    }

    public void setMimeLimit(String mimeLimit) {
        this.mimeLimit = mimeLimit;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getCallbackHost() {
        return callbackHost;
    }

    public void setCallbackHost(String callbackHost) {
        this.callbackHost = callbackHost;
    }

    public String getCallbackBody() {
        return callbackBody;
    }

    public void setCallbackBody(String callbackBody) {
        this.callbackBody = callbackBody;
    }

    public String getCallbackBodyType() {
        return callbackBodyType;
    }

    public void setCallbackBodyType(String callbackBodyType) {
        this.callbackBodyType = callbackBodyType;
    }

    public String getReturnBody() {
        return returnBody;
    }

    public void setReturnBody(String returnBody) {
        this.returnBody = returnBody;
    }

    public MediaEncodePolicy getMediaEncode() {
        return mediaEncode;
    }

    public void setMediaEncode(MediaEncodePolicy mediaEncode) {
        this.mediaEncode = mediaEncode;
    }

    public String getTbEndUser() {
        return tbEndUser;
    }

    public void setTbEndUser(String tbEndUser) {
        this.tbEndUser = tbEndUser;
    }

    public String getCacheControl() {
        return cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    public String getBizCode() {
        return bizCode;
    }

    public void setBizCode(String bizCode) {
        this.bizCode = bizCode;
    }

    public Integer getVideoScan() {
        return videoScan;
    }

    public void setVideoScan(Integer videoScan) {
        this.videoScan = videoScan;
    }

    public Integer getVideoSync() {
        return videoSync;
    }

    public void setVideoSync(Integer videoSync) {
        this.videoSync = videoSync;
    }

    public Integer getDivaEncode() {
        return divaEncode;
    }

    public void setDivaEncode(Integer divaEncode) {
        this.divaEncode = divaEncode;
    }
}
