package eleme.openapi.sdk.media.utils;

import java.io.*;

/**
 * Created by huamulou on 15/12/10.
 */
public class IOUtils {

    public static String toString(InputStream input) throws IOException {
        StringBuilder sb = new StringBuilder("");
        InputStreamReader in = new InputStreamReader(input, "utf-8");
        int n;
        char[] buffer = new char[64];
        while (-1 != (n = in.read(buffer))) {
            sb.append(buffer, 0, n);
        }
        return sb.toString();
    }

    public static byte[] toBytes(InputStream input) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int n;
        while (-1 != (n = input.read())) {
            out.write(n);
        }
        return out.toByteArray();
    }


    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        } catch (IOException ioe) {
            // ignore
        }
    }
}
