/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.product.AgreeShopDiagnosisRequest;
import eleme.openapi.sdk.api.entity.product.AgreeShopDiagnosisV2Request;
import eleme.openapi.sdk.api.entity.product.AuditStatusCallBackRequest;
import eleme.openapi.sdk.api.entity.product.BatchChainGroupResultDTO;
import eleme.openapi.sdk.api.entity.product.BatchChainItemResultDTO;
import eleme.openapi.sdk.api.entity.product.BatchDetailResultDTO;
import eleme.openapi.sdk.api.entity.product.BatchIdResultDTO;
import eleme.openapi.sdk.api.entity.product.BatchReplaceChainItemResultDTO;
import eleme.openapi.sdk.api.entity.product.CategoryWithChildrenIds;
import eleme.openapi.sdk.api.entity.product.ChainGroupBaseDTO;
import eleme.openapi.sdk.api.entity.product.ChainGroupDTO;
import eleme.openapi.sdk.api.entity.product.ChainGroupWithItemDTO;
import eleme.openapi.sdk.api.entity.product.ChainItemBaseDTO;
import eleme.openapi.sdk.api.entity.product.ChainItemDTO;
import eleme.openapi.sdk.api.entity.product.ChainMenuBaseDTO;
import eleme.openapi.sdk.api.entity.product.ChainMenuDTO;
import eleme.openapi.sdk.api.entity.product.ChainMenuWithGroupDTO;
import eleme.openapi.sdk.api.entity.product.ChainSkuBaseDTO;
import eleme.openapi.sdk.api.entity.product.ChainSkuDTO;
import eleme.openapi.sdk.api.entity.product.ChannelItemDTO;
import eleme.openapi.sdk.api.entity.product.ClearStock;
import eleme.openapi.sdk.api.entity.product.DayPartingStick;
import eleme.openapi.sdk.api.entity.product.IngredientGroup;
import eleme.openapi.sdk.api.entity.product.MaterialTree;
import eleme.openapi.sdk.api.entity.product.OBackCategory;
import eleme.openapi.sdk.api.entity.product.OBackCategoryProperty;
import eleme.openapi.sdk.api.entity.product.OBatchModifiedResult;
import eleme.openapi.sdk.api.entity.product.OBatchUpdateItemCategoryRequest;
import eleme.openapi.sdk.api.entity.product.OBatchUpdateItemIngredientRequest;
import eleme.openapi.sdk.api.entity.product.OBatchUpdateItemRequest;
import eleme.openapi.sdk.api.entity.product.OBatchUpdateShopItemsRequest;
import eleme.openapi.sdk.api.entity.product.OCategory;
import eleme.openapi.sdk.api.entity.product.OIngredientGroupDTO;
import eleme.openapi.sdk.api.entity.product.OIngredientGroupRelation;
import eleme.openapi.sdk.api.entity.product.OItem;
import eleme.openapi.sdk.api.entity.product.OItemHasPidAndLocks;
import eleme.openapi.sdk.api.entity.product.OItemIdWithSpecIds;
import eleme.openapi.sdk.api.entity.product.OItemIdWithSpecPrice;
import eleme.openapi.sdk.api.entity.product.OItemIdWithSpecStock;
import eleme.openapi.sdk.api.entity.product.OLimitItems;
import eleme.openapi.sdk.api.entity.product.OMaterial;
import eleme.openapi.sdk.api.entity.product.OMenu;
import eleme.openapi.sdk.api.entity.product.OMenuGroup;
import eleme.openapi.sdk.api.entity.product.OMenuSyncPreCheckResult;
import eleme.openapi.sdk.api.entity.product.OPackage;
import eleme.openapi.sdk.api.entity.product.OPackageGroup;
import eleme.openapi.sdk.api.entity.product.OPackageUpdate;
import eleme.openapi.sdk.api.entity.product.OSpu;
import eleme.openapi.sdk.api.entity.product.OSpuMenuSyncResult;
import eleme.openapi.sdk.api.entity.product.OSpuMenuSyncTaskDetail;
import eleme.openapi.sdk.api.entity.product.OSpuSyncSubTaskDetail;
import eleme.openapi.sdk.api.entity.product.OSpuSyncTask;
import eleme.openapi.sdk.api.entity.product.OUpdateAttributeSaleStatusByExtCodeRequest;
import eleme.openapi.sdk.api.entity.product.OUpdateIngredientSaleStatusByExtCodeRequest;
import eleme.openapi.sdk.api.entity.product.OUpdateIngredientSaleStatusResult;
import eleme.openapi.sdk.api.entity.product.OUpdateOnlyStockByExtCodeRequest;
import eleme.openapi.sdk.api.entity.product.OUpdateSaleStatusByExtCodeRequest;
import eleme.openapi.sdk.api.entity.product.OUpdateStockByExtCodeRequest;
import eleme.openapi.sdk.api.entity.product.OUpdateStockRequest;
import eleme.openapi.sdk.api.entity.product.OverrideSyncShopSpu;
import eleme.openapi.sdk.api.entity.product.PartialSyncShopSpu;
import eleme.openapi.sdk.api.entity.product.QueryPage;
import eleme.openapi.sdk.api.entity.product.ShopCommodityDiagDto;
import eleme.openapi.sdk.api.entity.product.ShopCommodityDiagV2Dto;
import eleme.openapi.sdk.api.entity.product.SingleShopSkuDTO;
import eleme.openapi.sdk.api.entity.product.SpuSyncResult;
import eleme.openapi.sdk.api.entity.product.SyncShopSpu;
import eleme.openapi.sdk.api.enumeration.product.OCategoryType;
import eleme.openapi.sdk.api.enumeration.product.OItemCreateProperty;
import eleme.openapi.sdk.api.enumeration.product.OItemUpdateProperty;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service(value="eleme.product")
public class ProductService
extends BaseNopService {
    public ProductService(Config config, Token token) {
        super(config, token, ProductService.class);
    }

    public OMenu publishMenuV2(Long shopId, OMenu menu) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("menu", menu);
        return (OMenu)this.call("eleme.product.spuMenuV2.publishMenuV2", params);
    }

    public OMenuGroup publishMenuGroupV2(Long shopId, String menuOutCode, OMenuGroup menuGroup) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("menuOutCode", menuOutCode);
        params.put("menuGroup", menuGroup);
        return (OMenuGroup)this.call("eleme.product.spuMenuV2.publishMenuGroupV2", params);
    }

    public OMenu getMenuV2(Long shopId, String menuOutCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("menuOutCode", menuOutCode);
        return (OMenu)this.call("eleme.product.spuMenuV2.getMenuV2", params);
    }

    public OSpuMenuSyncResult syncMenuV2(Long shopId, String menuOutCode, OverrideSyncShopSpu overrideSyncShopSpu) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("menuOutCode", menuOutCode);
        params.put("overrideSyncShopSpu", overrideSyncShopSpu);
        return (OSpuMenuSyncResult)this.call("eleme.product.spuMenuV2.syncMenuV2", params);
    }

    public OSpuMenuSyncResult syncPartialMenuV2(Long shopId, String menuOutCode, PartialSyncShopSpu partialSyncShopSpu) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("menuOutCode", menuOutCode);
        params.put("partialSyncShopSpu", partialSyncShopSpu);
        return (OSpuMenuSyncResult)this.call("eleme.product.spuMenuV2.syncPartialMenuV2", params);
    }

    public OSpuSyncTask getSpuMenuSyncTaskResultV2(Long shopId, Long mainTaskId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("mainTaskId", mainTaskId);
        return (OSpuSyncTask)this.call("eleme.product.spuMenuV2.getSpuMenuSyncTaskResultV2", params);
    }

    public List<OSpuMenuSyncTaskDetail> batchGetSyncTasksV2(Long shopId, List<Long> taskIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("taskIds", taskIds);
        return (List)this.call("eleme.product.spuMenuV2.batchGetSyncTasksV2", params);
    }

    public ChainMenuWithGroupDTO getMenuWithGroup(String mid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", mid);
        return (ChainMenuWithGroupDTO)this.call("eleme.product.chain.menu.getMenuWithGroup", params);
    }

    public List<ChainMenuDTO> queryMenuByPage(Long offset, Long limit) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("offset", offset);
        params.put("limit", limit);
        return (List)this.call("eleme.product.chain.menu.queryMenuByPage", params);
    }

    public ChainMenuDTO createMenu(ChainMenuBaseDTO chainMenuBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chainMenuBaseDTO", chainMenuBaseDTO);
        return (ChainMenuDTO)this.call("eleme.product.chain.menu.createMenu", params);
    }

    public ChainMenuDTO updateMenu(String mid, ChainMenuBaseDTO chainMenuBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", mid);
        params.put("chainMenuBaseDTO", chainMenuBaseDTO);
        return (ChainMenuDTO)this.call("eleme.product.chain.menu.updateMenu", params);
    }

    public void deleteMenu(String mid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", mid);
        this.call("eleme.product.chain.menu.deleteMenu", params);
    }

    public List<ChannelItemDTO> listByShopId(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.channel.item.listByShopId", params);
    }

    public List<ChannelItemDTO> listByItemIds(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (List)this.call("eleme.product.channel.item.listByItemIds", params);
    }

    public ChannelItemDTO create(ChannelItemDTO item) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("item", item);
        return (ChannelItemDTO)this.call("eleme.product.channel.item.create", params);
    }

    public ChannelItemDTO modify(ChannelItemDTO item) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("item", item);
        return (ChannelItemDTO)this.call("eleme.product.channel.item.modify", params);
    }

    public void remove(Long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        this.call("eleme.product.channel.item.remove", params);
    }

    public Map<Long, Boolean> batchSetSaleStatus(Map<Long, Integer> itemSaleStatusMap) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemSaleStatusMap", itemSaleStatusMap);
        return (Map)this.call("eleme.product.channel.item.batchSetSaleStatus", params);
    }

    public Map<Long, Boolean> batchSetStock(Map<Long, Integer> skuStockMap) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuStockMap", skuStockMap);
        return (Map)this.call("eleme.product.channel.item.batchSetStock", params);
    }

    public ChainGroupDTO getGroup(String gid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        return (ChainGroupDTO)this.call("eleme.product.chain.group.getGroup", params);
    }

    public ChainGroupWithItemDTO getGroupWithItem(String gid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        return (ChainGroupWithItemDTO)this.call("eleme.product.chain.group.getGroupWithItem", params);
    }

    public ChainGroupDTO createGroup(String mid, ChainGroupBaseDTO chainGroupBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", mid);
        params.put("chainGroupBaseDTO", chainGroupBaseDTO);
        return (ChainGroupDTO)this.call("eleme.product.chain.group.createGroup", params);
    }

    public BatchChainGroupResultDTO batchCreateGroup(String mid, List<ChainGroupBaseDTO> chainGroupBaseDTOs) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", mid);
        params.put("chainGroupBaseDTOs", chainGroupBaseDTOs);
        return (BatchChainGroupResultDTO)this.call("eleme.product.chain.group.batchCreateGroup", params);
    }

    public ChainGroupDTO updateGroup(String gid, ChainGroupBaseDTO chainGroupBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        params.put("chainGroupBaseDTO", chainGroupBaseDTO);
        return (ChainGroupDTO)this.call("eleme.product.chain.group.updateGroup", params);
    }

    public void deleteGroup(String gid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        this.call("eleme.product.chain.group.deleteGroup", params);
    }

    public List<SingleShopSkuDTO> getRelationByPid(String pId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        return (List)this.call("eleme.product.chain.pid.getRelationByPid", params);
    }

    public void setPid(String pId, Long specId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        params.put("specId", specId);
        this.call("eleme.product.chain.pid.setPid", params);
    }

    public BatchIdResultDTO batchSetPid(String pId, List<Long> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        params.put("specIds", specIds);
        return (BatchIdResultDTO)this.call("eleme.product.chain.pid.batchSetPid", params);
    }

    public void deletePidBySpecId(Long specId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specId", specId);
        this.call("eleme.product.chain.pid.deletePidBySpecId", params);
    }

    public BatchIdResultDTO batchDeletePidBySpecId(List<Long> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specIds", specIds);
        return (BatchIdResultDTO)this.call("eleme.product.chain.pid.batchDeletePidBySpecId", params);
    }

    public List<OCategory> getShopCategories(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.category.getShopCategories", params);
    }

    public List<OCategory> getShopCategoriesWithChildren(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.category.getShopCategoriesWithChildren", params);
    }

    public OCategory getCategory(Long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        return (OCategory)this.call("eleme.product.category.getCategory", params);
    }

    public OCategory getCategoryWithChildren(long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        return (OCategory)this.call("eleme.product.category.getCategoryWithChildren", params);
    }

    public OCategory createCategory(long shopId, String name, String description) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("name", name);
        params.put("description", description);
        return (OCategory)this.call("eleme.product.category.createCategory", params);
    }

    public OCategory createCategoryV2(long shopId, String name, String description, String extCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("name", name);
        params.put("description", description);
        params.put("extCode", extCode);
        return (OCategory)this.call("eleme.product.category.createCategoryV2", params);
    }

    public OCategory createCategoryWithChildren(long shopId, String name, long parentId, String description) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("name", name);
        params.put("parentId", parentId);
        params.put("description", description);
        return (OCategory)this.call("eleme.product.category.createCategoryWithChildren", params);
    }

    public OCategory updateCategory(long categoryId, String name, String description) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("name", name);
        params.put("description", description);
        return (OCategory)this.call("eleme.product.category.updateCategory", params);
    }

    public OCategory updateCategoryV2(long categoryId, String name, String description, String extCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("name", name);
        params.put("description", description);
        params.put("extCode", extCode);
        return (OCategory)this.call("eleme.product.category.updateCategoryV2", params);
    }

    public OCategory updateCategoryWithChildren(long categoryId, String name, long parentId, String description) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("name", name);
        params.put("parentId", parentId);
        params.put("description", description);
        return (OCategory)this.call("eleme.product.category.updateCategoryWithChildren", params);
    }

    public OCategory removeCategory(long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        return (OCategory)this.call("eleme.product.category.removeCategory", params);
    }

    public void invalidCategory(Long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        this.call("eleme.product.category.invalidCategory", params);
    }

    public void setCategoryPositions(Long shopId, List<Long> categoryIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryIds", categoryIds);
        this.call("eleme.product.category.setCategoryPositions", params);
    }

    public void setCategorySequence(Long shopId, List<Long> categoryIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryIds", categoryIds);
        this.call("eleme.product.category.setCategorySequence", params);
    }

    public void setCategoryPositionsWithChildren(Long shopId, List<CategoryWithChildrenIds> categoryWithChildrenIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryWithChildrenIds", categoryWithChildrenIds);
        this.call("eleme.product.category.setCategoryPositionsWithChildren", params);
    }

    public List<OBackCategory> getBackCategory(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.category.getBackCategory", params);
    }

    public void setCategoryType(Long shopId, Long categoryId, OCategoryType categoryType) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryId", categoryId);
        params.put("categoryType", (Object)categoryType);
        this.call("eleme.product.category.setCategoryType", params);
    }

    public OCategory setDayPartingStickTime(Long shopId, Long categoryId, DayPartingStick dayPartingStick) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryId", categoryId);
        params.put("dayPartingStick", dayPartingStick);
        return (OCategory)this.call("eleme.product.category.setDayPartingStickTime", params);
    }

    public boolean removeDayPartingStickTime(Long shopId, Long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("categoryId", categoryId);
        return (Boolean)this.call("eleme.product.category.removeDayPartingStickTime", params);
    }

    public List<OBackCategory> getBackCategoryV2(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.category.getBackCategoryV2", params);
    }

    public List<OBackCategoryProperty> getBackCategoryPropertyV2(Long shopId, Long backCategoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("backCategoryId", backCategoryId);
        return (List)this.call("eleme.product.category.getBackCategoryPropertyV2", params);
    }

    public List<OMaterial> getMaterials(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.category.getMaterials", params);
    }

    public OItem createPackage(long categoryId, OPackage oPackage) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("oPackage", oPackage);
        return (OItem)this.call("eleme.product.package.createPackage", params);
    }

    public OItem updatePackageContent(long itemId, long categoryId, OPackageUpdate update) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("categoryId", categoryId);
        params.put("update", update);
        return (OItem)this.call("eleme.product.package.updatePackageContent", params);
    }

    public OItem updatePackageRelation(long itemId, List<OPackageGroup> packages) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("packages", packages);
        return (OItem)this.call("eleme.product.package.updatePackageRelation", params);
    }

    public void removePackage(long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        this.call("eleme.product.package.removePackage", params);
    }

    public Map<Long, OItem> getItemsByCategoryId(long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        return (Map)this.call("eleme.product.item.getItemsByCategoryId", params);
    }

    public OItem getItem(long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        return (OItem)this.call("eleme.product.item.getItem", params);
    }

    public Map<Long, OItem> batchGetItems(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (Map)this.call("eleme.product.item.batchGetItems", params);
    }

    public OItem createItem(long categoryId, Map<OItemCreateProperty, Object> properties) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("properties", properties);
        return (OItem)this.call("eleme.product.item.createItem", params);
    }

    public Map<Long, OItem> batchCreateItems(long categoryId, List<Map<OItemCreateProperty, Object>> items) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("items", items);
        return (Map)this.call("eleme.product.item.batchCreateItems", params);
    }

    public Map<Long, OItem> batchCreateItemsIgnoreError(long categoryId, List<Map<OItemCreateProperty, Object>> items) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("items", items);
        return (Map)this.call("eleme.product.item.batchCreateItemsIgnoreError", params);
    }

    public OItem updateItem(long itemId, long categoryId, Map<OItemUpdateProperty, Object> properties) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("categoryId", categoryId);
        params.put("properties", properties);
        return (OItem)this.call("eleme.product.item.updateItem", params);
    }

    public List<BatchDetailResultDTO> batchUpdateItems(List<OBatchUpdateItemRequest> requests) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("requests", requests);
        return (List)this.call("eleme.product.item.batchUpdateItems", params);
    }

    public void batchFillStock(List<OItemIdWithSpecIds> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specIds", specIds);
        this.call("eleme.product.item.batchFillStock", params);
    }

    public void batchClearStock(List<OItemIdWithSpecIds> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specIds", specIds);
        this.call("eleme.product.item.batchClearStock", params);
    }

    public void batchUpdateStockDetail(Long shopId, List<OUpdateStockRequest> updateStockRequests) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("updateStockRequests", updateStockRequests);
        this.call("eleme.product.item.batchUpdateStockDetail", params);
    }

    public void batchOnShelf(List<OItemIdWithSpecIds> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specIds", specIds);
        this.call("eleme.product.item.batchOnShelf", params);
    }

    public OBatchModifiedResult batchListItems(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (OBatchModifiedResult)this.call("eleme.product.item.batchListItems", params);
    }

    public void batchOffShelf(List<OItemIdWithSpecIds> specIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specIds", specIds);
        this.call("eleme.product.item.batchOffShelf", params);
    }

    public OBatchModifiedResult batchDelistItems(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (OBatchModifiedResult)this.call("eleme.product.item.batchDelistItems", params);
    }

    public OItem removeItem(long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        return (OItem)this.call("eleme.product.item.removeItem", params);
    }

    public void invalidItem(long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        this.call("eleme.product.item.invalidItem", params);
    }

    public Map<Long, OItem> batchRemoveItems(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (Map)this.call("eleme.product.item.batchRemoveItems", params);
    }

    public Map<Long, OItem> batchRemoveItemsV2(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (Map)this.call("eleme.product.item.batchRemoveItemsV2", params);
    }

    public void batchUpdateSpecStocks(List<OItemIdWithSpecStock> specStocks) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specStocks", specStocks);
        this.call("eleme.product.item.batchUpdateSpecStocks", params);
    }

    public OBatchModifiedResult batchUpdateStock(Map<Long, Integer> stockMap) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("stockMap", stockMap);
        return (OBatchModifiedResult)this.call("eleme.product.item.batchUpdateStock", params);
    }

    public void setItemPositions(Long categoryId, List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("itemIds", itemIds);
        this.call("eleme.product.item.setItemPositions", params);
    }

    public void clearAndTimingMaxStock(List<ClearStock> clearStocks) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("clearStocks", clearStocks);
        this.call("eleme.product.item.clearAndTimingMaxStock", params);
    }

    public OItem getItemByShopIdAndExtendCode(Long shopId, String extendCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("extendCode", extendCode);
        return (OItem)this.call("eleme.product.item.getItemByShopIdAndExtendCode", params);
    }

    public List<OItem> getItemsByShopIdAndBarCode(Long shopId, String barCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("barCode", barCode);
        return (List)this.call("eleme.product.item.getItemsByShopIdAndBarCode", params);
    }

    public void batchUpdatePrices(Long shopId, List<OItemIdWithSpecPrice> specPrices) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("specPrices", specPrices);
        this.call("eleme.product.item.batchUpdatePrices", params);
    }

    public List<Long> getItemIdsHasActivityByShopId(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.item.getItemIdsHasActivityByShopId", params);
    }

    public List<Long> getShopSalesItems(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.item.getShopSalesItems", params);
    }

    public void setOrderPackingFee(Long shopId, boolean status, Double packingFee) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("status", status);
        params.put("packingFee", packingFee);
        this.call("eleme.product.item.setOrderPackingFee", params);
    }

    public List<OItem> queryItemByPage(QueryPage queryPage) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryPage", queryPage);
        return (List)this.call("eleme.product.item.queryItemByPage", params);
    }

    public List<OItem> queryItemByPageV2(QueryPage queryPage) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryPage", queryPage);
        return (List)this.call("eleme.product.item.queryItemByPageV2", params);
    }

    public List<MaterialTree> getMaterialTree(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.item.getMaterialTree", params);
    }

    public void setIngredient(Long shopId, Long mainItemId, IngredientGroup ingredientGroup) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("mainItemId", mainItemId);
        params.put("ingredientGroup", ingredientGroup);
        this.call("eleme.product.item.setIngredient", params);
    }

    public void removeIngredient(Long shopId, Long mainItemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("mainItemId", mainItemId);
        this.call("eleme.product.item.removeIngredient", params);
    }

    public void setRelatedItemIds(Long shopId, Long itemId, List<Long> relatedItemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("itemId", itemId);
        params.put("relatedItemIds", relatedItemIds);
        this.call("eleme.product.item.setRelatedItemIds", params);
    }

    public boolean displayRelatedItemIds(Long shopId, Long itemId, boolean display) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("itemId", itemId);
        params.put("display", display);
        return (Boolean)this.call("eleme.product.item.displayRelatedItemIds", params);
    }

    public Map<Long, List<Long>> getRelatedItemIds(Long shopId, Long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("itemId", itemId);
        return (Map)this.call("eleme.product.item.getRelatedItemIds", params);
    }

    public OItem createMultiSpecItem(long categoryId, Map<OItemCreateProperty, Object> properties) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("properties", properties);
        return (OItem)this.call("eleme.product.item.createMultiSpecItem", params);
    }

    public Map<Long, OItem> batchCreateMultiSpecItem(long categoryId, List<Map<OItemCreateProperty, Object>> items) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        params.put("items", items);
        return (Map)this.call("eleme.product.item.batchCreateMultiSpecItem", params);
    }

    public OItem updateMultiSpecItem(long itemId, long categoryId, Map<OItemUpdateProperty, Object> properties) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("categoryId", categoryId);
        params.put("properties", properties);
        return (OItem)this.call("eleme.product.item.updateMultiSpecItem", params);
    }

    public List<BatchDetailResultDTO> batchUpdateMultiSpecItem(List<OBatchUpdateItemRequest> requests) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("requests", requests);
        return (List)this.call("eleme.product.item.batchUpdateMultiSpecItem", params);
    }

    public void setIngredientGroup(long itemId, List<OIngredientGroupRelation> groupRelations) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("groupRelations", groupRelations);
        this.call("eleme.product.item.setIngredientGroup", params);
    }

    public void setSkuIngredientGroup(long specId, List<OIngredientGroupRelation> groupRelations) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specId", specId);
        params.put("groupRelations", groupRelations);
        this.call("eleme.product.item.setSkuIngredientGroup", params);
    }

    public void removeIngredientGroup(long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        this.call("eleme.product.item.removeIngredientGroup", params);
    }

    public List<MaterialTree> getItemMaterialTree(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.item.getItemMaterialTree", params);
    }

    public OIngredientGroupDTO createIngredientGroup(OIngredientGroupDTO ingredientGroup) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ingredientGroup", ingredientGroup);
        return (OIngredientGroupDTO)this.call("eleme.product.item.createIngredientGroup", params);
    }

    public List<OIngredientGroupDTO> batchCreateIngredientGroups(List<OIngredientGroupDTO> ingredientGroups) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ingredientGroups", ingredientGroups);
        return (List)this.call("eleme.product.item.batchCreateIngredientGroups", params);
    }

    public OIngredientGroupDTO getIngredientGroup(Long ingredientGroupId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ingredientGroupId", ingredientGroupId);
        return (OIngredientGroupDTO)this.call("eleme.product.item.getIngredientGroup", params);
    }

    public List<OIngredientGroupDTO> listIngredientGroups(List<Long> ingredientGroupIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ingredientGroupIds", ingredientGroupIds);
        return (List)this.call("eleme.product.item.listIngredientGroups", params);
    }

    public void deleteIngredientGroup(Long ingredientGroupId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ingredientGroupId", ingredientGroupId);
        this.call("eleme.product.item.deleteIngredientGroup", params);
    }

    public void bindIngredientGroups(Long itemId, List<Long> ingredientGroupIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("ingredientGroupIds", ingredientGroupIds);
        this.call("eleme.product.item.bindIngredientGroups", params);
    }

    public void bindSkuIngredientGroups(Long specId, List<Long> ingredientGroupIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specId", specId);
        params.put("ingredientGroupIds", ingredientGroupIds);
        this.call("eleme.product.item.bindSkuIngredientGroups", params);
    }

    public void unbindIngredientGroups(Long itemId, List<Long> ingredientGroupIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("ingredientGroupIds", ingredientGroupIds);
        this.call("eleme.product.item.unbindIngredientGroups", params);
    }

    public void unbindSkuIngredientGroups(Long specId, List<Long> ingredientGroupIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specId", specId);
        params.put("ingredientGroupIds", ingredientGroupIds);
        this.call("eleme.product.item.unbindSkuIngredientGroups", params);
    }

    public void removeMainItemIngredientGroups(Long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        this.call("eleme.product.item.removeMainItemIngredientGroups", params);
    }

    public void removeSkuIngredientGroups(Long specId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("specId", specId);
        this.call("eleme.product.item.removeSkuIngredientGroups", params);
    }

    public void updateItemGroup(Long shopId, Long itemId, Long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("itemId", itemId);
        params.put("categoryId", categoryId);
        this.call("eleme.product.item.updateItemGroup", params);
    }

    public void bindVideo(Long itemId, String contentId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("contentId", contentId);
        this.call("eleme.product.item.bindVideo", params);
    }

    public void unbindVideo(Long itemId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        this.call("eleme.product.item.unbindVideo", params);
    }

    public List<OItem> getItemsByCategoryIdV2(long categoryId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("categoryId", categoryId);
        return (List)this.call("eleme.product.item.getItemsByCategoryIdV2", params);
    }

    public void batchUpdateShopItems(Long shopId, OBatchUpdateShopItemsRequest request) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("request", request);
        this.call("eleme.product.item.batchUpdateShopItems", params);
    }

    public void batchUpdateItemIngredient(Long shopId, OBatchUpdateItemIngredientRequest request) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("request", request);
        this.call("eleme.product.item.batchUpdateItemIngredient", params);
    }

    public void batchUpdateItemCategory(Long shopId, OBatchUpdateItemCategoryRequest request) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("request", request);
        this.call("eleme.product.item.batchUpdateItemCategory", params);
    }

    public List<OItem> getShopLimitedItems(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.product.item.getShopLimitedItems", params);
    }

    public OLimitItems getShopLimitedItemsV2(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OLimitItems)this.call("eleme.product.item.getShopLimitedItemsV2", params);
    }

    public List<Long> getTestShopIds() throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return (List)this.call("eleme.product.item.getTestShopIds", params);
    }

    public Map<Long, OItemHasPidAndLocks> batchGetPidAndLocks(List<Long> itemIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        return (Map)this.call("eleme.product.item.batchGetPidAndLocks", params);
    }

    public Map<Long, Boolean> batchGetShopCanSupportAbility(List<Long> shopIds, String supportCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        params.put("supportCode", supportCode);
        return (Map)this.call("eleme.product.item.batchGetShopCanSupportAbility", params);
    }

    public Boolean dyAuditStatusCallBack(AuditStatusCallBackRequest request) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return (Boolean)this.call("eleme.product.dy.dyAuditStatusCallBack", params);
    }

    public ShopCommodityDiagDto getShopCommodityDiagnosisData(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (ShopCommodityDiagDto)this.call("eleme.product.renovate.getShopCommodityDiagnosisData", params);
    }

    public void agreeShopCommodityDiagnosisProblem(AgreeShopDiagnosisRequest request) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        this.call("eleme.product.renovate.agreeShopCommodityDiagnosisProblem", params);
    }

    public ShopCommodityDiagV2Dto getShopCommodityDiagnosisDataV2(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (ShopCommodityDiagV2Dto)this.call("eleme.product.renovate.getShopCommodityDiagnosisDataV2", params);
    }

    public void agreeShopCommodityDiagnosisProblemV2(AgreeShopDiagnosisV2Request request) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        this.call("eleme.product.renovate.agreeShopCommodityDiagnosisProblemV2", params);
    }

    public ChainItemDTO getChainItem(String iid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("iid", iid);
        return (ChainItemDTO)this.call("eleme.product.chain.item.getChainItem", params);
    }

    public List<ChainItemDTO> batchGetChainItem(List<String> iids) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("iids", iids);
        return (List)this.call("eleme.product.chain.item.batchGetChainItem", params);
    }

    public ChainItemDTO createChainItem(String gid, ChainItemBaseDTO chainItemBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        params.put("chainItemBaseDTO", chainItemBaseDTO);
        return (ChainItemDTO)this.call("eleme.product.chain.item.createChainItem", params);
    }

    public BatchChainItemResultDTO batchCreateChainItem(String gid, List<ChainItemBaseDTO> chainItemBaseDTOs) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        params.put("chainItemBaseDTOs", chainItemBaseDTOs);
        return (BatchChainItemResultDTO)this.call("eleme.product.chain.item.batchCreateChainItem", params);
    }

    public ChainItemDTO replaceChainItem(String gid, ChainItemDTO chainItemDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        params.put("chainItemDTO", chainItemDTO);
        return (ChainItemDTO)this.call("eleme.product.chain.item.replaceChainItem", params);
    }

    public BatchReplaceChainItemResultDTO batchReplaceChainItem(String gid, List<ChainItemDTO> chainItemDTOs) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gid", gid);
        params.put("chainItemDTOs", chainItemDTOs);
        return (BatchReplaceChainItemResultDTO)this.call("eleme.product.chain.item.batchReplaceChainItem", params);
    }

    public ChainItemDTO updateChainItemWithoutSku(String iid, ChainItemBaseDTO chainItemBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("iid", iid);
        params.put("chainItemBaseDTO", chainItemBaseDTO);
        return (ChainItemDTO)this.call("eleme.product.chain.item.updateChainItemWithoutSku", params);
    }

    public void deleteChainItem(String iid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("iid", iid);
        this.call("eleme.product.chain.item.deleteChainItem", params);
    }

    public ChainSkuDTO getSku(String pId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        return (ChainSkuDTO)this.call("eleme.product.chain.item.getSku", params);
    }

    public ChainSkuDTO addSku(String iid, ChainSkuBaseDTO chainSkuBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("iid", iid);
        params.put("chainSkuBaseDTO", chainSkuBaseDTO);
        return (ChainSkuDTO)this.call("eleme.product.chain.item.addSku", params);
    }

    public ChainSkuDTO updateSku(String pId, ChainSkuBaseDTO chainSkuBaseDTO) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        params.put("chainSkuBaseDTO", chainSkuBaseDTO);
        return (ChainSkuDTO)this.call("eleme.product.chain.item.updateSku", params);
    }

    public void deleteSku(String pId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        this.call("eleme.product.chain.item.deleteSku", params);
    }

    public Map<String, OItem> getItemsByExtCode(Long shopId, List<String> itemExtCodes) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("itemExtCodes", itemExtCodes);
        return (Map)this.call("eleme.product.itemV2.getItemsByExtCode", params);
    }

    public List<BatchDetailResultDTO> batchUpdateStockDetailByExtCode(Long shopId, List<OUpdateStockByExtCodeRequest> updateStockRequests) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("updateStockRequests", updateStockRequests);
        return (List)this.call("eleme.product.itemV2.batchUpdateStockDetailByExtCode", params);
    }

    public List<BatchDetailResultDTO> batchUpdateStockByExtCode(Long shopId, List<OUpdateOnlyStockByExtCodeRequest> updateStockRequests) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("updateStockRequests", updateStockRequests);
        return (List)this.call("eleme.product.itemV2.batchUpdateStockByExtCode", params);
    }

    public List<BatchDetailResultDTO> batchUpdateSaleStatusByExtCode(Long shopId, List<OUpdateSaleStatusByExtCodeRequest> updateSaleStatusRequests) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("updateSaleStatusRequests", updateSaleStatusRequests);
        return (List)this.call("eleme.product.itemV2.batchUpdateSaleStatusByExtCode", params);
    }

    public List<BatchDetailResultDTO> batchUpdateAttributeSaleStatusByExtCode(Long shopId, List<OUpdateAttributeSaleStatusByExtCodeRequest> updateAttributeSaleStatusRequests) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("updateAttributeSaleStatusRequests", updateAttributeSaleStatusRequests);
        return (List)this.call("eleme.product.itemV2.batchUpdateAttributeSaleStatusByExtCode", params);
    }

    public List<OUpdateIngredientSaleStatusResult> batchUpdateItemIngredientSaleStatusByExtCode(Long shopId, List<OUpdateIngredientSaleStatusByExtCodeRequest> updateIngredientSaleStatusByExtCodeRequests) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("updateIngredientSaleStatusByExtCodeRequests", updateIngredientSaleStatusByExtCodeRequests);
        return (List)this.call("eleme.product.itemV2.batchUpdateItemIngredientSaleStatusByExtCode", params);
    }

    public SpuSyncResult publishSpu(Long shopId, OSpu spu, Boolean isAutoSync) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("spu", spu);
        params.put("isAutoSync", isAutoSync);
        return (SpuSyncResult)this.call("eleme.product.spu.publishSpu", params);
    }

    public SpuSyncResult deleteSpu(Long shopId, String spuOutCode, Boolean isAutoSync) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("spuOutCode", spuOutCode);
        params.put("isAutoSync", isAutoSync);
        return (SpuSyncResult)this.call("eleme.product.spu.deleteSpu", params);
    }

    public OSpu updateSpuSaleStatus(Long shopId, String spuOutCode, Integer saleStatus, Boolean isAutoSync) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("spuOutCode", spuOutCode);
        params.put("saleStatus", saleStatus);
        params.put("isAutoSync", isAutoSync);
        return (OSpu)this.call("eleme.product.spu.updateSpuSaleStatus", params);
    }

    public List<OSpu> querySpuByPage(QueryPage queryPage) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryPage", queryPage);
        return (List)this.call("eleme.product.spu.querySpuByPage", params);
    }

    public OSpu getSpuBySpuOutCode(Long shopId, String spuOutCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("spuOutCode", spuOutCode);
        return (OSpu)this.call("eleme.product.spu.getSpuBySpuOutCode", params);
    }

    public OSpu publishSpuV2(Long shopId, OSpu spu) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("spu", spu);
        return (OSpu)this.call("eleme.product.spuV2.publishSpuV2", params);
    }

    public OSpu deleteSpuV2(Long shopId, String spuOutCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("spuOutCode", spuOutCode);
        return (OSpu)this.call("eleme.product.spuV2.deleteSpuV2", params);
    }

    public List<OSpu> querySpuByPageV2(QueryPage queryPage) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryPage", queryPage);
        return (List)this.call("eleme.product.spuV2.querySpuByPageV2", params);
    }

    public OSpu getSpuBySpuOutCodeV2(Long shopId, String spuOutCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("spuOutCode", spuOutCode);
        return (OSpu)this.call("eleme.product.spuV2.getSpuBySpuOutCodeV2", params);
    }

    public String uploadImage(String image) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("image", image);
        return (String)this.call("eleme.file.uploadImage", params);
    }

    public String uploadImageWithRemoteUrl(String url) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", url);
        return (String)this.call("eleme.file.uploadImageWithRemoteUrl", params);
    }

    public String getUploadedUrl(String hash) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hash", hash);
        return (String)this.call("eleme.file.getUploadedUrl", params);
    }

    public String getImageUrl(String hash) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hash", hash);
        return (String)this.call("eleme.file.getImageUrl", params);
    }

    public OMenu publishMenu(Long shopId, OMenu menu) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("menu", menu);
        return (OMenu)this.call("eleme.product.menu.publishMenu", params);
    }

    public OMenu getMenu(Long shopId, String menuOutCode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("menuOutCode", menuOutCode);
        return (OMenu)this.call("eleme.product.menu.getMenu", params);
    }

    public Long syncMenu(Long shopId, String menuOutCode, List<SyncShopSpu> syncShopSpus) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("menuOutCode", menuOutCode);
        params.put("syncShopSpus", syncShopSpus);
        return (Long)this.call("eleme.product.menu.syncMenu", params);
    }

    public OSpuSyncTask getSyncTask(Long shopId, Long taskId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("taskId", taskId);
        return (OSpuSyncTask)this.call("eleme.product.menu.getSyncTask", params);
    }

    public List<OSpuSyncSubTaskDetail> getSyncSubTasks(Long shopId, Long subTaskIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("subTaskIds", subTaskIds);
        return (List)this.call("eleme.product.menu.getSyncSubTasks", params);
    }

    public OMenuSyncPreCheckResult syncMenuPreCheck(Long shopId, String menuOutCode, List<SyncShopSpu> syncShopSpus) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("menuOutCode", menuOutCode);
        params.put("syncShopSpus", syncShopSpus);
        return (OMenuSyncPreCheckResult)this.call("eleme.product.menu.syncMenuPreCheck", params);
    }
}

