/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.media.common;

import eleme.openapi.sdk.utils.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class EncodeUtil {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static ThreadLocal<MessageDigest> TL_DIGEST = new ThreadLocal();
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HMAC_SHA1 = "HmacSHA1";

    public static String encodeWithMD5(File file) throws IOException, NoSuchAlgorithmException {
        return EncodeUtil.encodeWithMD5(file, 2048);
    }

    public static String encodeWithMD5(String s) throws NoSuchAlgorithmException {
        return EncodeUtil.encodeWithMD5(s.getBytes(DEFAULT_CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encodeWithMD5(File file, int bufferSize) throws IOException, NoSuchAlgorithmException {
        FileInputStream fileInputStream = null;
        try {
            int length;
            MessageDigest messageDigest = EncodeUtil.getDigest();
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[bufferSize];
            while ((length = fileInputStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, length);
            }
            String string = EncodeUtil.bufferToHex(messageDigest.digest());
            return string;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                fileInputStream = null;
            }
        }
    }

    public static String encodeWithMD5(byte[] bytes) {
        EncodeUtil.getDigest().update(bytes);
        return EncodeUtil.bufferToHex(EncodeUtil.getDigest().digest());
    }

    public static String encodeWithMD5(InputStream is, int bufferSize) throws IOException {
        int length;
        MessageDigest messageDigest = EncodeUtil.getDigest();
        byte[] buffer = new byte[bufferSize];
        while ((length = is.read(buffer)) != -1) {
            messageDigest.update(buffer, 0, length);
        }
        return EncodeUtil.bufferToHex(messageDigest.digest());
    }

    private static MessageDigest getDigest() {
        MessageDigest digest = TL_DIGEST.get();
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            TL_DIGEST.set(digest);
        }
        return digest;
    }

    private static String bufferToHex(byte[] bytes) {
        return EncodeUtil.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            EncodeUtil.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }

    public static String encodeWithHmacSha1(String data, String key) throws InvalidKeyException, NoSuchAlgorithmException {
        if (data == null || key == null) {
            throw new NullPointerException();
        }
        return EncodeUtil.encodeWithHmacSha1(data.getBytes(DEFAULT_CHARSET), key.getBytes(DEFAULT_CHARSET));
    }

    private static String encodeWithHmacSha1(byte[] data, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        if (data == null || key == null) {
            throw new NullPointerException();
        }
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(data);
        return EncodeUtil.bufferToHex(rawHmac);
    }

    public static String encodeWithURLSafeBase64(String arg) {
        if (arg == null) {
            throw new NullPointerException();
        }
        return EncodeUtil.removeNewLine(new String(Base64.encodeToByte(arg.getBytes(DEFAULT_CHARSET), false)));
    }

    public static String encodeWithBase64(String arg) {
        if (arg == null) {
            throw new NullPointerException();
        }
        return EncodeUtil.removeNewLine(new String(Base64.encodeToByte(arg.getBytes(DEFAULT_CHARSET), false)));
    }

    public static byte[] encodeWithBase64(byte[] arg) {
        if (arg == null) {
            throw new NullPointerException();
        }
        return Base64.decode(arg);
    }

    private static String removeNewLine(String input) {
        if (input == null || input.equals("")) {
            return input;
        }
        input = input.replaceAll("\r|\n", "");
        return input;
    }

    public static String decodeWithURLSafeBase64(String arg) {
        if (arg == null) {
            throw new NullPointerException();
        }
        return new String(Objects.requireNonNull(Base64.decode(arg.getBytes(DEFAULT_CHARSET))));
    }
}

