/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.media.trace;

import eleme.openapi.sdk.media.common.EncodeUtil;
import eleme.openapi.sdk.media.trace.ShorterUUID;
import eleme.openapi.sdk.media.utils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public class DeviceId {
    private String savePath;
    private String deviceId;

    public DeviceId(String savePath) {
        this.savePath = savePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue() {
        if (this.deviceId != null) {
            return this.deviceId;
        }
        DeviceId deviceId = this;
        synchronized (deviceId) {
            if (this.deviceId != null) {
                return this.deviceId;
            }
            this.deviceId = this.readFromFile();
            if (this.deviceId != null) {
                return this.deviceId;
            }
            this.deviceId = this.getUUID();
            this.writeToFile(this.deviceId);
            return this.deviceId;
        }
    }

    public byte[] asBytes(String id) {
        int i;
        UUID uuid = UUID.fromString(id);
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return buffer;
    }

    private String getUUID() {
        return ShorterUUID.uuid();
    }

    private String shorter(String arg) {
        byte[] res = EncodeUtil.encodeWithBase64(this.asBytes(arg));
        try {
            return new String(res, 0, res.length - 2, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromFile() {
        File file = new File(this.savePath);
        if (file.exists()) {
            String string;
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                string = IOUtils.toString(is);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly(is);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String writeToFile(String arg) {
        File file = new File(this.savePath);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "utf-8");
            writer.write(arg);
            writer.flush();
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(out);
                throw throwable2;
            }
        }
        IOUtils.closeQuietly(out);
        return null;
    }
}

