/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.media.trace;

import eleme.openapi.sdk.media.MediaConfiguration;
import eleme.openapi.sdk.media.trace.DeviceId;
import eleme.openapi.sdk.media.trace.Numbers;
import eleme.openapi.sdk.media.trace.Profiler;
import eleme.openapi.sdk.media.trace.ReportClient;
import eleme.openapi.sdk.media.trace.ReportStore;
import eleme.openapi.sdk.media.utils.IpUtils;
import eleme.openapi.sdk.utils.StringUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Reporter {
    private volatile boolean close = false;
    private volatile boolean shutdown = false;
    private Timer timer;
    private Thread worker;
    private volatile long lastLaunchTime;
    private final byte[] lock;
    private Queue<String> queue;
    private ReportClient reportService;
    private DeviceId deviceId;
    private String reportStartTime;
    private AtomicLong reportSequence;
    private boolean inited = false;
    private boolean needDebugLog = false;
    private CountDownLatch workerExitCountDownLatch;
    private static final String DEFAULT_DEVICE_ID_FILE_NAME = "ams_device";
    private Lock queueLock = new ReentrantLock();
    private volatile int queueSize = 0;
    private static Reporter instance = new Reporter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reporter sharedInstance() {
        if (!Reporter.instance.inited) {
            Reporter reporter = instance;
            synchronized (reporter) {
                if (!Reporter.instance.inited) {
                    instance.init();
                }
            }
        }
        return instance;
    }

    private String getLocalPath() {
        URL base = this.getClass().getClassLoader().getResource("");
        if (base == null) {
            base = this.getClass().getClassLoader().getResource("/");
        }
        String path = base == null ? System.getProperty("user.dir") : base.getPath();
        path = path.endsWith(File.separator) ? path : path + File.separator;
        this.D("device id path is " + path);
        return path;
    }

    private Reporter() {
        this.deviceId = new DeviceId(this.getLocalPath() + DEFAULT_DEVICE_ID_FILE_NAME);
        this.timer = new Timer("ams-report-timer");
        this.lock = new byte[1];
        Random random = new Random();
        this.queue = new ConcurrentLinkedQueue<String>();
        this.lastLaunchTime = 0L;
        this.reportStartTime = Numbers.toString(Long.parseLong(System.currentTimeMillis() / 1000L + "" + random.nextInt(100000)), Numbers.MAX_RADIX);
        this.reportSequence = new AtomicLong(0L);
        this.workerExitCountDownLatch = new CountDownLatch(1);
        this.reportService = new ReportClient();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                Reporter.this.shutdown();
            }
        }));
    }

    public void init() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!Reporter.this.shutdown) {
                    Reporter.this.D("try trigger notify");
                    if (Reporter.this.lastLaunchTime == 0L) {
                        Reporter.this.D("try trigger notify success");
                        Reporter.this.notifyAllWaiters();
                    } else if (System.currentTimeMillis() - Reporter.this.lastLaunchTime > 15000L) {
                        Reporter.this.D("try trigger notify success");
                        Reporter.this.notifyAllWaiters();
                    }
                }
            }
        }, 10000L, 5000L);
        this.createAndStartDispatchThread();
        this.inited = true;
    }

    public void shutdown() {
        this.D("try shutdown gracefully");
        this.shutdown = true;
        try {
            this.notifyAllWaiters();
            this.workerExitCountDownLatch.await(10L, TimeUnit.SECONDS);
            this.D("shutdown gracefully success");
        }
        catch (InterruptedException e) {
            this.D("interrupt at shutdown", e);
        }
        this.timer.cancel();
        this.D("timer cancel success");
    }

    private void createAndStartDispatchThread() {
        this.worker = this.createDispatchThread();
        this.worker.setName("ams-report-worker");
        this.worker.setUncaughtExceptionHandler(new WorkerThreadExceptionHandler(this));
        this.worker.start();
    }

    protected Thread createDispatchThread() {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                block4: while (true) {
                    Reporter.this.D("entering running loop.");
                    if (Reporter.this.shutdown && Reporter.this.queue.isEmpty()) break;
                    try {
                        Reporter.this.waitOnLock();
                        if (System.currentTimeMillis() - Reporter.this.lastLaunchTime < 5000L && !Reporter.this.shutdown) continue;
                        Reporter.this.lastLaunchTime = System.currentTimeMillis();
                        while (true) {
                            int count;
                            if (Reporter.this.queue.isEmpty()) continue block4;
                            Reporter.this.D("send report loop.");
                            ArrayList<String> reportList = new ArrayList<String>();
                            for (count = 0; !Reporter.this.queue.isEmpty() && count < 100; ++count) {
                                String report = Reporter.this.getReport();
                                if (report == null) break;
                                reportList.add(report);
                            }
                            try {
                                if (reportList.isEmpty()) continue;
                                Reporter.this.D("send {0} reports.", new Object[]{count});
                                Reporter.this.reportService.report(reportList);
                            }
                            catch (Exception e) {
                                Reporter.this.D("exception happened when send report. message: " + e.getMessage(), e);
                                if (Reporter.this.shutdown) {
                                    Reporter.this.D("break by shutdown and exception");
                                    continue block4;
                                }
                                for (String report : reportList) {
                                    Reporter.this.addReport(report);
                                }
                                Reporter.this.D("sleep 1 minute before retry");
                                Thread.sleep(60000L);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Reporter.this.D("running loop interrupted", e);
                        continue;
                    }
                    break;
                }
                Reporter.this.D("break by shutdown or queue size empty.");
                Reporter.this.workerExitCountDownLatch.countDown();
            }
        });
    }

    public void setTraceOn(boolean traceOn) {
        this.D("set trace on: " + traceOn);
        this.close = !traceOn;
    }

    public void start() {
        if (this.close || this.shutdown) {
            return;
        }
        Profiler.clear();
        Profiler.setStarted(true);
    }

    public void addKV(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return;
        }
        Profiler.getKVMap().put(key, value);
    }

    public void enter(OP op) {
        if (this.close || this.shutdown) {
            return;
        }
        if (!Profiler.getStarted().booleanValue()) {
            return;
        }
        Profiler.Factor factor = Profiler.getParameter(op.name());
        factor = factor == null ? new Profiler.Factor(-1L) : factor;
        factor.setStart(System.currentTimeMillis());
        Profiler.setParameter(op.name(), factor);
        this.D("start trace of op {0}", op.name());
    }

    public void release(OP op) {
        if (this.close || this.shutdown) {
            return;
        }
        if (!Profiler.getStarted().booleanValue()) {
            return;
        }
        Profiler.Factor factor = Profiler.getParameter(op.name());
        if (factor != null) {
            factor.setEnd(System.currentTimeMillis());
        }
    }

    private String getAk() {
        if (MediaConfiguration.getLastConfiguration() == null) {
            return null;
        }
        return MediaConfiguration.getLastConfiguration().getAk();
    }

    public void finish(String requestId, String uploadId, String message, String code, long uploadSize) {
        if (this.close || this.shutdown) {
            return;
        }
        this.D("finish trace");
        ReportStore reportNew = new ReportStore();
        reportNew.addFactor(ReportFactor.SDK_VERSION, "1.2.7");
        reportNew.addFactor(ReportFactor.SDK_TYPE, "JAVA");
        reportNew.addFactor(ReportFactor.OS, System.getProperty("os.name"));
        reportNew.addFactor(ReportFactor.OS_VERSION, System.getProperty("os.version"));
        reportNew.addFactor(ReportFactor.APPKEY, this.getAk());
        reportNew.addFactor(ReportFactor.RECORD_DATE, System.currentTimeMillis());
        reportNew.addFactor(ReportFactor.LOCAL_IP, IpUtils.getIpAddress());
        reportNew.addFactor(ReportFactor.REQUEST_ID, requestId);
        reportNew.addFactor(ReportFactor.SESSION_ID, uploadId);
        reportNew.addFactor(ReportFactor.VERSION, "1.0");
        reportNew.addArgs(ArgsFactor.CODE, code);
        reportNew.addArgs(ArgsFactor.MESSAGE, message);
        reportNew.addArgs(ArgsFactor.UPLOAD_SIZE, (Object)uploadSize);
        if (Profiler.getMap() != null) {
            block7: for (Map.Entry<String, Object> entry : Profiler.getMap().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                OP op = OP.valueOf(entry.getKey());
                switch (op) {
                    case UPLOAD: {
                        reportNew.addArgs(ArgsFactor.TOTAL_TIME, (Object)((Profiler.Factor)entry.getValue()).getInterval());
                        reportNew.addFactor(ReportFactor.EVENT_ID, op.desc);
                        continue block7;
                    }
                    case BLOCK_INIT: {
                        reportNew.addArgs(ArgsFactor.TOTAL_TIME, (Object)((Profiler.Factor)entry.getValue()).getInterval());
                        reportNew.addFactor(ReportFactor.EVENT_ID, op.desc);
                        continue block7;
                    }
                    case BLOCK_UPLOAD: {
                        reportNew.addArgs(ArgsFactor.TOTAL_TIME, (Object)((Profiler.Factor)entry.getValue()).getInterval());
                        reportNew.addFactor(ReportFactor.EVENT_ID, op.desc);
                        continue block7;
                    }
                    case BLOCK_COMPLETE: {
                        reportNew.addArgs(ArgsFactor.TOTAL_TIME, (Object)((Profiler.Factor)entry.getValue()).getInterval());
                        reportNew.addFactor(ReportFactor.EVENT_ID, op.desc);
                        continue block7;
                    }
                    case BLOCK_CANCEL: {
                        reportNew.addArgs(ArgsFactor.TOTAL_TIME, (Object)((Profiler.Factor)entry.getValue()).getInterval());
                        reportNew.addFactor(ReportFactor.EVENT_ID, op.desc);
                        continue block7;
                    }
                }
                reportNew.addArgs(op.desc, (Object)((Profiler.Factor)entry.getValue()).getInterval());
            }
        }
        if (Profiler.getKVMap() != null) {
            for (Map.Entry<String, Object> entry : Profiler.getKVMap().entrySet()) {
                reportNew.addArgs(entry.getKey(), (String)entry.getValue());
            }
        }
        this.D("add report: {0}", reportNew.getReport());
        Profiler.clear();
        this.addReport(reportNew.getReport());
    }

    public String getSessionId() {
        this.reportSequence.incrementAndGet();
        return this.deviceId.getValue() + "-" + this.reportStartTime + "-" + this.reportSequence.get();
    }

    private void addReport(String report) {
        if (this.close || this.shutdown) {
            return;
        }
        if (report == null) {
            return;
        }
        this.queueLock.lock();
        try {
            if (this.queueSize > 10240) {
                return;
            }
            boolean addResult = this.queue.add(report);
            if (addResult) {
                ++this.queueSize;
            }
            if (this.queueSize > 100) {
                this.notifyAllWaiters();
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    private String getReport() {
        this.queueLock.lock();
        try {
            String report = this.queue.poll();
            if (report != null) {
                --this.queueSize;
            }
            String string = report;
            return string;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnLock() throws InterruptedException {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.lock.wait();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllWaiters() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.lock.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void D(String pattern, Object ... args) {
    }

    private void D(String arg) {
    }

    private void D(String arg, Throwable t) {
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public static enum OP {
        UPLOAD("upload"),
        BLOCK_INIT("blockInit"),
        BLOCK_UPLOAD("blockUpload"),
        BLOCK_COMPLETE("blockComplete"),
        BLOCK_CANCEL("blockCancel"),
        DNS("dns"),
        OPEN_CONN("openConn"),
        FIRST_PACKET_ARRIVE("firstPacketArrive");

        public String desc;

        private OP(String desc) {
            this.desc = desc;
        }
    }

    public static enum ReportFactor {
        VERSION,
        OS,
        OS_VERSION,
        SDK_TYPE,
        SDK_VERSION,
        SESSION_ID,
        RECORD_DATE,
        EVENT_ID,
        LOCAL_IP,
        REQUEST_ID,
        APPKEY,
        ARGS;

    }

    public static enum ArgsFactor {
        CODE("code"),
        MESSAGE("message"),
        UPLOAD_SIZE("uploadSize"),
        TOTAL_TIME("totalTime"),
        DNS("dns"),
        OPEN_CONN("openConn"),
        FIRST_PACKET_ARRIVE("firstPacketArrive");

        String desc;

        private ArgsFactor(String desc) {
            this.desc = desc;
        }
    }

    private static class WorkerThreadExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        final Reporter reporter;

        public WorkerThreadExceptionHandler(Reporter reporter) {
            this.reporter = reporter;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!this.reporter.isShutdown()) {
                this.reporter.createAndStartDispatchThread();
            }
        }
    }
}

