/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.card.CardAccountInfo;
import eleme.openapi.sdk.api.entity.card.CardUserInfo;
import eleme.openapi.sdk.api.entity.card.CouponRequest;
import eleme.openapi.sdk.api.entity.card.TemplateInfo;
import eleme.openapi.sdk.api.entity.card.UploadResult;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service(value="eleme.card")
public class CardService
extends BaseNopService {
    public CardService(Config config, Token token) {
        super(config, token, CardService.class);
    }

    public UploadResult uploadImage(String imageBase64) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("imageBase64", imageBase64);
        return (UploadResult)this.call("eleme.card.uploadImage", params);
    }

    public String createTemplate(TemplateInfo templateInfo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateInfo", templateInfo);
        return (String)this.call("eleme.card.createTemplate", params);
    }

    public Map<String, TemplateInfo> mgetTemplateInfo(List<String> templateId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateId", templateId);
        return (Map)this.call("eleme.card.mgetTemplateInfo", params);
    }

    public Map<String, TemplateInfo> updateTemplate(String templateId, TemplateInfo templateInfo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateId", templateId);
        params.put("templateInfo", templateInfo);
        return (Map)this.call("eleme.card.updateTemplate", params);
    }

    public Map<String, List<String>> mgetShopIdsByTemplateIds(List<String> templateId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateId", templateId);
        return (Map)this.call("eleme.card.mgetShopIdsByTemplateIds", params);
    }

    public List<String> applyTemplate(String templateId, List<String> shopIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateId", templateId);
        params.put("shopIds", shopIds);
        return (List)this.call("eleme.card.applyTemplate", params);
    }

    public void openCard(String templateId, CardUserInfo cardUserInfo, CardAccountInfo cardAccountInfo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateId", templateId);
        params.put("cardUserInfo", cardUserInfo);
        params.put("cardAccountInfo", cardAccountInfo);
        this.call("eleme.card.openCard", params);
    }

    public void updateUserInfo(CardUserInfo cardUserInfo, CardAccountInfo cardAccountInfo) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cardUserInfo", cardUserInfo);
        params.put("cardAccountInfo", cardAccountInfo);
        this.call("eleme.card.updateUserInfo", params);
    }

    public CardUserInfo getUserByToken(String userToken) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userToken", userToken);
        return (CardUserInfo)this.call("eleme.card.getUserByToken", params);
    }

    public void confirmSendCoupon(CouponRequest couponRequest) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("couponRequest", couponRequest);
        this.call("eleme.card.confirmSendCoupon", params);
    }
}

