/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.cpc.OAllBalance;
import eleme.openapi.sdk.api.entity.cpc.ORankAndCostSummary;
import eleme.openapi.sdk.api.entity.cpc.ORankEffect;
import eleme.openapi.sdk.api.entity.cpc.OShopCertificationResponse;
import eleme.openapi.sdk.api.entity.cpc.OShopWagerEstimate;
import eleme.openapi.sdk.api.entity.cpc.OSuggestWagerInfo;
import eleme.openapi.sdk.api.entity.cpc.OUserDistribution;
import eleme.openapi.sdk.api.entity.cpc.OWagerInformation;
import eleme.openapi.sdk.api.entity.cpc.OWagerUVStatsSummary;
import eleme.openapi.sdk.api.enumeration.cpc.WagerAutoStatus;
import eleme.openapi.sdk.api.enumeration.cpc.WagerOpenStatus;
import eleme.openapi.sdk.api.enumeration.cpc.WagerSpeedMode;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;

@Service(value="eleme.cpc")
public class CpcService
extends BaseNopService {
    public CpcService(Config config, Token token) {
        super(config, token, CpcService.class);
    }

    public OAllBalance getAllBalance(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OAllBalance)this.call("eleme.cpc.getAllBalance", params);
    }

    public OShopCertificationResponse checkShopCertification(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OShopCertificationResponse)this.call("eleme.cpc.checkShopCertification", params);
    }

    public OWagerInformation getWagerInformation(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OWagerInformation)this.call("eleme.cpc.getWagerInformation", params);
    }

    public OShopWagerEstimate getWagerEstimate(long shopId, double bid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("bid", bid);
        return (OShopWagerEstimate)this.call("eleme.cpc.getWagerEstimate", params);
    }

    public OSuggestWagerInfo getSuggestWagerInfo(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OSuggestWagerInfo)this.call("eleme.cpc.getSuggestWagerInfo", params);
    }

    public int getResidueDegree(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (Integer)this.call("eleme.cpc.getResidueDegree", params);
    }

    public void updateWagerStatus(long shopId, WagerOpenStatus status) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("status", (Object)status);
        this.call("eleme.cpc.updateWagerStatus", params);
    }

    public void setWagerGrade(long shopId, double bid) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("bid", bid);
        this.call("eleme.cpc.setWagerGrade", params);
    }

    public void setWagerBudget(long shopId, double budget) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("budget", budget);
        this.call("eleme.cpc.setWagerBudget", params);
    }

    public void updateAutoStatus(long shopId, WagerAutoStatus autoStatus, List<Integer> launchHours) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("autoStatus", (Object)autoStatus);
        params.put("launchHours", launchHours);
        this.call("eleme.cpc.updateAutoStatus", params);
    }

    public void setWagerSpeed(long shopId, WagerSpeedMode wagerSpeedMode) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("wagerSpeedMode", (Object)wagerSpeedMode);
        this.call("eleme.cpc.setWagerSpeed", params);
    }

    public ORankEffect getActualRanking(long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (ORankEffect)this.call("eleme.cpc.getActualRanking", params);
    }

    public OWagerUVStatsSummary getUVSummary(long shopId, String beginDate, String endDate) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("beginDate", beginDate);
        params.put("endDate", endDate);
        return (OWagerUVStatsSummary)this.call("eleme.cpc.getUVSummary", params);
    }

    public ORankAndCostSummary getRankAndCostInfo(long shopId, String beginDate, String endDate) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("beginDate", beginDate);
        params.put("endDate", endDate);
        return (ORankAndCostSummary)this.call("eleme.cpc.getRankAndCostInfo", params);
    }

    public OUserDistribution getUserDistribution(long shopId, String date) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("date", date);
        return (OUserDistribution)this.call("eleme.cpc.getUserDistribution", params);
    }
}

