/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.shopCreditScore.OEquityRulesResponseVO;
import eleme.openapi.sdk.api.entity.shopCreditScore.OProgramEquityRulesVO;
import eleme.openapi.sdk.api.entity.shopCreditScore.OProgramPunishRulesVO;
import eleme.openapi.sdk.api.entity.shopCreditScore.OPunishRulesResponseVO;
import eleme.openapi.sdk.api.entity.shopCreditScore.OScoreRecordQueryRespVO;
import eleme.openapi.sdk.api.entity.shopCreditScore.OShopCreditScoreVO;
import eleme.openapi.sdk.api.entity.shopCreditScore.OShopPunishRecordVO;
import eleme.openapi.sdk.api.entity.shopCreditScore.OShopScoreRecordVO;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;

@Service(value="eleme.shopCreditScore")
public class ShopCreditScoreService
extends BaseNopService {
    public ShopCreditScoreService(Config config, Token token) {
        super(config, token, ShopCreditScoreService.class);
    }

    public List<OShopCreditScoreVO> batchQueryShopCreditScores(List<Long> shopIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        return (List)this.call("eleme.shopCreditScore.chain.batchQueryShopCreditScores", params);
    }

    public List<OEquityRulesResponseVO> batchQueryShopEquityRules(List<Long> shopIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        return (List)this.call("eleme.shopCreditScore.chain.batchQueryShopEquityRules", params);
    }

    public List<OPunishRulesResponseVO> batchQueryShopPunishRules(List<Long> shopIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        return (List)this.call("eleme.shopCreditScore.chain.batchQueryShopPunishRules", params);
    }

    public List<OScoreRecordQueryRespVO> batchQueryShopCreditScoreRecords(List<Long> shopIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        return (List)this.call("eleme.shopCreditScore.chain.batchQueryShopCreditScoreRecords", params);
    }

    public OShopCreditScoreVO getShopCreditScore(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (OShopCreditScoreVO)this.call("eleme.shopCreditScore.single.getShopCreditScore", params);
    }

    public OShopPunishRecordVO getShopPunishList(Long shopId, String eventId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("eventId", eventId);
        return (OShopPunishRecordVO)this.call("eleme.shopCreditScore.single.getShopPunishList", params);
    }

    public List<OProgramEquityRulesVO> getShopEquityRules(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.shopCreditScore.single.getShopEquityRules", params);
    }

    public List<OProgramPunishRulesVO> getShopPunishRules(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.shopCreditScore.single.getShopPunishRules", params);
    }

    public List<OShopScoreRecordVO> getShopCreditScoreRecord(Long shopId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return (List)this.call("eleme.shopCreditScore.single.getShopCreditScoreRecord", params);
    }
}

