/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.efs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import eleme.openapi.sdk.api.entity.content.OEfsConfig;
import eleme.openapi.sdk.api.exception.ServiceException;
import java.io.File;
import java.util.Properties;

public class EfsClient {
    private AmazonS3 s3client;
    private AWSCredentialsProvider credentialsProvider;
    private OEfsConfig efsConfig;

    public EfsClient(OEfsConfig efsConfig) {
        this.efsConfig = efsConfig;
    }

    public void init() {
        String accessId = this.efsConfig.getCredentials().getAccessKeyId();
        String secretKey = this.efsConfig.getCredentials().getSecretAccessKey();
        String token = this.efsConfig.getCredentials().getSessionToken();
        Properties properties = System.getProperties();
        properties.setProperty("com.amazonaws.services.s3.disablePutObjectMD5Validation", "true");
        BasicSessionCredentials credentials = new BasicSessionCredentials(accessId, secretKey, token);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setSignerOverride("AWSS3V4SignerType");
        this.credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        this.s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.efsConfig.getEfsAddress(), "eleme"))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withClientConfiguration(clientConfiguration)).withCredentials(this.credentialsProvider)).build();
    }

    public String putObject(File videoFile, String bucketName, String key) throws ServiceException {
        try {
            PutObjectResult result2 = this.s3client.putObject(new PutObjectRequest(bucketName, key, videoFile));
            return result2.getVersionId();
        }
        catch (AmazonServiceException ase) {
            throw new ServiceException("SERVER_ERROR", ase.getMessage());
        }
        catch (AmazonClientException ace) {
            throw new ServiceException("CLIENT_ERROR", ace.getMessage());
        }
    }
}

