package eleme.openapi.demo;

import eleme.openapi.sdk.api.entity.shop.OShop;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.api.service.ShopService;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.utils.JacksonUtils;

public class HttpPoolServiceTestDemo {

    public static void main(String[] args) {
        // 变量为true: 沙箱环境 false: 生产环境
        boolean isSandbox = false;
        // 当前环境key
        String appKey = "t2khk6TA4f36743514";

        // 当前环境secret
        String appSecret = "9715e6146de8b8e3a1e475e3d556f1eee040008fcdf";

        // 实例化一个配置类
        Config config = new Config(isSandbox, appKey, appSecret);
        config.setHttpPoolRequest(true);
        Token token = new Token();
        token.setAccessToken("7b948655c741740c7e912f7899f1c276cdf");
        System.out.println(JacksonUtils.obj2json(token));

        // 使用config和token对象，实例化一个服务对象
        ShopService shopService = new ShopService(config,token);

        // 调用服务方法，获取资源
        try {
            OShop shop = shopService.getShop(1174907302);
            System.out.println(shop.getName());
        } catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }
}
