package eleme.openapi.sdk.api.entity.activity;

import eleme.openapi.sdk.api.enumeration.activity.*;
import eleme.openapi.sdk.api.entity.activity.*;
import java.util.*;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;

public class CouponPresentRequest{

    /**
     * 请求id
     */
    private String requestId;
    public String getRequestId() {
        return requestId;
    }
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }
    
    /**
     * 业务来源，由饿了么分配
     */
    private String bizSource;
    public String getBizSource() {
        return bizSource;
    }
    public void setBizSource(String bizSource) {
        this.bizSource = bizSource;
    }
    
    /**
     * 业务场景，由饿了么分配
     */
    private String bizScene;
    public String getBizScene() {
        return bizScene;
    }
    public void setBizScene(String bizScene) {
        this.bizScene = bizScene;
    }
    
    /**
     * 券类型，1-店铺券，2-配送费券
     */
    private Integer couponType;
    public Integer getCouponType() {
        return couponType;
    }
    public void setCouponType(Integer couponType) {
        this.couponType = couponType;
    }
    
    /**
     * 店铺类型，1-连锁店，2-单店
     */
    private Integer shopType;
    public Integer getShopType() {
        return shopType;
    }
    public void setShopType(Integer shopType) {
        this.shopType = shopType;
    }
    
    /**
     * 连锁店ID，店铺类型为连锁店必传
     */
    private Long chainId;
    public Long getChainId() {
        return chainId;
    }
    public void setChainId(Long chainId) {
        this.chainId = chainId;
    }
    
    /**
     * 券可用店铺列表，店铺类型为单店必传
     */
    private List<Long> shopIdList;
    public List<Long> getShopIdList() {
        return shopIdList;
    }
    public void setShopIdList(List<Long> shopIdList) {
        this.shopIdList = shopIdList;
    }
    
    /**
     * 发券对象类型
     */
    private String targetType;
    public String getTargetType() {
        return targetType;
    }
    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }
    
    /**
     * 发券对象ID，如用户手机号
     */
    private String targetId;
    public String getTargetId() {
        return targetId;
    }
    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }
    
    /**
     * 券使用规则
     */
    private List<CouponContentDTO> content;
    public List<CouponContentDTO> getContent() {
        return content;
    }
    public void setContent(List<CouponContentDTO> content) {
        this.content = content;
    }
    
    /**
     * 券可用时间
     */
    private CouponAvailableTimeDTO availableTime;
    public CouponAvailableTimeDTO getAvailableTime() {
        return availableTime;
    }
    public void setAvailableTime(CouponAvailableTimeDTO availableTime) {
        this.availableTime = availableTime;
    }
    
    /**
     * 扩展字段
     */
    private Map<String,String> extInfo;
    public Map<String,String> getExtInfo() {
        return extInfo;
    }
    public void setExtInfo(Map<String,String> extInfo) {
        this.extInfo = extInfo;
    }
    
}