package eleme.openapi.sdk.api.entity.alliance;

import eleme.openapi.sdk.api.enumeration.alliance.*;
import eleme.openapi.sdk.api.entity.alliance.*;
import java.util.*;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;

public class UserOrderResultDTO{

    /**
     * 订单商品信息
     */
    private OrderItem orderItemList;
    public OrderItem getOrderItemList() {
        return orderItemList;
    }
    public void setOrderItemList(OrderItem orderItemList) {
        this.orderItemList = orderItemList;
    }
    
    /**
     * 订单详情链接
     */
    private String scheme;
    public String getScheme() {
        return scheme;
    }
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }
    
    /**
     * 订单创建时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date orderTime;
    public Date getOrderTime() {
        return orderTime;
    }
    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }
    
    /**
     * 订单优惠金额
     */
    private String discountedPrice;
    public String getDiscountedPrice() {
        return discountedPrice;
    }
    public void setDiscountedPrice(String discountedPrice) {
        this.discountedPrice = discountedPrice;
    }
    
    /**
     * 订单是否金额
     */
    private String payedPrice;
    public String getPayedPrice() {
        return payedPrice;
    }
    public void setPayedPrice(String payedPrice) {
        this.payedPrice = payedPrice;
    }
    
    /**
     * 店铺名称
     */
    private String shopName;
    public String getShopName() {
        return shopName;
    }
    public void setShopName(String shopName) {
        this.shopName = shopName;
    }
    
    /**
     * 订单配送地址
     */
    private String addressInfo;
    public String getAddressInfo() {
        return addressInfo;
    }
    public void setAddressInfo(String addressInfo) {
        this.addressInfo = addressInfo;
    }
    
    /**
     * 订单状态 WAIT_PAY("WAIT_PAY", "待付款"), PAID("PAID", "已付款"), SUCCESS("SUCCESS", "订单成功"), WAIT_PAY_CLOSE("WAIT_PAY_CLOSE", "主动取消"), CLOSED("CLOSED", "已关闭"), CANCELLED("CANCELLED", "已取消"), REFUNDED("REFUNDED", "交易关闭"), WAIT_ACCEPT("WAIT_ACCEPT", "待接单"), ACCEPTED("ACCEPTED", "商家已接单")
     */
    private String status;
    public String getStatus() {
        return status;
    }
    public void setStatus(String status) {
        this.status = status;
    }
    
    /**
     * 订单ID
     */
    private String orderId;
    public String getOrderId() {
        return orderId;
    }
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }
    
}